/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.repo;

import com.floragunn.encryption.at.rest.key_management.AESKey;
import com.floragunn.encryption.at.rest.repo.UnclosableOutputStreamWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.crypto.IllegalBlockSizeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.CheckedConsumer;

public class EncryptedBlobContainer
implements BlobContainer {
    private static Logger logger = LogManager.getLogger(EncryptedBlobContainer.class);
    private final AESKey repositoryKey;
    private final BlobContainer delegate;
    private final boolean supportUploadRetry;

    public EncryptedBlobContainer(BlobContainer delegate, AESKey repositoryKey, boolean supportUploadRetry) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        this.repositoryKey = Objects.requireNonNull(repositoryKey, "repositoryKey must not be null");
        this.supportUploadRetry = supportUploadRetry;
    }

    public BlobPath path() {
        return this.delegate.path();
    }

    public boolean blobExists(OperationPurpose operationPurpose, String blobName) throws IOException {
        return this.delegate.blobExists(operationPurpose, blobName);
    }

    public InputStream readBlob(OperationPurpose operationPurpose, String blobName) throws IOException {
        logger.trace("readBlob {} for {} purpose", (Object)blobName, (Object)operationPurpose);
        try {
            return AESKey.decryptingIn(this.delegate.readBlob(operationPurpose, blobName), this.repositoryKey, () -> this.delegate.readBlob(operationPurpose, blobName));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream readBlob(OperationPurpose operationPurpose, String blobName, long position, long length) throws IOException {
        logger.trace("readBlob {} for {} purpose starting at pos {} and length {}", (Object)blobName, (Object)operationPurpose, (Object)position, (Object)length);
        if (position < 0L) {
            throw new IllegalArgumentException("position must be non-negative");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        if (length == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            InputStream decryptedInputStream = AESKey.decryptingIn(this.delegate.readBlob(operationPurpose, blobName), this.repositoryKey, () -> this.delegate.readBlob(operationPurpose, blobName));
            InputStream consumed = EncryptedBlobContainer.fullyConsume(decryptedInputStream);
            consumed.skipNBytes(position);
            return Streams.limitStream((InputStream)consumed, (long)length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeBlob(OperationPurpose operationPurpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        logger.trace("writeBlob {} with size {} for {} purpose", (Object)blobName, (Object)blobSize, (Object)operationPurpose);
        try {
            InputStream encryptingIn = this.repositoryKey.newRandomWrapped().encryptingIn(inputStream);
            if (this.delegate instanceof FsBlobContainer || !this.supportUploadRetry) {
                this.delegate.writeBlob(operationPurpose, blobName, encryptingIn, EncryptedBlobContainer.expectedCiphertextSize(blobSize), failIfAlreadyExists);
            } else {
                this.delegate.writeBlob(operationPurpose, blobName, EncryptedBlobContainer.fullyConsume(encryptingIn), EncryptedBlobContainer.expectedCiphertextSize(blobSize), failIfAlreadyExists);
            }
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeBlobAtomic(OperationPurpose operationPurpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        logger.trace("writeBlobAtomic {} with size {} for {} purpose", (Object)blobName, (Object)bytes.length(), (Object)operationPurpose);
        try {
            InputStream encryptingIn = this.repositoryKey.newRandomWrapped().encryptingIn((InputStream)bytes.streamInput());
            this.delegate.writeBlobAtomic(operationPurpose, blobName, (BytesReference)new BytesArray(encryptingIn.readAllBytes()), failIfAlreadyExists);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeBlobAtomic(OperationPurpose operationPurpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        logger.trace("writeBlobAtomic {} with size {} for {} purpose", (Object)blobName, (Object)blobSize, (Object)operationPurpose);
        try {
            InputStream encryptingIn = this.repositoryKey.newRandomWrapped().encryptingIn(inputStream);
            this.delegate.writeBlobAtomic(operationPurpose, blobName, encryptingIn, blobSize, failIfAlreadyExists);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeBlob(OperationPurpose operationPurpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        logger.trace("writeBlob {} with size {} for {} purpose", (Object)blobName, (Object)bytes.length(), (Object)operationPurpose);
        try {
            InputStream encryptingIn = this.repositoryKey.newRandomWrapped().encryptingIn((InputStream)bytes.streamInput());
            this.delegate.writeBlob(operationPurpose, blobName, (BytesReference)new BytesArray(encryptingIn.readAllBytes()), failIfAlreadyExists);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeMetadataBlob(OperationPurpose operationPurpose, String blobName, boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
        logger.trace("writeMetadataBlob {} for {} purpose with atomic {}", (Object)blobName, (Object)operationPurpose, (Object)atomic);
        logger.trace("Preparation to write metadata blob for blob {} and purpose {}", (Object)blobName, (Object)operationPurpose);
        CheckedConsumer encryptedWriter = outputStream -> {
            try {
                logger.trace("Actual write of metadata blob for blob {} and purpose {}", (Object)blobName, (Object)operationPurpose);
                UnclosableOutputStreamWrapper unclosableOutputStreamWrapper = new UnclosableOutputStreamWrapper((OutputStream)outputStream);
                try (OutputStream encryptingStream = this.repositoryKey.newRandomWrapped().encryptingOut((OutputStream)((Object)unclosableOutputStreamWrapper));){
                    writer.accept((Object)encryptingStream);
                }
            }
            catch (IllegalBlockSizeException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
        };
        this.delegate.writeMetadataBlob(operationPurpose, blobName, failIfAlreadyExists, atomic, encryptedWriter);
    }

    private static long expectedCiphertextSize(long plaintextSize) {
        return plaintextSize + 40L + 12L + 16L + 4L;
    }

    private static InputStream fullyConsume(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        inputStream.transferTo(outputStream);
        inputStream.close();
        outputStream.close();
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public long readBlobPreferredLength() {
        return ByteSizeValue.ofMb((long)32L).getBytes();
    }

    public void compareAndExchangeRegister(OperationPurpose purpose, String key, BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) {
        this.delegate.compareAndExchangeRegister(purpose, key, expected, updated, listener);
    }

    public void compareAndSetRegister(OperationPurpose purpose, String key, BytesReference expected, BytesReference updated, ActionListener<Boolean> listener) {
        this.delegate.compareAndSetRegister(purpose, key, expected, updated, listener);
    }

    public Map<String, BlobContainer> children(OperationPurpose purpose) throws IOException {
        return this.delegate.children(purpose);
    }

    public DeleteResult delete(OperationPurpose purpose) throws IOException {
        return this.delegate.delete(purpose);
    }

    public void deleteBlobsIgnoringIfNotExists(OperationPurpose purpose, Iterator<String> blobNames) throws IOException {
        this.delegate.deleteBlobsIgnoringIfNotExists(purpose, blobNames);
    }

    public void getRegister(OperationPurpose purpose, String key, ActionListener<OptionalBytesReference> listener) {
        this.delegate.getRegister(purpose, key, listener);
    }

    public Map<String, BlobMetadata> listBlobs(OperationPurpose purpose) throws IOException {
        return this.delegate.listBlobs(purpose);
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(OperationPurpose purpose, String blobNamePrefix) throws IOException {
        return this.delegate.listBlobsByPrefix(purpose, blobNamePrefix);
    }
}

