/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.repo;

import com.floragunn.encryption.at.rest.key_management.AESKey;
import com.floragunn.encryption.at.rest.repo.EncryptedBlobContainer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.BlobStoreActionStats;

public class EncryptedBlobStore
implements BlobStore {
    private static Logger logger = LogManager.getLogger(EncryptedBlobStore.class);
    private final BlobStore delegate;
    private final boolean supportUploadRetry;
    private final AESKey repositoryKey;

    public EncryptedBlobStore(BlobStore delegate, AESKey repositoryKey, boolean supportUploadRetry) throws IOException {
        this.repositoryKey = Objects.requireNonNull(repositoryKey, "repositoryKey must not be null");
        this.delegate = delegate;
        this.supportUploadRetry = supportUploadRetry;
    }

    public BlobContainer blobContainer(BlobPath path) {
        logger.trace("Creating EncryptedBlobContainer for path {}", (Object)path);
        return new EncryptedBlobContainer(this.delegate.blobContainer(path), this.repositoryKey, this.supportUploadRetry);
    }

    public void close() throws IOException {
        logger.trace("Closing EncryptedBlobStore for delegate repo {}", (Object)this.delegate);
        this.delegate.close();
    }

    public Map<String, BlobStoreActionStats> stats() {
        return this.delegate.stats();
    }
}

