/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.action.initialize_key;

import com.floragunn.encryption.at.rest.action.update_key.UpdateKey;
import com.floragunn.encryption.at.rest.action.update_key.UpdateKeyResponse;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InitializeKeyResponse
extends AcknowledgedResponse {
    private final List<UpdateKey> updateKeyResponse;

    public InitializeKeyResponse(StreamInput in) throws IOException {
        super(in);
        this.updateKeyResponse = in.readCollectionAsList(UpdateKey::new);
    }

    public InitializeKeyResponse(UpdateKeyResponse updateKeyResponse) {
        super(true);
        this.updateKeyResponse = updateKeyResponse.getNodes();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.updateKeyResponse);
    }

    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (UpdateKey node : this.updateKeyResponse) {
            builder.startObject(node.getNode().getId());
            builder.field("nodeName", node.getNode().getName());
            builder.field("isMaster", node.isMaster());
            builder.field("keySet", node.isKeySet());
            builder.field("keySaved", node.isKeySaved());
            builder.endObject();
        }
        builder.endObject();
    }
}

