/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.plugin;

import com.floragunn.encryption.at.rest.key_management.ClusterKeK;
import java.security.PublicKey;
import java.util.Objects;
import org.apache.lucene.util.SetOnce;

public class KeyStore {
    private final SetOnce<ClusterKeK> clusterKeK = new SetOnce();
    private final SetOnce<PublicKey> publicClusterKey = new SetOnce();

    KeyStore() {
    }

    public boolean setClusterKeK(ClusterKeK clusterKeK) {
        return this.clusterKeK.trySet((Object)Objects.requireNonNull(clusterKeK, "Cluster kek a.k.a key encryption key must not be null"));
    }

    public PublicKey getPublicClusterKey() {
        return (PublicKey)this.publicClusterKey.get();
    }

    public boolean isPublicClusterKeySet() {
        return this.getPublicClusterKey() != null;
    }

    public ClusterKeK getClusterKeK() {
        return (ClusterKeK)this.clusterKeK.get();
    }

    public boolean isClusterKeySet() {
        return this.getClusterKeK() != null;
    }

    public void setPublicClusterKey(PublicKey publicKey) {
        this.publicClusterKey.trySet((Object)Objects.requireNonNull(publicKey, "Cannot set null public key"));
    }
}

