/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.TagStrategy;
import com.floragunn.encryption.at.rest.lucene.encryption.Utils;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class EncryptionMode {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final ThreadLocal<Cipher> JCE_GCM_CIPHER_POOL = ThreadLocal.withInitial(() -> {
        try {
            return Cipher.getInstance("AES/GCM/NoPadding", "SunJCE");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    });
    private static final ThreadLocal<Cipher> JCE_CTR_CIPHER_POOL = ThreadLocal.withInitial(() -> {
        try {
            return Cipher.getInstance("AES/CTR/NoPadding", "SunJCE");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    });
    static EncryptionMode Gcm512k = new JCEAESGcmMode(524288);
    static EncryptionMode Ctr512k = new JCEAESCtrMode(524288);

    public static EncryptionMode fromModeBytes(int modeBytes, int chunkSize) {
        if (modeBytes == 936237269) {
            return new JCEAESGcmMode(chunkSize);
        }
        if (modeBytes == -10081829) {
            return new NullMode(chunkSize);
        }
        if (modeBytes == 871016619) {
            return new JCEAESCtrMode(chunkSize);
        }
        throw new IllegalArgumentException("Unknown mode bytes: " + modeBytes);
    }

    protected EncryptionMode() {
    }

    public static int maxChunkSize() {
        return 0x800000;
    }

    public static int minChunkSize() {
        return 8192;
    }

    public static void validateChunkSize(int chunkSize) {
        if (chunkSize < EncryptionMode.minChunkSize()) {
            throw new IllegalArgumentException("Chunk size must be at least 8KB for AES GCM or CTR mode");
        }
        if (chunkSize > EncryptionMode.maxChunkSize()) {
            throw new IllegalArgumentException("Chunk size must be at most 8Mb for AES GCM or CTR mode");
        }
    }

    public abstract Nonce newNonce(long var1);

    public abstract int encrypt(FileKey var1, byte[] var2, int var3, int var4, long var5, byte[] var7, int var8) throws Exception;

    public abstract int decrypt(FileKey var1, ByteBuffer var2, ByteBuffer var3, long var4) throws Exception;

    public abstract int getTagLength();

    public abstract int getChunkSize();

    public abstract int getModeBytes();

    public TagStrategy getTagStrategy() {
        return TagStrategy.APPEND_TO_END;
    }

    public final int getChunkTagSize() {
        return this.getChunkSize() + this.getTagLength();
    }

    public String toString() {
        return "EncryptionMode " + this.getClass().getSimpleName() + " {tagLength=" + this.getTagLength() + ", chunkSize=" + this.getChunkSize() + ", tagStrategy=" + String.valueOf((Object)this.getTagStrategy()) + "}";
    }

    public static final class JCEAESGcmMode
    extends EncryptionMode {
        private final int chunkSize;
        static final int MODE_BYTES = 936237269;

        public JCEAESGcmMode(int chunkSize) {
            JCEAESGcmMode.validateChunkSize(chunkSize);
            this.chunkSize = chunkSize;
        }

        @Override
        public Nonce newNonce(long chunk) {
            return new GcmNonce(chunk);
        }

        @Override
        public int encrypt(FileKey fileKey, byte[] data, int offset, int length, long chunk, byte[] out, int outOffset) throws Exception {
            Cipher cipher = JCE_GCM_CIPHER_POOL.get();
            cipher.init(1, (Key)fileKey.asSecretKeySpec(), this.newNonce(chunk).asAlgorithmParameterSpec());
            return cipher.doFinal(data, offset, length, out, outOffset);
        }

        @Override
        public int decrypt(FileKey fileKey, ByteBuffer in, ByteBuffer out, long chunk) throws Exception {
            Nonce nonce = this.newNonce(chunk);
            Cipher cipher = JCE_GCM_CIPHER_POOL.get();
            cipher.init(2, (Key)fileKey.asSecretKeySpec(), nonce.asAlgorithmParameterSpec());
            return cipher.doFinal(in, out);
        }

        @Override
        public int getTagLength() {
            return 16;
        }

        @Override
        public int getChunkSize() {
            return this.chunkSize;
        }

        @Override
        public int getModeBytes() {
            return 936237269;
        }
    }

    public static final class NullMode
    extends EncryptionMode {
        private final int chunkSize;
        static final int MODE_BYTES = -10081829;

        public NullMode(int chunkSize) {
            NullMode.validateChunkSize(chunkSize);
            this.chunkSize = chunkSize;
        }

        @Override
        public Nonce newNonce(long chunk) {
            return new Nonce(this){

                @Override
                public AlgorithmParameterSpec asAlgorithmParameterSpec() {
                    return null;
                }
            };
        }

        @Override
        public int encrypt(FileKey fileKey, byte[] data, int offset, int length, long chunk, byte[] out, int outOffset) throws Exception {
            System.arraycopy(data, offset, out, outOffset, length);
            return length;
        }

        @Override
        public int decrypt(FileKey fileKey, ByteBuffer in, ByteBuffer out, long chunk) throws Exception {
            int ret = Math.min(in.remaining(), out.remaining());
            out.put(in);
            return ret;
        }

        @Override
        public int getTagLength() {
            return 0;
        }

        @Override
        public int getChunkSize() {
            return this.chunkSize;
        }

        @Override
        public int getModeBytes() {
            return -10081829;
        }
    }

    public static final class JCEAESCtrMode
    extends EncryptionMode {
        private final int chunkSize;
        static final int MODE_BYTES = 871016619;

        public JCEAESCtrMode(int chunkSize) {
            JCEAESCtrMode.validateChunkSize(chunkSize);
            this.chunkSize = chunkSize;
        }

        @Override
        public Nonce newNonce(long chunk) {
            return new CtrNonce(chunk);
        }

        @Override
        public int encrypt(FileKey fileKey, byte[] data, int offset, int length, long chunk, byte[] out, int outOffset) throws Exception {
            Cipher cipher = JCE_CTR_CIPHER_POOL.get();
            cipher.init(1, (Key)fileKey.asSecretKeySpec(), this.newNonce(chunk).asAlgorithmParameterSpec());
            return cipher.doFinal(data, offset, length, out, outOffset);
        }

        @Override
        public int decrypt(FileKey fileKey, ByteBuffer in, ByteBuffer out, long chunk) throws Exception {
            Nonce nonce = this.newNonce(chunk);
            Cipher cipher = JCE_CTR_CIPHER_POOL.get();
            cipher.init(2, (Key)fileKey.asSecretKeySpec(), nonce.asAlgorithmParameterSpec());
            return cipher.doFinal(in, out);
        }

        @Override
        public int getTagLength() {
            return 0;
        }

        @Override
        public int getChunkSize() {
            return this.chunkSize;
        }

        @Override
        public int getModeBytes() {
            return 871016619;
        }
    }

    static final class CtrNonce
    implements Nonce {
        private final byte[] value;

        CtrNonce(long chunk) {
            Objects.checkIndex(chunk, Long.MAX_VALUE);
            this.value = Utils.longToPaddedBytesBE(chunk, 8);
        }

        @Override
        public AlgorithmParameterSpec asAlgorithmParameterSpec() {
            return new IvParameterSpec(this.value);
        }

        public String toString() {
            return "CtrNonce{value=" + Arrays.toString(this.value) + "}";
        }
    }

    static final class GcmNonce
    implements Nonce {
        private final byte[] value;

        GcmNonce(long chunk) {
            Objects.checkIndex(chunk, Long.MAX_VALUE);
            this.value = Utils.longToPaddedBytesBE(chunk, 4);
        }

        @Override
        public AlgorithmParameterSpec asAlgorithmParameterSpec() {
            return new GCMParameterSpec(128, this.value);
        }

        public String toString() {
            return "GcmNonce{value=" + Arrays.toString(this.value) + "}";
        }
    }

    static interface Nonce {
        public AlgorithmParameterSpec asAlgorithmParameterSpec();
    }

    static final class FileKey {
        private final byte[] key;

        private FileKey(byte[] key) {
            this.key = key;
        }

        static FileKey fromBytes(byte[] bytes) {
            if (bytes == null || bytes.length != 32) {
                throw new IllegalArgumentException("FileKey must be 32 bytes long for AES/GCM mode");
            }
            return new FileKey((byte[])bytes.clone());
        }

        static FileKey random() {
            byte[] fileKeyBytes = new byte[32];
            SECURE_RANDOM.nextBytes(fileKeyBytes);
            return FileKey.fromBytes(fileKeyBytes);
        }

        SecretKeySpec asSecretKeySpec() {
            return new SecretKeySpec(this.key, "AES");
        }
    }
}

