/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents.patch;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.patch.DocPatch;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MergePatch
implements DocPatch {
    public static final String MEDIA_TYPE = "application/merge-patch+json";
    private final DocNode patchDocument;

    public MergePatch(DocNode patchDocument) {
        this.patchDocument = patchDocument;
    }

    @Override
    public DocNode apply(DocNode targetDocument) {
        return MergePatch.apply(targetDocument, this.patchDocument);
    }

    private static DocNode apply(DocNode targetDocument, DocNode patchDocument) {
        if (!patchDocument.isMap()) {
            return patchDocument;
        }
        if (!targetDocument.isMap()) {
            targetDocument = DocNode.EMPTY;
        }
        LinkedHashMap<String, Object> modifiedDocument = new LinkedHashMap<String, Object>(targetDocument.toNormalizedMap());
        for (Map.Entry entry : patchDocument.toMap().entrySet()) {
            Object targetValue = modifiedDocument.get(entry.getKey());
            if (entry.getValue() == null) {
                modifiedDocument.remove(entry.getKey());
                continue;
            }
            if (targetValue == null || !(entry.getValue() instanceof Map)) {
                modifiedDocument.put((String)entry.getKey(), entry.getValue());
                continue;
            }
            modifiedDocument.put((String)entry.getKey(), MergePatch.apply(DocNode.wrap(targetValue), DocNode.wrap(entry.getValue())));
        }
        return DocNode.wrap(modifiedDocument);
    }

    @Override
    public Object toBasicObject() {
        return this.patchDocument.toBasicObject();
    }

    public Object toTypedBasicObject() {
        return ImmutableMap.of((Object)"type", (Object)MEDIA_TYPE, (Object)"content", (Object)this.patchDocument.toBasicObject());
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE;
    }
}

