/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.directory;

import com.floragunn.encryption.at.rest.key_management.ClusterKeK;
import com.floragunn.encryption.at.rest.key_management.WrappedAESKey;
import com.floragunn.encryption.at.rest.key_management.WrappedAESKeyContainer;
import com.floragunn.encryption.at.rest.lucene.encryption.CryptoNIOFSDirectory;
import com.floragunn.encryption.at.rest.lucene.encryption.DecryptingMMapDirectory;
import com.floragunn.encryption.at.rest.lucene.encryption.DecryptionStrategy;
import com.floragunn.encryption.at.rest.lucene.encryption.DirectoryKey;
import com.floragunn.encryption.at.rest.lucene.encryption.EncryptionMode;
import com.floragunn.encryption.at.rest.plugin.EncryptionAtRestPluginSettings;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.Constants;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.FsDirectoryFactory;
import org.elasticsearch.index.store.LuceneFilesExtensions;
import org.elasticsearch.index.store.Store;

public class CryptoHybridDirectory
extends CryptoNIOFSDirectory {
    private static final String DIRECTORY_KEY_FILE_NAME = "_encrypted_directory_shard_key";
    private static final Logger logger = LogManager.getLogger(CryptoHybridDirectory.class);
    private final DecryptingMMapDirectory lazyDecryptingMMapDirectory;
    private final DecryptingMMapDirectory eagerDecryptingMMapDirectory;
    private final DirectoryDecider directoryDecider;
    private static final Lock LOCK = new ReentrantLock();

    public CryptoHybridDirectory(Path path, DirectoryKey directoryKey, EncryptionMode mode, DirectoryDecider directoryDecider) throws IOException {
        super(path, () -> directoryKey, mode);
        this.directoryDecider = Objects.requireNonNull(directoryDecider, "directoryDecider must not be null");
        this.lazyDecryptingMMapDirectory = new DecryptingMMapDirectory(path, () -> directoryKey, mode, DecryptionStrategy.LAZY);
        this.eagerDecryptingMMapDirectory = new DecryptingMMapDirectory(path, () -> directoryKey, mode, DecryptionStrategy.EAGER);
    }

    public CryptoHybridDirectory(Path path, DirectoryKey directoryKey, EncryptionMode mode) throws IOException {
        this(path, directoryKey, mode, DirectoryDecider.DEFAULT);
    }

    public CryptoHybridDirectory(IndexSettings indexSettings, ShardPath shardPath, Supplier<ClusterKeK> kekSupplier) throws IOException {
        super(shardPath.resolveIndex(), CryptoHybridDirectory.getLockFactory(indexSettings), () -> CryptoHybridDirectory.getOrCreateDirectoryKey(kekSupplier, shardPath), CryptoHybridDirectory.encryptionModeFrom(indexSettings));
        boolean allowMMap = EncryptionAtRestPluginSettings.INDEX_ALLOW_MMAP.getFrom(indexSettings.getSettings());
        if (allowMMap && Constants.JRE_IS_64BIT) {
            this.lazyDecryptingMMapDirectory = new DecryptingMMapDirectory(shardPath.resolveIndex(), CryptoHybridDirectory.getLockFactory(indexSettings), () -> CryptoHybridDirectory.getOrCreateDirectoryKey(kekSupplier, shardPath), CryptoHybridDirectory.encryptionModeFrom(indexSettings), DecryptionStrategy.LAZY);
            this.eagerDecryptingMMapDirectory = new DecryptingMMapDirectory(shardPath.resolveIndex(), CryptoHybridDirectory.getLockFactory(indexSettings), () -> CryptoHybridDirectory.getOrCreateDirectoryKey(kekSupplier, shardPath), CryptoHybridDirectory.encryptionModeFrom(indexSettings), DecryptionStrategy.EAGER);
        } else {
            logger.debug("MMap is not enabled or supported, using NIO instead");
            this.lazyDecryptingMMapDirectory = null;
            this.eagerDecryptingMMapDirectory = null;
        }
        this.directoryDecider = DirectoryDecider.DEFAULT;
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        DirectoryDecision decision;
        this.ensureCanRead(name);
        if (this.eagerDecryptingMMapDirectory == null || this.lazyDecryptingMMapDirectory == null || (decision = this.directoryDecider.decide(name, context, Files.size(this.getDirectory().resolve(name)))) == DirectoryDecision.NIO) {
            this.ensureOpen();
            logger.trace("Finally Using NIO for file {} with context {}", (Object)name, (Object)context.context());
            return super.openInput(name, context);
        }
        logger.trace("Finally Using {} for file {} with context {}", (Object)decision, (Object)name, (Object)context.context());
        switch (decision.ordinal()) {
            case 1: {
                return this.lazyDecryptingMMapDirectory.openInput(name, context);
            }
            case 2: {
                return this.eagerDecryptingMMapDirectory.openInput(name, context);
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)decision));
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{() -> super.close(), this.lazyDecryptingMMapDirectory, this.eagerDecryptingMMapDirectory});
    }

    protected static LockFactory getLockFactory(IndexSettings indexSettings) {
        return (LockFactory)indexSettings.getValue(FsDirectoryFactory.INDEX_LOCK_FACTOR_SETTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirectoryKey getOrCreateDirectoryKey(Supplier<ClusterKeK> kekSupplier, ShardPath shardPath) {
        ClusterKeK symmetricKek;
        logger.debug("Getting directory key for shard '{}'", (Object)shardPath.resolveIndex());
        if (kekSupplier == null || (symmetricKek = kekSupplier.get()) == null) {
            throw new RuntimeException("Encryption at Rest Plugin not initialized, run enctl.sh");
        }
        if (Files.exists(shardPath.resolveIndex().getParent().resolve(DIRECTORY_KEY_FILE_NAME), new LinkOption[0])) {
            try {
                DirectoryKey.fromBytes((byte[])CryptoHybridDirectory.decryptDirectoryKey(symmetricKek, shardPath));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOCK.lock();
        try {
            byte[] _key;
            try {
                _key = Files.exists(shardPath.resolveIndex().getParent().resolve(DIRECTORY_KEY_FILE_NAME), new LinkOption[0]) ? CryptoHybridDirectory.decryptDirectoryKey(symmetricKek, shardPath) : CryptoHybridDirectory.createNewDirectoryKey(symmetricKek, shardPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get or create directory key", e);
            }
            DirectoryKey directoryKey = DirectoryKey.fromBytes((byte[])_key);
            return directoryKey;
        }
        finally {
            LOCK.unlock();
        }
    }

    private static byte[] createNewDirectoryKey(ClusterKeK symmetricKek, ShardPath shardPath) throws Exception {
        WrappedAESKeyContainer wrappedAESKeyContainer = symmetricKek.newRandomWrapped();
        Files.write(shardPath.resolveIndex().getParent().resolve(DIRECTORY_KEY_FILE_NAME), wrappedAESKeyContainer.wrappedAESKey().bytes(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.SYNC, StandardOpenOption.DSYNC);
        logger.debug("Creating new directory key in '{}'", (Object)shardPath.resolveIndex().getParent());
        return wrappedAESKeyContainer.aesKey().bytes();
    }

    private static byte[] decryptDirectoryKey(ClusterKeK symmetricKek, ShardPath shardPath) throws Exception {
        logger.trace("Decrypting directory key in '{}'", (Object)shardPath.resolveIndex().getParent());
        byte[] encryptedKey = Files.readAllBytes(shardPath.resolveIndex().getParent().resolve(DIRECTORY_KEY_FILE_NAME));
        WrappedAESKey wrappedAESKey = new WrappedAESKey(encryptedKey);
        return symmetricKek.unwrapAESKey(wrappedAESKey).bytes();
    }

    private static EncryptionMode encryptionModeFrom(IndexSettings indexSettings) throws IOException {
        String mode = EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_MODE.getFrom(indexSettings.getSettings());
        int chunkSize = EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_CHUNKSIZE.getFrom(indexSettings.getSettings());
        switch (mode) {
            case "gcm": {
                return new EncryptionMode.JCEAESGcmMode(chunkSize);
            }
            case "ctr": {
                return new EncryptionMode.JCEAESCtrMode(chunkSize);
            }
        }
        throw new IllegalArgumentException("Unknown encryption mode: " + mode + ", must be either 'gcm' or 'ctr'");
    }

    static class DirectoryDecider {
        static final DirectoryDecider DEFAULT = new DirectoryDecider();
        static final DirectoryDecider ALWAYS_MMAP_LAZY = new DirectoryDecider(){

            @Override
            DirectoryDecision decide(String fileName, IOContext context, long fileSize) {
                return DirectoryDecision.MMAP_LAZY;
            }
        };
        static final DirectoryDecider ALWAYS_MMAP_EAGER = new DirectoryDecider(){

            @Override
            DirectoryDecision decide(String fileName, IOContext context, long fileSize) {
                return DirectoryDecision.MMAP_EAGER;
            }
        };
        static final DirectoryDecider ALWAYS_NIO = new DirectoryDecider(){

            @Override
            DirectoryDecision decide(String fileName, IOContext context, long fileSize) {
                return DirectoryDecision.NIO;
            }
        };

        DirectoryDecider() {
        }

        DirectoryDecision decide(String fileName, IOContext context, long fileSize) {
            if (fileSize == 0L) {
                return DirectoryDecision.NIO;
            }
            if (context == Store.READONCE_CHECKSUM) {
                return DirectoryDecision.NIO;
            }
            LuceneFilesExtensions extension = LuceneFilesExtensions.fromFile((String)fileName);
            if (extension == null || !extension.shouldMmap()) {
                return DirectoryDecision.NIO;
            }
            return fileSize <= 0x400000L ? DirectoryDecision.MMAP_EAGER : DirectoryDecision.MMAP_LAZY;
        }
    }

    static enum DirectoryDecision {
        NIO,
        MMAP_LAZY,
        MMAP_EAGER;

    }
}

