/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.key_management;

import com.floragunn.encryption.at.rest.support.ArrayUtil;
import java.util.Objects;

public class WrappedAESKey {
    public static final int LENGTH = 40;
    private final byte[] wrappedKey;

    public WrappedAESKey(byte[] wrappedKey) {
        Objects.requireNonNull(wrappedKey, "wrappedKey must not be null");
        if (wrappedKey.length != 40) {
            throw new IllegalArgumentException("wrappedKey must be 40 bytes long, was " + wrappedKey.length);
        }
        if (ArrayUtil.isAllZeros(wrappedKey)) {
            throw new IllegalArgumentException("wrappedKey must not be all zeros");
        }
        this.wrappedKey = (byte[])wrappedKey.clone();
    }

    public byte[] bytes() {
        return (byte[])this.wrappedKey.clone();
    }
}

