/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation.errors;

import com.fasterxml.jackson.core.JsonLocation;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.FileDoesNotExist;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.JsonValidationError;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.UnsupportedAttribute;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationError
implements Document<ValidationError> {
    private static final Logger log = LoggerFactory.getLogger(ValidationError.class);
    private String attribute;
    private String message;
    private Throwable cause;
    private Object docNode;
    private Object expected;

    public ValidationError(String attribute, String message) {
        this.attribute = attribute != null ? attribute : "_";
        this.message = message;
    }

    public ValidationError(String attribute, String message, Object jsonNode) {
        this.attribute = attribute != null ? attribute : "_";
        this.message = message;
        this.docNode = jsonNode;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getMessage() {
        return this.message;
    }

    public ValidationError message(String message) {
        this.message = message;
        return this;
    }

    public ValidationError cause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public ValidationError expected(Object expected) {
        this.expected = expected;
        return this;
    }

    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public Map<String, Object> toBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("error", this.message);
        if (this.expected != null) {
            result.put("expected", this.getExpectedAsString());
        }
        return result;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String toString() {
        return this.message + (this.getExpected() != null ? "; expected: " + this.getExpectedAsString() : "") + "; attribute: " + this.getAttribute();
    }

    public String toValidationErrorsOverviewString() {
        if (this.getExpected() != null) {
            return this.message + "; expected: " + this.getExpectedAsString();
        }
        return this.message;
    }

    public static List<ValidationError> parseArray(String attribute, DocNode docNode) {
        if (!docNode.isList()) {
            return Collections.singletonList(ValidationError.parse(attribute, docNode));
        }
        ArrayList<ValidationError> result = new ArrayList<ValidationError>(docNode.size());
        for (DocNode subDocNode : docNode.getAsListOfNodes(null)) {
            result.add(ValidationError.parse(attribute, subDocNode));
        }
        return result;
    }

    public static ValidationError parse(String attribute, DocNode docNode) {
        if (!docNode.isMap()) {
            return new ValidationError(attribute, docNode.getAsString(null));
        }
        if (!(docNode.get("error") instanceof String)) {
            return new ValidationError(attribute, docNode.getAsString(null));
        }
        String error = docNode.getAsString("error");
        if (error.equalsIgnoreCase("Invalid value") && docNode.containsKey("value")) {
            return new InvalidAttributeValue(attribute, docNode.get("value"), docNode.get("expected"));
        }
        if (error.equalsIgnoreCase("File does not exist")) {
            try {
                return new FileDoesNotExist(attribute, docNode.hasNonNull("value") ? new File(docNode.getAsString("value")) : null);
            }
            catch (Exception e) {
                return new ValidationError(attribute, "File nodes not exist: " + docNode.getAsString("value"));
            }
        }
        if (error.startsWith("Invalid JSON")) {
            JsonLocation jsonLocation = null;
            if (docNode.get("line") instanceof Number && docNode.get("column") instanceof Number) {
                try {
                    jsonLocation = new JsonLocation(null, -1L, docNode.getNumber("line").intValue(), docNode.getNumber("column").intValue());
                }
                catch (ConfigValidationException e) {
                    log.warn("Error while parsing JsonLocation in {}", (Object)docNode, (Object)e);
                }
            }
            return new JsonValidationError(attribute, error, jsonLocation, docNode.getAsString("context"));
        }
        if (error.equalsIgnoreCase("Required attribute is missing")) {
            return new MissingAttribute(attribute);
        }
        if (error.equalsIgnoreCase("Unsupported attribute")) {
            return new UnsupportedAttribute(attribute, docNode.get("value"), null);
        }
        return new ValidationError(attribute, error);
    }

    public Object getDocNode() {
        return this.docNode;
    }

    public ValidationError docNode(Object docNode) {
        this.docNode = docNode;
        return this;
    }

    protected ValidationError clone() {
        return new ValidationError(this.attribute, this.message).cause(this.cause).docNode(this.docNode);
    }

    public Object getExpected() {
        return this.expected;
    }

    public String getExpectedAsString() {
        return ValidationError.expectedToString(this.getExpected());
    }

    private static String expectedToString(Object expected) {
        if (expected == null) {
            return null;
        }
        if (expected instanceof Class && ((Class)expected).isEnum()) {
            return ValidationError.getEnumValues((Class)expected);
        }
        return expected.toString();
    }

    private static <E extends Enum<E>> String getEnumValues(Class<E> enumClass) {
        StringBuilder result = new StringBuilder();
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(e.name());
        }
        return result.toString();
    }
}

