/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.key_management;

import com.floragunn.encryption.at.rest.key_management.WrappedAESKey;
import com.floragunn.encryption.at.rest.key_management.WrappedAESKeyContainer;
import com.floragunn.encryption.at.rest.lucene.encryption.Utils;
import com.floragunn.encryption.at.rest.support.ArrayUtil;
import com.floragunn.encryption.at.rest.support.KeyWrapUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.lucene.util.IOUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMModeCipher;
import org.bouncycastle.crypto.modes.GCMSIVBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;

public class AESKey {
    public static final int STREAM_MAGIC_BYTES = -281901;
    static final byte[] EMPTY_NONCE = new byte[12];
    static final ThreadLocal<GCMSIVBlockCipher> GCM_SIV_CIPHER_POOL = ThreadLocal.withInitial(() -> {
        try {
            return new GCMSIVBlockCipher((BlockCipher)AESEngine.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    });
    static final ThreadLocal<GCMModeCipher> GCM_CIPHER_POOL = ThreadLocal.withInitial(() -> {
        try {
            return GCMBlockCipher.newInstance((BlockCipher)AESEngine.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    });
    static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final byte[] keyBytes;

    public AESKey(byte[] keyBytes) {
        Objects.requireNonNull(keyBytes, "keyBytes must not be null");
        if (keyBytes.length != 32) {
            throw new IllegalArgumentException("keyBytes must be 32 bytes long");
        }
        if (ArrayUtil.isAllZeros(keyBytes)) {
            throw new IllegalArgumentException("keyBytes must not be all zeros");
        }
        this.keyBytes = (byte[])keyBytes.clone();
    }

    public static AESKey random() {
        byte[] keyBytes = new byte[32];
        SECURE_RANDOM.nextBytes(keyBytes);
        return new AESKey(keyBytes);
    }

    public static BytesReference decryptWithSiv(byte[] cipherText, AESKey key, byte[] aad) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        WrappedAESKey wrappedAESKey = new WrappedAESKey(Arrays.copyOf(cipherText, 40));
        AESKey unWrappedKey = key.unwrapAESKey(wrappedAESKey);
        GCMSIVBlockCipher gcmsivBlockCipher = GCM_SIV_CIPHER_POOL.get();
        gcmsivBlockCipher.init(false, (CipherParameters)new AEADParameters(new KeyParameter(unWrappedKey.bytes()), 128, EMPTY_NONCE, aad));
        BytesArray bytesArray = new BytesArray(cipherText);
        CipherInputStream in = new CipherInputStream((InputStream)bytesArray.slice(40, bytesArray.length() - 40).streamInput(), (AEADBlockCipher)gcmsivBlockCipher);
        return new BytesArray(in.readAllBytes());
    }

    public static InputStream decryptingIn(InputStream in, AESKey key, Callable<InputStream> unencryptedIn) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        Objects.requireNonNull(in, "in must not be null");
        Objects.requireNonNull(key, "key must not be null");
        GCMModeCipher gcmBlockCipher = GCM_CIPHER_POOL.get();
        byte[] magic = new byte[4];
        byte[] wrappedKey = new byte[40];
        byte[] nonce = new byte[12];
        in.read(magic);
        if (Utils.bytesBEToInt((byte[])magic) != -281901) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            if (unencryptedIn == null) {
                return null;
            }
            try {
                return unencryptedIn.call();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        in.read(wrappedKey);
        in.read(nonce);
        AESKey unWrappedKey = key.unwrapAESKey(new WrappedAESKey(wrappedKey));
        gcmBlockCipher.init(false, (CipherParameters)new AEADParameters(new KeyParameter(unWrappedKey.bytes()), 128, nonce, null));
        return new CipherInputStream(in, (AEADBlockCipher)gcmBlockCipher);
    }

    public byte[] bytes() {
        return (byte[])this.keyBytes.clone();
    }

    public WrappedAESKeyContainer newRandomWrapped() throws IllegalBlockSizeException, InvalidKeyException {
        AESKey toWrap = AESKey.random();
        return new WrappedAESKeyContainer(toWrap, KeyWrapUtil.encrypt(toWrap, this));
    }

    public AESKey unwrapAESKey(WrappedAESKey wrappedAESKey) throws NoSuchAlgorithmException, InvalidKeyException {
        return KeyWrapUtil.decrypt(wrappedAESKey, this);
    }

    public Key asSecretKeySpec() {
        return new SecretKeySpec(this.keyBytes, "AES");
    }
}

