/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;

public class PanamaNativeAccess {
    private static final Linker LINKER = Linker.nativeLinker();
    private static final MethodHandle MADVISE;
    private static final SymbolLookup LIBC;
    public static final int MADV_DONTNEED = 4;

    public static void madvise(long address, long length, int advice) throws Throwable {
        int rc = MADVISE.invokeExact(MemorySegment.ofAddress(address), length, advice);
        if (rc != 0) {
            throw new RuntimeException("madvise failed with rc=" + rc);
        }
    }

    static {
        LIBC = LINKER.defaultLookup();
        try {
            MADVISE = LINKER.downcallHandle(LIBC.find("madvise").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT), new Linker.Option[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to load madvise", e);
        }
    }
}

