/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.support;

import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.threadpool.ThreadPool;

public class BaseDependencies {
    private final SetOnce<Settings> settings = new SetOnce();
    private final SetOnce<Client> localClient = new SetOnce();
    private final SetOnce<ClusterService> clusterService = new SetOnce();
    private final SetOnce<ThreadPool> threadPool = new SetOnce();
    private final SetOnce<Environment> environment = new SetOnce();
    private final SetOnce<RepositoriesService> repositoriesService = new SetOnce();
    private final SetOnce<IndicesService> indicesService = new SetOnce();

    public void setDependencies(Settings settings, Client localClient, ClusterService clusterService, ThreadPool threadPool, Environment environment, RepositoriesService repositoriesService, IndicesService indicesService) {
        this.set(Objects.requireNonNull(settings, "Settings must not be null"), arg_0 -> this.settings.trySet(arg_0));
        this.set(Objects.requireNonNull(localClient, "Client must not be null"), arg_0 -> this.localClient.trySet(arg_0));
        this.set(Objects.requireNonNull(clusterService, "ClusterService must not be null"), arg_0 -> this.clusterService.trySet(arg_0));
        this.set(Objects.requireNonNull(threadPool, "ThreadPool must not be null"), arg_0 -> this.threadPool.trySet(arg_0));
        this.set(Objects.requireNonNull(environment, "Environment must not be null"), arg_0 -> this.environment.trySet(arg_0));
        this.set(Objects.requireNonNull(repositoriesService, "RepositoriesService must not be null"), arg_0 -> this.repositoriesService.trySet(arg_0));
        this.set(Objects.requireNonNull(indicesService, "IndicesService must not be null"), arg_0 -> this.indicesService.trySet(arg_0));
    }

    public Settings getSettings() {
        return (Settings)this.settings.get();
    }

    public Client getLocalClient() {
        return (Client)this.localClient.get();
    }

    public ClusterService getClusterService() {
        return (ClusterService)this.clusterService.get();
    }

    public ThreadPool getThreadPool() {
        return (ThreadPool)this.threadPool.get();
    }

    public Environment getEnvironment() {
        return (Environment)this.environment.get();
    }

    public RepositoriesService getRepositoriesService() {
        return (RepositoriesService)this.repositoriesService.get();
    }

    public IndicesService getIndicesService() {
        return (IndicesService)this.indicesService.get();
    }

    private <T> void set(T object, Function<T, Boolean> onlyOnceSetter) {
        boolean setResult = onlyOnceSetter.apply(object);
        if (!setResult) {
            throw new IllegalStateException("Object of type " + object.getClass().getName() + " already set");
        }
    }
}

