/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.CryptoNIOFSDirectory;
import com.floragunn.encryption.at.rest.lucene.encryption.DecryptingMMapDirectory;
import com.floragunn.encryption.at.rest.lucene.encryption.DecryptingMemorySegmentIndexInput;
import com.floragunn.encryption.at.rest.lucene.encryption.DecryptionStrategy;
import com.floragunn.encryption.at.rest.lucene.encryption.DirectoryKey;
import com.floragunn.encryption.at.rest.lucene.encryption.Footer;
import com.floragunn.encryption.at.rest.lucene.encryption.MultiSegmentBuffer;
import com.floragunn.encryption.at.rest.lucene.encryption.NativeAccess;
import com.floragunn.encryption.at.rest.lucene.encryption.RefCountedSharedArena;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.Unwrappable;

final class DecryptingMemorySegmentIndexInputProvider
implements DecryptingMMapDirectory.MMapIndexInputProvider<ConcurrentHashMap<String, RefCountedSharedArena>> {
    private final Optional<NativeAccess> nativeAccess = NativeAccess.getImplementation();
    private final int sharedArenaMaxPermits;

    public DecryptingMemorySegmentIndexInputProvider(int maxPermits) {
        this.sharedArenaMaxPermits = DecryptingMemorySegmentIndexInputProvider.checkMaxPermits(maxPermits);
    }

    @Override
    public IndexInput openInput(Path path, IOContext context, int chunkSizePower, boolean preload, Optional<String> group, ConcurrentHashMap<String, RefCountedSharedArena> arenas, DirectoryKey directoryKey, DecryptionStrategy decryptionStrategy) throws IOException {
        String resourceDescription = "DecryptingMemorySegmentIndexInput(decryptionStrategy=\"" + String.valueOf((Object)decryptionStrategy) + "\", path=\"" + path.toString() + "\")";
        Objects.requireNonNull(directoryKey, "Directory key must not be null");
        path = (Path)Unwrappable.unwrapAll((Object)path);
        boolean success = false;
        boolean confined = context == IOContext.READONCE;
        Arena arena = confined ? Arena.ofConfined() : Arena.ofShared();
        try {
            DecryptingMemorySegmentIndexInput decryptingMemorySegmentIndexInput;
            block13: {
                FileChannel fc = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.READ);
                try {
                    MemorySegment[] segments0;
                    long fileSize = fc.size();
                    String fileName = path.getFileName().toString();
                    MemorySegment[] segments = segments0 = this.map(arena, resourceDescription, fc, chunkSizePower, preload, fileSize);
                    long effectiveFileSize = fileSize;
                    Footer footer = null;
                    if (CryptoNIOFSDirectory.isEncrypted(fileName)) {
                        boolean effectiveEmpty;
                        boolean bl = effectiveEmpty = segments0.length == 0 || fileSize <= (long)Footer.MIN_SIZE;
                        if (effectiveEmpty) {
                            segments = this.setAllToLengthZero(segments0);
                            effectiveFileSize = 0L;
                        } else {
                            footer = this.readFooter(segments0, directoryKey);
                            effectiveFileSize = footer.getPlainTextFileSize();
                        }
                    }
                    DecryptingMemorySegmentIndexInput in = DecryptingMemorySegmentIndexInput.newInstance(resourceDescription, arena, segments, effectiveFileSize, chunkSizePower, confined, path, footer, decryptionStrategy);
                    success = true;
                    decryptingMemorySegmentIndexInput = in;
                    if (fc == null) break block13;
                }
                catch (Throwable throwable) {
                    if (fc != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fc.close();
            }
            return decryptingMemorySegmentIndexInput;
        }
        finally {
            if (!success) {
                arena.close();
            }
        }
    }

    private MemorySegment[] setAllToLengthZero(MemorySegment[] segments) {
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i] == null) continue;
            segments[i] = segments[i].reinterpret(0L);
        }
        return segments;
    }

    @Override
    public long getDefaultMaxChunkSize() {
        return Constants.JRE_IS_64BIT ? 0x400000000L : 0x10000000L;
    }

    @Override
    public boolean supportsMadvise() {
        return this.nativeAccess.isPresent();
    }

    private Footer readFooter(MemorySegment[] segments, DirectoryKey directoryKey) throws IOException {
        MultiSegmentBuffer multiSegmentBuffer = new MultiSegmentBuffer(segments);
        ByteBuffer footerSizeBuffer = ByteBuffer.allocate(4);
        multiSegmentBuffer.read(multiSegmentBuffer.size() - (long)Footer.LENGTH_INFO_OFFSET, footerSizeBuffer);
        footerSizeBuffer.flip();
        int footerSize = footerSizeBuffer.getInt();
        footerSizeBuffer = null;
        ByteBuffer footerBuffer = ByteBuffer.allocate(footerSize);
        multiSegmentBuffer.read(multiSegmentBuffer.size() - (long)footerSize, footerBuffer);
        footerBuffer.flip();
        Footer footer = Footer.readFrom(footerBuffer, directoryKey);
        footerBuffer = null;
        assert (footer != null);
        assert (footer.getChunkCount() != 0L);
        return footer;
    }

    private final MemorySegment[] map(Arena arena, String resourceDescription, FileChannel fc, int chunkSizePower, boolean preload, long length) throws IOException {
        if (length >>> chunkSizePower >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big for chunk size: " + resourceDescription);
        }
        long chunkSize = 1L << chunkSizePower;
        int nrSegments = (int)(length >>> chunkSizePower) + 1;
        MemorySegment[] segments = new MemorySegment[nrSegments];
        long startOffset = 0L;
        for (int segNr = 0; segNr < nrSegments; ++segNr) {
            MemorySegment segment;
            long segSize = length > startOffset + chunkSize ? chunkSize : length - startOffset;
            try {
                segment = fc.map(FileChannel.MapMode.PRIVATE, startOffset, segSize, arena);
            }
            catch (IOException ioe) {
                throw this.convertMapFailedIOException(ioe, resourceDescription, segSize);
            }
            if (preload) {
                segment.load();
            } else if (!this.nativeAccess.isPresent() || chunkSizePower >= 21) {
                // empty if block
            }
            segments[segNr] = segment;
            startOffset += segSize;
        }
        return segments;
    }

    @Override
    public ConcurrentHashMap<String, RefCountedSharedArena> attachment() {
        return new ConcurrentHashMap<String, RefCountedSharedArena>();
    }

    private static int checkMaxPermits(int maxPermits) {
        if (RefCountedSharedArena.validMaxPermits(maxPermits)) {
            return maxPermits;
        }
        Logger.getLogger(DecryptingMemorySegmentIndexInputProvider.class.getName()).warning("Invalid value for sysprop org.apache.lucene.store.DecryptingMMapDirectory.sharedArenaMaxPermits, must be positive and <= 0x07FF. The default value will be used.");
        return 1024;
    }

    private Arena getSharedArena(Optional<String> group, ConcurrentHashMap<String, RefCountedSharedArena> arenas) {
        if (group.isEmpty()) {
            return Arena.ofShared();
        }
        String key = group.get();
        RefCountedSharedArena refCountedArena = arenas.computeIfAbsent(key, s -> new RefCountedSharedArena((String)s, () -> arenas.remove(s), this.sharedArenaMaxPermits));
        if (refCountedArena.acquire()) {
            return refCountedArena;
        }
        return arenas.compute(key, (s, v) -> {
            if (v != null && v.acquire()) {
                return v;
            }
            v = new RefCountedSharedArena((String)s, () -> arenas.remove(s), this.sharedArenaMaxPermits);
            v.acquire();
            return v;
        });
    }
}

