/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.repo;

import com.floragunn.encryption.at.rest.plugin.KeyStore;
import com.floragunn.encryption.at.rest.repo.EncryptedRepository;
import com.floragunn.encryption.at.rest.support.BaseDependencies;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class EncryptedRepositoryFactory
implements Repository.Factory {
    private static Logger logger = LogManager.getLogger(EncryptedRepositoryFactory.class);
    public static final Setting<String> STORAGE_TYPE_SETTING = Setting.simpleString((String)"storage_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static ByteSizeValue CHUNK_SIZE_MAX = ByteSizeValue.of((long)32L, (ByteSizeUnit)ByteSizeUnit.GB);
    public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)ByteSizeValue.of((long)128L, (ByteSizeUnit)ByteSizeUnit.MB), (ByteSizeValue)ByteSizeValue.of((long)8L, (ByteSizeUnit)ByteSizeUnit.MB), (ByteSizeValue)CHUNK_SIZE_MAX, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Boolean> SUPPORT_UPLOAD_RETRY = Setting.boolSetting((String)"support_upload_retry", (boolean)true, (Setting.Property[])new Setting.Property[0]);
    public static final List<String> SUPPORTED_STORAGE_TYPES = List.of("azure", "fs", "gcs", "s3");
    private final RecoverySettings recoverySettings;
    private final BigArrays bigArrays;
    private final NamedXContentRegistry namedXContentRegistry;
    private final ClusterService clusterService;
    private final KeyStore keyStore;
    private final SnapshotMetrics snapshotMetrics;

    public EncryptedRepositoryFactory(BigArrays bigArrays, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings, KeyStore keyStore, BaseDependencies baseDependencies, SnapshotMetrics snapshotMetrics) {
        this.bigArrays = bigArrays;
        this.namedXContentRegistry = namedXContentRegistry;
        this.clusterService = clusterService;
        this.recoverySettings = recoverySettings;
        this.keyStore = Objects.requireNonNull(keyStore, "KeyStore must not be null");
        this.snapshotMetrics = Objects.requireNonNull(snapshotMetrics, "Snapshot metrics are required");
    }

    public Repository create(ProjectId projectId, RepositoryMetadata metadata) throws Exception {
        throw new UnsupportedOperationException("Couldn't create a encrypted repository without storage type set");
    }

    public Repository create(ProjectId projectId, RepositoryMetadata metadata, Function<String, Repository.Factory> typeLookup) throws Exception {
        if (!STORAGE_TYPE_SETTING.exists(metadata.settings())) {
            throw new SettingsException("Setting " + STORAGE_TYPE_SETTING.getKey() + " hasn't been set. Supported are: " + String.valueOf(SUPPORTED_STORAGE_TYPES));
        }
        String storageType = (String)STORAGE_TYPE_SETTING.get(metadata.settings());
        if (!SUPPORTED_STORAGE_TYPES.contains(storageType)) {
            throw new SettingsException("Unsupported storage type " + storageType + " for " + STORAGE_TYPE_SETTING.getKey() + ". Supported are: " + String.valueOf(SUPPORTED_STORAGE_TYPES));
        }
        Repository.Factory storageFactory = typeLookup.apply(storageType);
        if (Objects.isNull(storageFactory)) {
            throw new IllegalArgumentException("Couldn't create repository type of " + storageType);
        }
        ByteSizeValue calculatedChunkSize = (ByteSizeValue)CHUNK_SIZE_SETTING.get(metadata.settings());
        if (!(metadata.settings().hasValue(CHUNK_SIZE_SETTING.getKey()) || !storageType.equalsIgnoreCase("fs") && ((Boolean)SUPPORT_UPLOAD_RETRY.get(metadata.settings())).booleanValue())) {
            calculatedChunkSize = CHUNK_SIZE_MAX;
        }
        logger.info("Effective chunk_size for {} is {}", (Object)metadata.name(), (Object)calculatedChunkSize);
        Settings newMetadataSettings = Settings.builder().put(metadata.settings()).put(CHUNK_SIZE_SETTING.getKey(), calculatedChunkSize).build();
        BlobStoreRepository delegateRepo = (BlobStoreRepository)storageFactory.create(projectId, new RepositoryMetadata(metadata.name(), storageType, newMetadataSettings));
        return new EncryptedRepository(projectId, this.bigArrays, delegateRepo, metadata, this.namedXContentRegistry, this.clusterService, this.recoverySettings, this.keyStore, calculatedChunkSize, this.snapshotMetrics);
    }
}

