/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.support;

import com.floragunn.encryption.at.rest.key_management.AESKey;
import com.floragunn.encryption.at.rest.key_management.WrappedAESKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public final class KeyWrapUtil {
    private static final ThreadLocal<Cipher> CIPHER_POOL = ThreadLocal.withInitial(() -> {
        try {
            return Cipher.getInstance("AESWrap_256", "SunJCE");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    });

    private KeyWrapUtil() {
    }

    public static WrappedAESKey encrypt(AESKey toWrap, AESKey key) throws InvalidKeyException, IllegalBlockSizeException {
        Cipher wrapper = CIPHER_POOL.get();
        wrapper.init(3, key.asSecretKeySpec());
        return new WrappedAESKey(wrapper.wrap(toWrap.asSecretKeySpec()));
    }

    public static AESKey decrypt(WrappedAESKey toUnwrap, AESKey key) throws InvalidKeyException, NoSuchAlgorithmException {
        Cipher wrapper = CIPHER_POOL.get();
        wrapper.init(4, key.asSecretKeySpec());
        SecretKeySpec unwrapped = (SecretKeySpec)wrapper.unwrap(toUnwrap.bytes(), "AES", 3);
        return new AESKey(unwrapped.getEncoded());
    }
}

