/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.config.text;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;

public abstract class PatternImpl
implements Pattern {
    static Pattern WILDCARD = new Pattern(){

        @Override
        public boolean matches(String string) {
            return true;
        }

        @Override
        public Iterable<String> iterateMatching(Iterable<String> strings) {
            return strings;
        }

        @Override
        public <E> Iterable<E> iterateMatching(Iterable<E> elements, Function<E, String> toStringFunction) {
            return elements;
        }

        @Override
        public ImmutableSet<String> getMatching(ImmutableSet<String> strings) {
            return strings;
        }

        @Override
        public boolean matches(Iterable<String> string) {
            return string.iterator().hasNext();
        }

        public String toString() {
            return "*";
        }

        @Override
        public ImmutableSet<String> getConstants() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> getPatterns() {
            return ImmutableSet.of((Object)"*");
        }

        @Override
        public Object toBasicObject() {
            return ImmutableList.of((Object)"*");
        }

        @Override
        public <E> ImmutableSet<E> getMatching(ImmutableSet<E> set, Function<E, String> stringMappingFunction) {
            return set;
        }

        @Override
        public boolean test(String t) {
            return true;
        }

        @Override
        public Pattern excluding(Pattern exludingPattern) {
            return new ExcludingPattern(exludingPattern, this);
        }

        @Override
        public boolean isWildcard() {
            return true;
        }

        @Override
        public boolean isBlank() {
            return false;
        }
    };
    static PatternImpl BLANK = new PatternImpl(){

        @Override
        public boolean matches(String string) {
            return false;
        }

        @Override
        public Iterable<String> iterateMatching(Iterable<String> strings) {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> getMatching(ImmutableSet<String> strings) {
            return ImmutableSet.empty();
        }

        @Override
        public boolean matches(Iterable<String> string) {
            return false;
        }

        public String toString() {
            return "-/-";
        }

        @Override
        public ImmutableSet<String> getConstants() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> getPatterns() {
            return ImmutableSet.empty();
        }

        @Override
        public Object toBasicObject() {
            return ImmutableList.empty();
        }

        @Override
        public <E> ImmutableSet<E> getMatching(ImmutableSet<E> set, Function<E, String> stringMappingFunction) {
            return ImmutableSet.empty();
        }

        @Override
        public boolean test(String t) {
            return false;
        }

        @Override
        public Pattern excluding(Pattern exludingPattern) {
            return this;
        }

        @Override
        public boolean isWildcard() {
            return false;
        }

        @Override
        public boolean isBlank() {
            return true;
        }

        @Override
        String getPrefix() {
            return null;
        }

        @Override
        boolean matchesSkipPrefix(String string) {
            return false;
        }
    };

    abstract String getPrefix();

    abstract boolean matchesSkipPrefix(String var1);

    @Override
    public ImmutableSet<String> getMatching(ImmutableSet<String> strings) {
        return strings.matching(s -> this.matches((String)s));
    }

    @Override
    public <E> ImmutableSet<E> getMatching(ImmutableSet<E> set, Function<E, String> stringMappingFunction) {
        return set.matching(e -> this.matches((String)stringMappingFunction.apply(e)));
    }

    @Override
    public boolean matches(Iterable<String> strings) {
        for (String string : strings) {
            if (!this.matches(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean test(String string) {
        return this.matches(string);
    }

    @Override
    public Iterable<String> iterateMatching(final Iterable<String> strings) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator delegate = strings.iterator();
                return new Iterator<String>(){
                    private String next;

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            this.init();
                        }
                        return this.next != null;
                    }

                    @Override
                    public String next() {
                        if (this.next == null) {
                            this.init();
                        }
                        String result = this.next;
                        this.next = null;
                        return result;
                    }

                    private void init() {
                        while (delegate.hasNext()) {
                            String candidate = (String)delegate.next();
                            if (!PatternImpl.this.matches(candidate)) continue;
                            this.next = candidate;
                            break;
                        }
                    }
                };
            }
        };
    }

    @Override
    public <E> Iterable<E> iterateMatching(final Iterable<E> elements, final Function<E, String> toStringFunction) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Iterator delegate = elements.iterator();
                return new Iterator<E>(){
                    private E next;

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            this.init();
                        }
                        return this.next != null;
                    }

                    @Override
                    public E next() {
                        if (this.next == null) {
                            this.init();
                        }
                        Object result = this.next;
                        this.next = null;
                        return result;
                    }

                    private void init() {
                        while (delegate.hasNext()) {
                            Object candidate = delegate.next();
                            if (!PatternImpl.this.matches((String)toStringFunction.apply(candidate))) continue;
                            this.next = candidate;
                            break;
                        }
                    }
                };
            }
        };
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    public Pattern excluding(Pattern exludingPattern) {
        if (exludingPattern == BLANK) {
            return this;
        }
        return new ExcludingPattern(exludingPattern, this);
    }

    static class ExcludingPattern
    extends PatternImpl {
        private final Pattern exclusions;
        private final Pattern base;
        private final String prefix;
        private String asString;

        ExcludingPattern(Pattern exclusions, Pattern base) {
            this.exclusions = exclusions;
            this.base = base;
            this.prefix = base instanceof PatternImpl ? ((PatternImpl)base).getPrefix() : null;
        }

        @Override
        public boolean matches(String string) {
            return !this.exclusions.matches(string) && this.base.matches(string);
        }

        @Override
        public ImmutableSet<String> getConstants() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> getPatterns() {
            return ImmutableSet.empty();
        }

        @Override
        public Object toBasicObject() {
            return this.base.toBasicObject();
        }

        @Override
        String getPrefix() {
            return this.prefix;
        }

        @Override
        boolean matchesSkipPrefix(String string) {
            return this.matches(string);
        }

        public String toString() {
            String result = this.asString;
            if (result != null) {
                return result;
            }
            this.asString = result = this.buildToString();
            return result;
        }

        private String buildToString() {
            StringBuilder result = new StringBuilder(this.base.toString());
            for (String pattern : this.exclusions.getPatterns()) {
                result.append(", ");
                result.append("-").append(pattern);
            }
            for (String pattern : this.exclusions.getConstants()) {
                result.append(", ");
                result.append("-").append(pattern);
            }
            return result.toString();
        }
    }

    static class EqualPrefixCompoundPattern
    extends PatternImpl {
        private final String asString;
        private final ImmutableList<String> source;
        private final ImmutableSet<PatternImpl> patterns;
        private final String sharedPrefix;

        static PatternImpl join(Collection<PatternImpl> patterns, String sharedPrefix) {
            for (PatternImpl pattern : patterns) {
                if (sharedPrefix.equals(pattern.getPrefix())) continue;
                throw new IllegalArgumentException("Pattern " + pattern + " does not have the prefix " + sharedPrefix);
            }
            if (patterns.size() == 0) {
                return BLANK;
            }
            if (patterns.size() == 1) {
                return patterns.iterator().next();
            }
            return new EqualPrefixCompoundPattern((ImmutableSet<PatternImpl>)ImmutableSet.of(patterns), patterns.toString(), (ImmutableList<String>)ImmutableList.empty(), sharedPrefix);
        }

        EqualPrefixCompoundPattern(ImmutableSet<PatternImpl> patterns, String asString, ImmutableList<String> source, String sharedPrefix) {
            this.patterns = patterns;
            this.asString = asString;
            this.source = source;
            this.sharedPrefix = sharedPrefix;
        }

        @Override
        public boolean matches(String string) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matches(string)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.patterns.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EqualPrefixCompoundPattern)) {
                return false;
            }
            return ((EqualPrefixCompoundPattern)obj).patterns.equals(this.patterns);
        }

        public String toString() {
            return this.asString;
        }

        @Override
        public ImmutableSet<String> getConstants() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> getPatterns() {
            return this.patterns.mapFlat(p -> p.getPatterns());
        }

        @Override
        public Object toBasicObject() {
            return this.source;
        }

        @Override
        String getPrefix() {
            return this.sharedPrefix;
        }

        @Override
        boolean matchesSkipPrefix(String string) {
            for (PatternImpl pattern : this.patterns) {
                if (!pattern.matchesSkipPrefix(string)) continue;
                return true;
            }
            return false;
        }
    }

    static class TrieCompoundPattern
    extends PatternImpl {
        private final String asString;
        private final ImmutableSet<PatternImpl> patterns;
        private final Node root;

        TrieCompoundPattern(ImmutableSet<PatternImpl> patterns) {
            this.patterns = patterns;
            this.asString = patterns.toString();
            this.root = TrieCompoundPattern.build(patterns);
        }

        @Override
        public boolean matches(String string) {
            return this.root.matches(string, 0);
        }

        public int hashCode() {
            return this.patterns.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TrieCompoundPattern)) {
                return false;
            }
            return ((TrieCompoundPattern)obj).patterns.equals(this.patterns);
        }

        public String toString() {
            return this.asString;
        }

        @Override
        public ImmutableSet<String> getConstants() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> getPatterns() {
            return this.patterns.mapFlat(p -> p.getPatterns());
        }

        @Override
        public Object toBasicObject() {
            return this.patterns;
        }

        @Override
        String getPrefix() {
            return null;
        }

        @Override
        boolean matchesSkipPrefix(String string) {
            return this.matches(string);
        }

        private static Node build(Collection<PatternImpl> patterns) {
            Node.Builder root = new Node.Builder("");
            for (PatternImpl pattern : patterns) {
                root.add(pattern.getPrefix(), 0, pattern);
            }
            return root.build();
        }

        static class Node {
            private final char[] nextKeys;
            private final Node[] nextNodes;
            private final PatternImpl pattern;

            Node(char[] nextKeys, Node[] nextNodes, PatternImpl pattern) {
                this.nextKeys = nextKeys;
                this.nextNodes = nextNodes;
                this.pattern = pattern;
            }

            boolean matches(String value, int offset) {
                if (this.pattern != null && this.pattern.matchesSkipPrefix(value)) {
                    return true;
                }
                if (offset >= value.length()) {
                    return false;
                }
                char c = value.charAt(offset);
                if (this.nextKeys.length == 1) {
                    if (this.nextKeys[0] == c) {
                        return this.nextNodes[0].matches(value, offset + 1);
                    }
                    return false;
                }
                int pos = Arrays.binarySearch(this.nextKeys, c);
                if (pos >= 0) {
                    return this.nextNodes[pos].matches(value, offset + 1);
                }
                return false;
            }

            static class Builder {
                private TreeMap<Character, Builder> nodes = new TreeMap();
                private Set<PatternImpl> patterns = new HashSet<PatternImpl>();
                private final String prefix;

                Builder(String prefix) {
                    this.prefix = prefix;
                }

                void add(String value, int pos, PatternImpl pattern) {
                    if (value == null) {
                        this.patterns.add(pattern);
                        return;
                    }
                    char c = value.charAt(pos);
                    Builder childNode = this.nodes.computeIfAbsent(Character.valueOf(c), c0 -> new Builder(value.substring(0, pos + 1)));
                    if (pos == value.length() - 1) {
                        childNode.patterns.add(pattern);
                    } else {
                        childNode.add(value, pos + 1, pattern);
                    }
                }

                Node build() {
                    char[] nextKeys = new char[this.nodes.size()];
                    Node[] nextNodes = new Node[this.nodes.size()];
                    int i = 0;
                    for (Map.Entry<Character, Builder> entry : this.nodes.entrySet()) {
                        nextKeys[i] = entry.getKey().charValue();
                        nextNodes[i] = entry.getValue().build();
                        ++i;
                    }
                    return new Node(nextKeys, nextNodes, EqualPrefixCompoundPattern.join(this.patterns, this.prefix));
                }
            }
        }
    }

    static class CompoundPattern
    extends PatternImpl {
        private final String asString;
        private final ImmutableList<String> source;
        private final ImmutableList<Pattern> patterns;
        private final ImmutableSet<String> constants;

        static Pattern create(List<String> patterns) throws ConfigValidationException {
            int start = 0;
            int patternCount = patterns.size();
            ValidationErrors validationErrors = new ValidationErrors();
            ArrayList<Pattern> result = new ArrayList<Pattern>(patternCount);
            for (int i = 0; i < patternCount; ++i) {
                String patternString = patterns.get(i);
                if (!patternString.startsWith("-")) continue;
                if (start == i) {
                    validationErrors.add(new ValidationError(null, "Exclusions must come after normal patterns"));
                    continue;
                }
                try {
                    List<String> negations = CompoundPattern.collectNegationsStartingAt(patterns, i);
                    List<String> precedingPatterns = patterns.subList(start, i);
                    Pattern base = CompoundPattern.createWithoutExclusions(precedingPatterns);
                    Pattern exclusion = Pattern.create(negations);
                    result.add(new ExcludingPattern(exclusion, base));
                    if (negations.size() + i >= patternCount) {
                        start = patterns.size();
                        break;
                    }
                    int next = CompoundPattern.findNextNonNegation(patterns, i + 1);
                    if (next == -1) {
                        start = patterns.size();
                        break;
                    }
                    i = next - 1;
                    start = next;
                    continue;
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(null, e);
                }
            }
            if (start < patterns.size()) {
                try {
                    result.add(CompoundPattern.createWithoutExclusions(patterns.subList(start, patterns.size())));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(null, e);
                }
            }
            return Pattern.join(result);
        }

        static Pattern createWithoutExclusions(Collection<String> patterns) throws ConfigValidationException {
            ImmutableList compiledPatterns;
            ValidationErrors validationErrors = new ValidationErrors();
            ImmutableSet.Builder patternsWithPrefix = new ImmutableSet.Builder();
            ImmutableSet.Builder patternsWithoutPrefix = new ImmutableSet.Builder();
            ImmutableSet.Builder constantSet = new ImmutableSet.Builder();
            int i = 0;
            for (String patternString : patterns) {
                try {
                    Pattern pattern = Pattern.create(patternString);
                    if (pattern == WILDCARD) {
                        return pattern;
                    }
                    if (pattern instanceof Constant) {
                        constantSet.with((Object)patternString);
                    } else if (pattern instanceof PatternImpl) {
                        PatternImpl patternImpl = (PatternImpl)pattern;
                        String prefix = patternImpl.getPrefix();
                        if (prefix != null) {
                            patternsWithPrefix.with((Object)patternImpl);
                        } else {
                            patternsWithoutPrefix.with((Object)patternImpl);
                        }
                    } else {
                        patternsWithoutPrefix.with((Object)pattern);
                    }
                    ++i;
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(String.valueOf(i), e);
                }
            }
            validationErrors.throwExceptionForPresentErrors();
            int totalCount = patternsWithoutPrefix.size() + patternsWithPrefix.size() + constantSet.size();
            if (totalCount == 0) {
                return BLANK;
            }
            if (totalCount == 1) {
                if (constantSet.size() == 1) {
                    return new Constant((String)constantSet.any());
                }
                if (patternsWithoutPrefix.size() == 1) {
                    return (Pattern)patternsWithoutPrefix.any();
                }
                if (patternsWithPrefix.size() == 1) {
                    return (Pattern)patternsWithPrefix.any();
                }
            }
            if (patternsWithPrefix.size() == 0) {
                compiledPatterns = patternsWithoutPrefix.build().toList();
            } else {
                TrieCompoundPattern trieCompoundPattern = new TrieCompoundPattern((ImmutableSet<PatternImpl>)patternsWithPrefix.build());
                compiledPatterns = ImmutableList.of((Object)trieCompoundPattern).with((Collection)patternsWithoutPrefix.build().toList());
            }
            return new CompoundPattern((ImmutableList<Pattern>)compiledPatterns, (ImmutableSet<String>)constantSet.build(), patterns.toString(), (ImmutableList<String>)ImmutableList.of(patterns));
        }

        static Pattern join(Collection<Pattern> patterns) {
            ImmutableList compiledPatterns;
            for (Pattern pattern : patterns) {
                if (pattern != WILDCARD) continue;
                return pattern;
            }
            ImmutableSet.Builder patternsWithPrefix = new ImmutableSet.Builder();
            ImmutableSet.Builder patternsWithoutPrefix = new ImmutableSet.Builder();
            ImmutableSet.Builder constantSet = new ImmutableSet.Builder();
            CompoundPattern.collect(patterns, (ImmutableSet.Builder<PatternImpl>)patternsWithPrefix, (ImmutableSet.Builder<Pattern>)patternsWithoutPrefix, (ImmutableSet.Builder<String>)constantSet);
            int totalCount = patternsWithoutPrefix.size() + patternsWithPrefix.size() + constantSet.size();
            if (totalCount == 0) {
                return BLANK;
            }
            if (totalCount == 1) {
                if (constantSet.size() == 1) {
                    return new Constant((String)constantSet.any());
                }
                if (patternsWithoutPrefix.size() == 1) {
                    return (Pattern)patternsWithoutPrefix.any();
                }
                if (patternsWithPrefix.size() == 1) {
                    return (Pattern)patternsWithPrefix.any();
                }
            }
            if (patternsWithPrefix.size() == 0) {
                compiledPatterns = patternsWithoutPrefix.build().toList();
            } else {
                TrieCompoundPattern trieCompoundPattern = new TrieCompoundPattern((ImmutableSet<PatternImpl>)patternsWithPrefix.build());
                if (constantSet.size() == 0 && patternsWithoutPrefix.size() == 0) {
                    return trieCompoundPattern;
                }
                compiledPatterns = ImmutableList.of((Object)trieCompoundPattern).with((Collection)patternsWithoutPrefix.build().toList());
            }
            return new CompoundPattern((ImmutableList<Pattern>)compiledPatterns, (ImmutableSet<String>)constantSet.build(), patterns.toString(), (ImmutableList<String>)ImmutableList.empty());
        }

        private static void collect(Collection<? extends Pattern> patterns, ImmutableSet.Builder<PatternImpl> patternsWithPrefix, ImmutableSet.Builder<Pattern> patternsWithoutPrefix, ImmutableSet.Builder<String> constantSet) {
            for (Pattern pattern : patterns) {
                if (pattern instanceof Constant) {
                    constantSet.with((Object)((Constant)pattern).getValue());
                    continue;
                }
                if (pattern instanceof CompoundPattern) {
                    CompoundPattern compoundPattern = (CompoundPattern)pattern;
                    constantSet.with(compoundPattern.constants);
                    CompoundPattern.collect(compoundPattern.patterns, patternsWithPrefix, patternsWithoutPrefix, constantSet);
                    continue;
                }
                if (pattern instanceof TrieCompoundPattern) {
                    TrieCompoundPattern trieCompoundPattern = (TrieCompoundPattern)pattern;
                    CompoundPattern.collect((Collection<? extends Pattern>)trieCompoundPattern.patterns, patternsWithPrefix, patternsWithoutPrefix, constantSet);
                    continue;
                }
                if (pattern instanceof PatternImpl) {
                    PatternImpl patternImpl = (PatternImpl)pattern;
                    String prefix = patternImpl.getPrefix();
                    if (prefix != null) {
                        patternsWithPrefix.with((Object)patternImpl);
                        continue;
                    }
                    patternsWithoutPrefix.with((Object)patternImpl);
                    continue;
                }
                patternsWithoutPrefix.with((Object)pattern);
            }
        }

        private static List<String> collectNegationsStartingAt(List<String> patterns, int start) {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = start; i < patterns.size(); ++i) {
                String pattern = patterns.get(i);
                if (!pattern.startsWith("-")) continue;
                result.add(pattern.substring(1));
            }
            return result;
        }

        private static int findNextNonNegation(List<String> patterns, int start) {
            for (int i = start; i < patterns.size(); ++i) {
                String pattern = patterns.get(i);
                if (pattern.startsWith("-")) continue;
                return i;
            }
            return -1;
        }

        CompoundPattern(ImmutableList<Pattern> patterns, ImmutableSet<String> constants, String asString, ImmutableList<String> source) {
            this.constants = constants;
            this.patterns = patterns;
            this.asString = asString;
            this.source = source;
        }

        @Override
        public boolean matches(String string) {
            if (this.constants.contains((Object)string)) {
                return true;
            }
            for (Pattern pattern : this.patterns) {
                if (!pattern.matches(string)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.patterns.hashCode() + this.constants.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CompoundPattern)) {
                return false;
            }
            return ((CompoundPattern)obj).patterns.equals(this.patterns) && ((CompoundPattern)obj).constants.equals(this.constants);
        }

        public String toString() {
            return this.asString;
        }

        @Override
        public ImmutableSet<String> getConstants() {
            return this.constants;
        }

        @Override
        public ImmutableSet<String> getPatterns() {
            return (ImmutableSet)this.patterns.stream().flatMap(p -> p.getPatterns().stream()).collect(ImmutableSet.collector());
        }

        ImmutableList<Pattern> getPatternObjects() {
            return this.patterns;
        }

        @Override
        public Object toBasicObject() {
            return this.source;
        }

        @Override
        String getPrefix() {
            return null;
        }

        @Override
        boolean matchesSkipPrefix(String string) {
            return this.matches(string);
        }
    }

    static class JavaPattern
    extends PatternImpl {
        private final java.util.regex.Pattern javaPattern;
        private final String patternString;

        JavaPattern(String pattern) throws ConfigValidationException {
            try {
                this.javaPattern = java.util.regex.Pattern.compile(pattern);
                this.patternString = pattern;
            }
            catch (PatternSyntaxException e) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)pattern, (Object)"A regular expression pattern"));
            }
        }

        @Override
        public boolean matches(String string) {
            return this.javaPattern.matcher(string).matches();
        }

        public int hashCode() {
            return this.patternString.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JavaPattern)) {
                return false;
            }
            return ((JavaPattern)obj).patternString.equals(this.patternString);
        }

        public String toString() {
            return this.patternString;
        }

        @Override
        public ImmutableSet<String> getConstants() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> getPatterns() {
            return ImmutableSet.of((Object)this.patternString);
        }

        @Override
        public Object toBasicObject() {
            return ImmutableList.of((Object)this.patternString);
        }

        @Override
        String getPrefix() {
            return null;
        }

        @Override
        boolean matchesSkipPrefix(String string) {
            return this.matches(string);
        }
    }

    static class PrefixPattern
    extends PatternImpl {
        private final String prefix;
        private final String source;

        PrefixPattern(String prefix) {
            this.prefix = prefix;
            this.source = prefix + "*";
        }

        @Override
        public boolean matches(String string) {
            return string.startsWith(this.prefix);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PrefixPattern)) {
                return false;
            }
            return ((PrefixPattern)obj).prefix.equals(this.prefix);
        }

        public String toString() {
            return this.source;
        }

        @Override
        public ImmutableSet<String> getConstants() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> getPatterns() {
            return ImmutableSet.of((Object)this.source);
        }

        @Override
        public Object toBasicObject() {
            return ImmutableList.of((Object)this.source);
        }

        @Override
        String getPrefix() {
            return this.prefix;
        }

        @Override
        boolean matchesSkipPrefix(String string) {
            return true;
        }
    }

    static class Constant
    extends PatternImpl {
        private final String value;

        Constant(String value) {
            this.value = value;
        }

        @Override
        public boolean matches(String string) {
            return this.value.equals(string);
        }

        @Override
        public Iterable<String> iterateMatching(Iterable<String> strings) {
            if (strings instanceof ImmutableSet) {
                ImmutableSet set = (ImmutableSet)strings;
                if (set.size() == 0) {
                    return set;
                }
                if (set.size() == 1) {
                    String value = (String)set.only();
                    if (this.matches(value)) {
                        return set;
                    }
                    return ImmutableSet.empty();
                }
            }
            return super.iterateMatching(strings);
        }

        @Override
        public <E> Iterable<E> iterateMatching(Iterable<E> elements, Function<E, String> toStringFunction) {
            if (elements instanceof ImmutableSet) {
                ImmutableSet set = (ImmutableSet)elements;
                if (set.size() == 0) {
                    return set;
                }
                if (set.size() == 1) {
                    Object value = set.only();
                    if (this.matches(toStringFunction.apply(value))) {
                        return set;
                    }
                    return ImmutableSet.empty();
                }
            }
            return super.iterateMatching(elements, toStringFunction);
        }

        @Override
        public ImmutableSet<String> getConstants() {
            return ImmutableSet.of((Object)this.value);
        }

        @Override
        public ImmutableSet<String> getPatterns() {
            return ImmutableSet.empty();
        }

        String getValue() {
            return this.value;
        }

        @Override
        public Object toBasicObject() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        @Override
        String getPrefix() {
            return this.value;
        }

        @Override
        boolean matchesSkipPrefix(String string) {
            return true;
        }
    }
}

