/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.key_management;

import com.floragunn.encryption.at.rest.key_management.AESKey;
import com.floragunn.encryption.at.rest.key_management.RSAEncryptedAndSignedAESKey;
import com.floragunn.encryption.at.rest.key_management.WrappedAESKey;
import com.floragunn.encryption.at.rest.key_management.WrappedAESKeyContainer;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.IllegalBlockSizeException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class ClusterKeK
implements Writeable {
    private final AESKey kekAesKey;
    private final RSAEncryptedAndSignedAESKey rsaEncryptedAndSignedAESKey;

    public ClusterKeK(AESKey aesKey, RSAEncryptedAndSignedAESKey rsaEncryptedAndSignedAESKey) {
        this.kekAesKey = Objects.requireNonNull(aesKey, "aesKey must not be null");
        this.rsaEncryptedAndSignedAESKey = Objects.requireNonNull(rsaEncryptedAndSignedAESKey, "rsaEncryptedAndSignedAESKey must not be null");
    }

    public ClusterKeK(StreamInput in) throws IOException {
        this.kekAesKey = new AESKey(in.readByteArray());
        this.rsaEncryptedAndSignedAESKey = new RSAEncryptedAndSignedAESKey(in.readByteArray());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByteArray(this.kekAesKey.bytes());
        out.writeByteArray(this.rsaEncryptedAndSignedAESKey.bytes());
    }

    public WrappedAESKeyContainer newRandomWrapped() throws IllegalBlockSizeException, InvalidKeyException {
        return this.kekAesKey.newRandomWrapped();
    }

    public AESKey unwrapAESKey(WrappedAESKey wrappedAESKey) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.kekAesKey.unwrapAESKey(wrappedAESKey);
    }

    public RSAEncryptedAndSignedAESKey getRsaEncryptedAndSignedAESKey() {
        return this.rsaEncryptedAndSignedAESKey;
    }
}

