/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;

public class Utils {
    public static Map<String, Object> convertJsonToxToStructuredMap(ToXContent jsonContent) {
        Map map = null;
        try {
            BytesReference bytes = XContentHelper.toXContent((ToXContent)jsonContent, (XContentType)XContentType.JSON, (boolean)false);
            map = (Map)XContentHelper.convertToMap((BytesReference)bytes, (boolean)false, (XContentType)XContentType.JSON).v2();
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic((Exception)e1);
        }
        return map;
    }

    public static Map<String, Object> convertJsonToxToStructuredMap(String jsonContent) {
        Map map;
        block8: {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonContent);
            try {
                map = parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e1) {
                    throw ExceptionsHelper.convertToElastic((Exception)e1);
                }
            }
            parser.close();
        }
        return map;
    }

    public static BytesReference convertStructuredMapToBytes(Map<String, Object> structuredMap) {
        try {
            return BytesReference.bytes((XContentBuilder)JsonXContent.contentBuilder().map(structuredMap));
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }

    public static String convertStructuredMapToJson(Map<String, Object> structuredMap) {
        try {
            return XContentHelper.convertToJson((BytesReference)Utils.convertStructuredMapToBytes(structuredMap), (boolean)false, (XContentType)XContentType.JSON);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }
}

