/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.routing;

import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public class AsyncStoragePool {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THREAD_POOL_MAX_QUEUE_LEN = 100000;
    final ExecutorService pool;
    int threadPoolSize;
    int threadPoolMaxQueueLen;

    public AsyncStoragePool(Settings settings) {
        this.threadPoolSize = settings.getAsInt("searchguard.audit.threadpool.size", Integer.valueOf(10));
        this.threadPoolMaxQueueLen = settings.getAsInt("searchguard.audit.threadpool.max_queue_len", Integer.valueOf(100000));
        if (this.threadPoolSize <= 0) {
            this.threadPoolSize = 10;
        }
        if (this.threadPoolMaxQueueLen <= 0) {
            this.threadPoolMaxQueueLen = 100000;
        }
        this.pool = this.createExecutor(this.threadPoolSize, this.threadPoolMaxQueueLen);
    }

    public void submit(AuditMessage message, AuditLogSink sink) {
        block2: {
            try {
                this.pool.submit(() -> {
                    sink.store(message);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("stored on delegate {} asynchronously", (Object)sink.getClass().getSimpleName());
                    }
                });
            }
            catch (Exception ex) {
                this.log.error("Could not submit audit message {} to thread pool for delegate '{}' due to '{}'", (Object)message, (Object)sink.getClass().getSimpleName(), (Object)ex.getMessage());
                if (sink.getFallbackSink() == null) break block2;
                sink.getFallbackSink().store(message);
            }
        }
    }

    private ThreadPoolExecutor createExecutor(int threadPoolSize, int maxQueueLen) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new executor with threadPoolSize: {} and maxQueueLen: {}", (Object)threadPoolSize, (Object)maxQueueLen);
        }
        return new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueueLen));
    }

    public void close() {
        if (this.pool != null) {
            this.pool.shutdown();
            try {
                if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.pool.shutdownNow();
                    if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                        this.log.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

