/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.helper;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import java.net.InetSocketAddress;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.transport.TransportAddress;
import org.mockito.Mockito;

public class MockAuditMessageFactory {
    public static AuditMessage validAuditMessage() {
        return MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.FAILED_LOGIN);
    }

    public static AuditMessage validAuditMessage(AuditMessage.Category category) {
        ClusterState cs = (ClusterState)Mockito.mock(ClusterState.class);
        DiscoveryNodes dns = (DiscoveryNodes)Mockito.mock(DiscoveryNodes.class);
        DiscoveryNode dn = (DiscoveryNode)Mockito.mock(DiscoveryNode.class);
        Mockito.when((Object)dn.getHostAddress()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)dn.getId()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)dn.getHostName()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)dns.getLocalNode()).thenReturn((Object)dn);
        Mockito.when((Object)cs.nodes()).thenReturn((Object)dns);
        Mockito.when((Object)cs.getClusterName()).thenReturn((Object)new ClusterName("testcluster"));
        TransportAddress ta = new TransportAddress(new InetSocketAddress("8.8.8.8", 80));
        AuditMessage msg = new AuditMessage(category, cs, AuditLog.Origin.TRANSPORT, AuditLog.Origin.TRANSPORT);
        msg.addEffectiveUser("John Doe");
        msg.addRemoteAddress(ta);
        msg.addRequestType("IndexRequest");
        return msg;
    }
}

