/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.index.IndexVersion;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AuditTestToXContentObjectImplTest {
    @Mock
    private ClusterState clusterState;
    @Mock
    private DiscoveryNode localNode;
    private final String clusterName = "test-cluster";
    private final String localNodeId = "test-local-node-id";
    private final String localNodeName = "test-local-node";
    private final String localNodeHostAddress = "127.0.0.1";
    private final String localNodeHostName = "test-local-node-host";
    private final Version localNodeVersion = Version.CURRENT;

    @Before
    public void setUp() {
        Mockito.when((Object)this.clusterState.getClusterName()).thenReturn((Object)new ClusterName("test-cluster"));
        Mockito.when((Object)this.localNode.getId()).thenReturn((Object)"test-local-node-id");
        Mockito.when((Object)this.localNode.getName()).thenReturn((Object)"test-local-node");
        Mockito.when((Object)this.localNode.getHostAddress()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)this.localNode.getHostName()).thenReturn((Object)"test-local-node-host");
        Mockito.when((Object)this.localNode.getVersion()).thenReturn((Object)this.localNodeVersion);
        Mockito.when((Object)this.localNode.getMinIndexVersion()).thenReturn((Object)IndexVersion.current());
        DiscoveryNodes discoveryNodes = DiscoveryNodes.builder().add(this.localNode).localNodeId("test-local-node-id").build();
        Mockito.when((Object)this.clusterState.nodes()).thenReturn((Object)discoveryNodes);
    }

    @Test
    public void initialize_commonAttributesShouldBeSet_allConstructorParamsAreProvided() {
        AuditMessage.Category category = AuditMessage.Category.FAILED_LOGIN;
        AuditLog.Origin origin = AuditLog.Origin.REST;
        AuditLog.Origin requestLayer = AuditLog.Origin.TRANSPORT;
        AuditMessage auditMessage = new AuditMessage(category, this.clusterState, origin, requestLayer);
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_format_version"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_category"), (Matcher)Matchers.equalTo((Object)category));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("@timestamp"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_cluster_name"), (Matcher)Matchers.equalTo((Object)"test-cluster"));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_node_host_address"), (Matcher)Matchers.equalTo((Object)"127.0.0.1"));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_node_id"), (Matcher)Matchers.equalTo((Object)"test-local-node-id"));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_node_host_name"), (Matcher)Matchers.equalTo((Object)"test-local-node-host"));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_node_name"), (Matcher)Matchers.equalTo((Object)"test-local-node"));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_node_elasticsearch_version"), (Matcher)Matchers.equalTo((Object)this.localNodeVersion));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)origin));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)requestLayer));
    }

    @Test(expected=NullPointerException.class)
    public void initialize_shouldThrowException_categoryIsNull() {
        AuditLog.Origin origin = AuditLog.Origin.REST;
        AuditLog.Origin requestLayer = AuditLog.Origin.TRANSPORT;
        new AuditMessage(null, this.clusterState, origin, requestLayer);
    }

    @Test
    public void initialize_commonAttributesShouldBeSet_allParamsExceptCategoryAreNull() {
        AuditMessage.Category category = AuditMessage.Category.FAILED_LOGIN;
        AuditLog.Origin origin = AuditLog.Origin.REST;
        AuditLog.Origin requestLayer = AuditLog.Origin.LOCAL;
        AuditMessage auditMessage = new AuditMessage(category, null, origin, requestLayer);
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_format_version"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_category"), (Matcher)Matchers.equalTo((Object)category));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("@timestamp"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)auditMessage.getAsMap(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"audit_cluster_name")));
        MatcherAssert.assertThat((Object)auditMessage.getAsMap(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"audit_node_host_address")));
        MatcherAssert.assertThat((Object)auditMessage.getAsMap(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"audit_node_id")));
        MatcherAssert.assertThat((Object)auditMessage.getAsMap(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"audit_node_host_name")));
        MatcherAssert.assertThat((Object)auditMessage.getAsMap(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"audit_node_name")));
        MatcherAssert.assertThat((Object)auditMessage.getAsMap(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"audit_node_elasticsearch_version")));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)origin));
        MatcherAssert.assertThat(auditMessage.getAsMap().get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)requestLayer));
    }

    @Test
    public void auditMessageShouldNotContainDisabledFields() throws DocumentParseException {
        List<String> disabledFields = Arrays.asList("audit_format_version", "audit_category");
        AuditMessage.Category category = AuditMessage.Category.FAILED_LOGIN;
        AuditLog.Origin origin = AuditLog.Origin.REST;
        AuditLog.Origin requestLayer = AuditLog.Origin.TRANSPORT;
        AuditMessage am = new AuditMessage(category, this.clusterState, origin, requestLayer);
        Map asMap = am.getAsMap();
        String toString = am.toString();
        String toPrettyString = am.toPrettyString();
        String toJson = am.toJson();
        String toText = am.toText();
        String toUrlParameters = am.toUrlParameters().replace("?", "");
        List queryParams = URLEncodedUtils.parse((String)toUrlParameters, (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat(asMap.keySet(), (Matcher)Matchers.hasItems((Object[])disabledFields.toArray(new String[0])));
        MatcherAssert.assertThat((Object)DocNode.parse((Format)Format.JSON).from(toString).keySet(), (Matcher)Matchers.hasItems((Object[])disabledFields.toArray(new String[0])));
        MatcherAssert.assertThat((Object)DocNode.parse((Format)Format.JSON).from(toPrettyString).keySet(), (Matcher)Matchers.hasItems((Object[])disabledFields.toArray(new String[0])));
        MatcherAssert.assertThat((Object)DocNode.parse((Format)Format.JSON).from(toJson).keySet(), (Matcher)Matchers.hasItems((Object[])disabledFields.toArray(new String[0])));
        MatcherAssert.assertThat((Object)disabledFields.stream().allMatch(field -> queryParams.stream().anyMatch(param -> param.getName().equals(field))), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)disabledFields.stream().allMatch(field -> toText.contains(field + ":")), (Matcher)Matchers.is((Object)true));
        am.removeDisabledFields(disabledFields);
        Map asMapWithoutDisabled = am.getAsMap();
        String toStringWithoutDisabled = am.toString();
        String toPrettyStringWithoutDisabled = am.toPrettyString();
        String toJsonWithoutDisabled = am.toJson();
        String toTextWithoutDisabled = am.toText();
        String toUrlParametersWithoutDisabled = am.toUrlParameters().replace("?", "");
        List queryParamsWithoutDisabled = URLEncodedUtils.parse((String)toUrlParametersWithoutDisabled, (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat(asMapWithoutDisabled.keySet(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])disabledFields.toArray(new String[0]))));
        MatcherAssert.assertThat((Object)DocNode.parse((Format)Format.JSON).from(toStringWithoutDisabled).keySet(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])disabledFields.toArray(new String[0]))));
        MatcherAssert.assertThat((Object)DocNode.parse((Format)Format.JSON).from(toPrettyStringWithoutDisabled).keySet(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])disabledFields.toArray(new String[0]))));
        MatcherAssert.assertThat((Object)DocNode.parse((Format)Format.JSON).from(toJsonWithoutDisabled).keySet(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])disabledFields.toArray(new String[0]))));
        MatcherAssert.assertThat((Object)disabledFields.stream().noneMatch(field -> queryParamsWithoutDisabled.stream().anyMatch(param -> param.getName().equals(field))), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)disabledFields.stream().noneMatch(field -> toTextWithoutDisabled.contains(field + ":")), (Matcher)Matchers.is((Object)true));
    }
}

