/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditLogImpl;
import com.floragunn.searchguard.enterprise.auditlog.integration.TestAuditlogImpl;
import com.floragunn.searchguard.user.User;
import java.net.InetSocketAddress;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.threadpool.DefaultBuiltInExecutorBuilders;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.internal.BuiltInExecutorBuilders;
import org.elasticsearch.transport.TransportRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class IgnoreAuditUsersTest {
    ClusterService cs = (ClusterService)Mockito.mock(ClusterService.class);
    DiscoveryNode dn = (DiscoveryNode)Mockito.mock(DiscoveryNode.class);
    ConfigurationRepository configurationRepository = (ConfigurationRepository)Mockito.mock(ConfigurationRepository.class);
    static String ignoreUser = "Wesley Crusher";
    String nonIgnoreUser = "Diana Crusher";
    private final User ignoreUserObj = new User(ignoreUser, null);
    static SearchRequest sr;

    @Before
    public void setup() {
        Mockito.when((Object)this.dn.getHostAddress()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.dn.getId()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.dn.getHostName()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.cs.localNode()).thenReturn((Object)this.dn);
        Mockito.when((Object)this.cs.getClusterName()).thenReturn((Object)new ClusterName("cname"));
    }

    @BeforeClass
    public static void initSearchRequest() {
        sr = new SearchRequest();
        sr.indices(new String[]{"index1", "logstash*"});
    }

    @Test
    public void testConfiguredIgnoreUser() {
        Settings settings = Settings.builder().put("searchguard.audit.ignore_users", ignoreUser).put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_request_details", true).put("searchguard.audit.threadpool.size", 0).build();
        AuditLogImpl al = new AuditLogImpl(settings, null, null, IgnoreAuditUsersTest.newThreadPool("_sg_user", this.ignoreUserObj), null, this.cs, this.configurationRepository);
        TestAuditlogImpl.clear();
        al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)sr, null);
        Assert.assertEquals((long)0L, (long)TestAuditlogImpl.messages.size());
    }

    @Test
    public void testNonConfiguredIgnoreUser() {
        Settings settings = Settings.builder().put("searchguard.audit.ignore_users", this.nonIgnoreUser).put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        AuditLogImpl al = new AuditLogImpl(settings, null, null, IgnoreAuditUsersTest.newThreadPool("_sg_user", this.ignoreUserObj), null, this.cs, this.configurationRepository);
        TestAuditlogImpl.clear();
        al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)sr, null);
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
    }

    @Test
    public void testNonExistingIgnoreUser() {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        AuditLogImpl al = new AuditLogImpl(settings, null, null, IgnoreAuditUsersTest.newThreadPool("_sg_user", this.ignoreUserObj), null, this.cs, this.configurationRepository);
        TestAuditlogImpl.clear();
        al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)sr, null);
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
    }

    @Test
    public void testWildcards() {
        SearchRequest sr = new SearchRequest();
        sr.indices(new String[]{"index1", "logstash*"});
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_request_details", true).put("searchguard.audit.threadpool.size", 0).putList("searchguard.audit.ignore_users", new String[]{"*"}).build();
        TransportAddress ta = new TransportAddress(new InetSocketAddress("8.8.8.8", 80));
        AuditLogImpl al = new AuditLogImpl(settings, null, null, IgnoreAuditUsersTest.newThreadPool("_sg_remote_address", ta, "_sg_user", new User("John Doe", null), "_sg_ssl_transport_principal", "CN=kirk,OU=client,O=client,L=test,C=DE"), null, this.cs, this.configurationRepository);
        TestAuditlogImpl.clear();
        al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)sr, null);
        Assert.assertEquals((long)0L, (long)TestAuditlogImpl.messages.size());
        settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.threadpool.size", 0).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").putList("searchguard.audit.ignore_users", new String[]{"xxx"}).build();
        al = new AuditLogImpl(settings, null, null, IgnoreAuditUsersTest.newThreadPool("_sg_remote_address", ta, "_sg_user", new User("John Doe", null), "_sg_ssl_transport_principal", "CN=kirk,OU=client,O=client,L=test,C=DE"), null, this.cs, this.configurationRepository);
        TestAuditlogImpl.clear();
        al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)sr, null);
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).putList("searchguard.audit.ignore_users", new String[]{"John Doe", "Capatin Kirk"}).build();
        al = new AuditLogImpl(settings, null, null, IgnoreAuditUsersTest.newThreadPool("_sg_remote_address", ta, "_sg_user", new User("John Doe", null), "_sg_ssl_transport_principal", "CN=kirk,OU=client,O=client,L=test,C=DE"), null, this.cs, this.configurationRepository);
        TestAuditlogImpl.clear();
        al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)sr, null);
        al.logSgIndexAttempt((TransportRequest)sr, "indices:data/read/search", null);
        al.logMissingPrivileges("indices:data/read/search", (TransportRequest)sr, null);
        Assert.assertEquals((String)TestAuditlogImpl.messages.toString(), (long)0L, (long)TestAuditlogImpl.messages.size());
        settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).putList("searchguard.audit.ignore_users", new String[]{"Wil Riker", "Capatin Kirk"}).build();
        al = new AuditLogImpl(settings, null, null, IgnoreAuditUsersTest.newThreadPool("_sg_remote_address", ta, "_sg_user", new User("John Doe", null), "_sg_ssl_transport_principal", "CN=kirk,OU=client,O=client,L=test,C=DE"), null, this.cs, this.configurationRepository);
        TestAuditlogImpl.clear();
        al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)sr, null);
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
    }

    private static ThreadPool newThreadPool(Object ... transients) {
        ThreadPool tp = new ThreadPool(Settings.builder().put("node.name", "mock").build(), MeterRegistry.NOOP, (BuiltInExecutorBuilders)new DefaultBuiltInExecutorBuilders(), new ExecutorBuilder[0]);
        for (int i = 0; i < transients.length; i += 2) {
            tp.getThreadContext().putTransient((String)transients[i], transients[i + 1]);
        }
        return tp;
    }
}

