/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.sink;

import com.floragunn.searchguard.enterprise.auditlog.helper.MockAuditMessageFactory;
import com.floragunn.searchguard.enterprise.auditlog.helper.TestHttpHandler;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.SinkProvider;
import com.floragunn.searchguard.enterprise.auditlog.sink.WebhookSink;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.protocol.HttpRequestHandler;
import org.elasticsearch.common.settings.Settings;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SinkProviderTLSTest {
    protected HttpServer server = null;

    @Before
    @After
    public void tearDown() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testTlsConfigurationNoFallback() throws Exception {
        TestHttpHandler handler = new TestHttpHandler();
        this.server = ServerBootstrap.bootstrap().setListenerPort(8083).setServerInfo("Test/1.1").setSslContext(this.createSSLContext()).registerHandler("*", (HttpRequestHandler)handler).create();
        this.server.start();
        Settings.Builder builder = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/sink/configuration_tls.yml"));
        builder.put("path.home", "/");
        builder.put("searchguard.audit.config.webhook.ssl.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/root-ca.pem"));
        builder.put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/root-ca.pem"));
        builder.put("searchguard.audit.endpoints.endpoint2.config.webhook.ssl.pemtrustedcas_content", FileHelper.loadFile((String)"auditlog/root-ca.pem"));
        SinkProvider provider = new SinkProvider(builder.build(), null, null, null);
        WebhookSink defaultSink = (WebhookSink)provider.defaultSink;
        Assert.assertEquals((Object)true, (Object)defaultSink.verifySSL);
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        ((AuditLogSink)provider.allSinks.get("endpoint1")).store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        ((AuditLogSink)provider.allSinks.get("endpoint2")).store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        provider.defaultSink.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        this.server.stop();
    }

    private SSLContext createSSLContext() throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = KeyStore.getInstance("JKS");
        FileInputStream trustStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks").toFile());
        trustStore.load(trustStream, "changeit".toCharArray());
        tmf.init(trustStore);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream keyStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/node-0-keystore.jks").toFile());
        keyStore.load(keyStream, "changeit".toCharArray());
        kmf.init(keyStore, "changeit".toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }

    private void assertStringContainsAllKeysAndValues(String in) {
        Assert.assertTrue((String)in, (boolean)in.contains("audit_format_version"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_category"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_format_version"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_request_remote_address"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_request_origin"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_request_layer"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_transport_request_type"));
        Assert.assertTrue((String)in, (boolean)in.contains("@timestamp"));
        Assert.assertTrue((String)in, (boolean)in.contains(AuditMessage.Category.FAILED_LOGIN.name()));
        Assert.assertTrue((String)in, (boolean)in.contains("FAILED_LOGIN"));
        Assert.assertTrue((String)in, (boolean)in.contains("John Doe"));
        Assert.assertTrue((String)in, (boolean)in.contains("8.8.8.8"));
    }
}

