/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.enterprise.auditlog.AuditLogConfig;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.routing.AuditMessageRouter;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.io.FileNotFoundException;
import java.util.Collection;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.mockito.Mockito;

public abstract class AbstractAuditlogiUnitTest
extends SingleClusterTest {
    protected RestHelper rh = null;
    protected boolean init = true;

    protected String getResourceFolder() {
        return "auditlog";
    }

    protected final void setup(Settings additionalSettings) throws Exception {
        Settings nodeSettings = this.defaultNodeSettings(additionalSettings);
        this.setup(Settings.EMPTY, new DynamicSgConfig(), nodeSettings, this.init);
        this.rh = this.restHelper();
    }

    protected Settings defaultNodeSettings(Settings additionalSettings) throws FileNotFoundException {
        Settings.Builder builder = Settings.builder();
        builder.put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks"));
        return builder.put(additionalSettings).build();
    }

    protected void setupStarfleetIndex() throws Exception {
        boolean sendHTTPClientCertificate = this.rh.sendHTTPClientCertificate;
        String keystore = this.rh.keystore;
        this.rh.sendHTTPClientCertificate = true;
        this.rh.keystore = "auditlog/kirk-keystore.jks";
        this.rh.executePutRequest("sf", null, new Header[0]);
        this.rh.executePutRequest("sf/_doc/0?refresh", "{\"number\" : \"NCC-1701-D\"}", new Header[0]);
        this.rh.executePutRequest("sf/_doc/1?refresh", "{\"some\" : \"value\"}", new Header[0]);
        this.rh.executePutRequest("sf/_doc/2?refresh", "{\"some\" : \"value\"}", new Header[0]);
        this.rh.sendHTTPClientCertificate = sendHTTPClientCertificate;
        this.rh.keystore = keystore;
    }

    protected boolean validateMsgs(Collection<AuditMessage> msgs) {
        boolean valid = true;
        for (AuditMessage msg : msgs) {
            valid = this.validateMsg(msg) && valid;
        }
        return valid;
    }

    protected boolean validateMsg(AuditMessage msg) {
        return this.validateJson(msg.toJson()) && this.validateJson(msg.toPrettyString());
    }

    protected boolean validateJson(String json) {
        if (json == null || json.isEmpty()) {
            return false;
        }
        try {
            DocNode node = DocNode.parse((Format)Format.JSON).from(json);
            if (node.get("audit_request_body") != null) {
                DocNode.parse((Format)Format.JSON).from(node.getAsString("audit_request_body"));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected AuditMessageRouter createMessageRouterComplianceEnabled(Settings settings) {
        AuditMessageRouter router = new AuditMessageRouter(settings, null, null, null);
        AuditLogConfig mockConfig = (AuditLogConfig)Mockito.mock(AuditLogConfig.class);
        Mockito.when((Object)mockConfig.isEnabled()).thenReturn((Object)true);
        router.setComplianceConfig(mockConfig);
        return router;
    }
}

