/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog;

import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auditlog.AuditLogModule;
import com.floragunn.searchguard.license.LicenseRepository;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;

public class AuditLogModuleTest {
    @Test
    public void shouldNotCreateAnyComponent_auditLogsAreDisabled() {
        Settings settings = Settings.builder().putNull("searchguard.audit.type").build();
        BaseDependencies baseDependencies = this.buildBaseDependencies(settings);
        AuditLogModule auditLogModule = new AuditLogModule();
        auditLogModule.createComponents(baseDependencies);
        MatcherAssert.assertThat((Object)auditLogModule.getAuditLog(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)auditLogModule.getDirectoryReaderWrappersForAllOperations(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)auditLogModule.getIndexOperationListeners(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)auditLogModule.getActionFilters(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldCreateComponents_auditLogsAreEnabled() {
        Settings settings = Settings.builder().put("searchguard.audit.type", "something").build();
        BaseDependencies baseDependencies = this.buildBaseDependencies(settings);
        AuditLogModule auditLogModule = new AuditLogModule();
        auditLogModule.createComponents(baseDependencies);
        MatcherAssert.assertThat((Object)auditLogModule.getAuditLog(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)auditLogModule.getDirectoryReaderWrappersForAllOperations(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)auditLogModule.getIndexOperationListeners(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)auditLogModule.getActionFilters(), (Matcher)Matchers.hasSize((int)2));
    }

    private BaseDependencies buildBaseDependencies(Settings settings) {
        Environment environment = (Environment)Mockito.mock(Environment.class);
        Mockito.when((Object)environment.settings()).thenReturn((Object)settings);
        ConfigurationRepository configurationRepository = (ConfigurationRepository)Mockito.mock(ConfigurationRepository.class);
        LicenseRepository licenseRepository = (LicenseRepository)Mockito.mock(LicenseRepository.class);
        return new BaseDependencies(settings, null, null, null, null, null, null, null, environment, null, null, null, configurationRepository, licenseRepository, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }
}

