/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.routing;

import com.floragunn.searchguard.enterprise.auditlog.AbstractAuditlogiUnitTest;
import com.floragunn.searchguard.enterprise.auditlog.helper.MockAuditMessageFactory;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.routing.AuditMessageRouter;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.DebugSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.ExternalESSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.InternalESSink;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.util.List;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Test;

public class RoutingConfigurationTest
extends AbstractAuditlogiUnitTest {
    @Test
    public void testValidConfiguration() throws Exception {
        Settings settings = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/routing/configuration_valid.yml")).build();
        AuditMessageRouter router = this.createMessageRouterComplianceEnabled(settings);
        Assert.assertEquals((Object)"default", (Object)router.defaultSink.getName());
        Assert.assertEquals(ExternalESSink.class, router.defaultSink.getClass());
        List sinks = (List)router.categorySinks.get(AuditMessage.Category.MISSING_PRIVILEGES);
        Assert.assertNotNull((Object)sinks);
        Assert.assertEquals((long)3L, (long)sinks.size());
        Assert.assertEquals((Object)"endpoint1", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(InternalESSink.class, ((AuditLogSink)sinks.get(0)).getClass());
        Assert.assertEquals((Object)"endpoint2", (Object)((AuditLogSink)sinks.get(1)).getName());
        Assert.assertEquals(ExternalESSink.class, ((AuditLogSink)sinks.get(1)).getClass());
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)sinks.get(2)).getName());
        Assert.assertEquals(ExternalESSink.class, ((AuditLogSink)sinks.get(2)).getClass());
        sinks = (List)router.categorySinks.get(AuditMessage.Category.COMPLIANCE_DOC_READ);
        Assert.assertEquals((long)1L, (long)sinks.size());
        Assert.assertEquals((Object)"endpoint3", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(0)).getClass());
    }

    @Test
    public void testNoDefaultSink() throws Exception {
        Settings settings = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/routing/configuration_no_default.yml")).build();
        AuditMessageRouter router = this.createMessageRouterComplianceEnabled(settings);
        Assert.assertEquals((Object)false, (Object)router.isEnabled());
        Assert.assertEquals(null, (Object)router.defaultSink);
        Assert.assertEquals((long)0L, (long)router.categorySinks.size());
        router.route(MockAuditMessageFactory.validAuditMessage());
    }

    @Test
    public void testMissingEndpoints() throws Exception {
        Settings settings = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/routing/configuration_wrong_endpoint_names.yml")).build();
        AuditMessageRouter router = this.createMessageRouterComplianceEnabled(settings);
        Assert.assertEquals(InternalESSink.class, router.defaultSink.getClass());
        List sinks = (List)router.categorySinks.get(AuditMessage.Category.MISSING_PRIVILEGES);
        Assert.assertEquals((long)2L, (long)sinks.size());
        Assert.assertEquals((Object)"endpoint1", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(InternalESSink.class, ((AuditLogSink)sinks.get(0)).getClass());
        Assert.assertEquals((Object)"endpoint3", (Object)((AuditLogSink)sinks.get(1)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(1)).getClass());
        sinks = (List)router.categorySinks.get(AuditMessage.Category.COMPLIANCE_DOC_WRITE);
        Assert.assertEquals((long)1L, (long)sinks.size());
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(InternalESSink.class, ((AuditLogSink)sinks.get(0)).getClass());
        sinks = (List)router.categorySinks.get(AuditMessage.Category.COMPLIANCE_DOC_READ);
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(InternalESSink.class, ((AuditLogSink)sinks.get(0)).getClass());
    }

    @Test
    public void testWrongCategories() throws Exception {
        Settings settings = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/routing/configuration_wrong_categories.yml")).build();
        AuditMessageRouter router = this.createMessageRouterComplianceEnabled(settings);
        Assert.assertEquals(DebugSink.class, router.defaultSink.getClass());
        List sinks = (List)router.categorySinks.get(AuditMessage.Category.MISSING_PRIVILEGES);
        Assert.assertEquals((long)3L, (long)sinks.size());
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(0)).getClass());
        Assert.assertEquals((Object)"endpoint1", (Object)((AuditLogSink)sinks.get(1)).getName());
        Assert.assertEquals(InternalESSink.class, ((AuditLogSink)sinks.get(1)).getClass());
        Assert.assertEquals((Object)"endpoint2", (Object)((AuditLogSink)sinks.get(2)).getName());
        Assert.assertEquals(ExternalESSink.class, ((AuditLogSink)sinks.get(2)).getClass());
        sinks = (List)router.categorySinks.get(AuditMessage.Category.GRANTED_PRIVILEGES);
        Assert.assertEquals((long)3L, (long)sinks.size());
        Assert.assertEquals((Object)"endpoint1", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(InternalESSink.class, ((AuditLogSink)sinks.get(0)).getClass());
        Assert.assertEquals((Object)"endpoint3", (Object)((AuditLogSink)sinks.get(1)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(1)).getClass());
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)sinks.get(2)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(2)).getClass());
        sinks = (List)router.categorySinks.get(AuditMessage.Category.AUTHENTICATED);
        Assert.assertEquals((long)1L, (long)sinks.size());
        Assert.assertEquals((Object)"endpoint1", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(InternalESSink.class, ((AuditLogSink)sinks.get(0)).getClass());
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)((List)router.categorySinks.get(AuditMessage.Category.BAD_HEADERS)).get(0)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)((List)router.categorySinks.get(AuditMessage.Category.BAD_HEADERS)).get(0)).getClass());
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)((List)router.categorySinks.get(AuditMessage.Category.FAILED_LOGIN)).get(0)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)((List)router.categorySinks.get(AuditMessage.Category.FAILED_LOGIN)).get(0)).getClass());
    }

    @Test
    public void testWrongEndpointTypes() throws Exception {
        Settings settings = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/routing/configuration_wrong_endpoint_types.yml")).build();
        AuditMessageRouter router = this.createMessageRouterComplianceEnabled(settings);
        Assert.assertEquals(DebugSink.class, router.defaultSink.getClass());
        List sinks = (List)router.categorySinks.get(AuditMessage.Category.MISSING_PRIVILEGES);
        Assert.assertEquals((long)3L, (long)sinks.size());
        Assert.assertEquals((Object)"endpoint2", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(ExternalESSink.class, ((AuditLogSink)sinks.get(0)).getClass());
        Assert.assertEquals((Object)"endpoint3", (Object)((AuditLogSink)sinks.get(1)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(1)).getClass());
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)sinks.get(2)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(2)).getClass());
        sinks = (List)router.categorySinks.get(AuditMessage.Category.COMPLIANCE_DOC_WRITE);
        Assert.assertEquals((long)1L, (long)sinks.size());
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(0)).getClass());
        sinks = (List)router.categorySinks.get(AuditMessage.Category.COMPLIANCE_DOC_READ);
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(0)).getClass());
    }
}

