/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.access_log.write;

import com.floragunn.searchguard.GuiceDependencies;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.auditlog.AuditLogConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;

public final class ComplianceIndexingOperationListenerImpl
implements IndexingOperationListener {
    private static final Logger log = LogManager.getLogger(ComplianceIndexingOperationListenerImpl.class);
    private final AuditLogConfig complianceConfig;
    private final AuditLog auditlog;
    private final GuiceDependencies guiceDependencies;
    private static final ThreadLocal<Context> threadContext = new ThreadLocal();

    public ComplianceIndexingOperationListenerImpl(AuditLogConfig complianceConfig, AuditLog auditlog, GuiceDependencies guiceDependencies) {
        this.complianceConfig = complianceConfig;
        this.auditlog = auditlog;
        this.guiceDependencies = guiceDependencies;
    }

    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        if (delete.origin() != Engine.Operation.Origin.PRIMARY) {
            return;
        }
        if (this.isEnabled(shardId) && result.getFailure() == null && result.isFound()) {
            this.auditlog.logDocumentDeleted(shardId, delete, result);
        }
    }

    public Engine.Index preIndex(ShardId shardId, Engine.Index index) {
        block9: {
            if (index.origin() != Engine.Operation.Origin.PRIMARY) {
                return index;
            }
            if (this.isEnabled(shardId) && this.complianceConfig.logDiffsForWrite()) {
                IndexShard shard = this.getIndexShard(shardId);
                if (shard == null) {
                    return index;
                }
                if (shard.isReadAllowed()) {
                    try {
                        GetResult getResult = shard.getService().getForUpdate(index.id(), index.getIfSeqNo(), index.getIfPrimaryTerm());
                        if (getResult.isExists()) {
                            threadContext.set(new Context(getResult));
                            break block9;
                        }
                        threadContext.set(new Context(null));
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Cannot retrieve original document due to {}", (Object)e.toString());
                        }
                        break block9;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Cannot read from shard {}", (Object)shardId);
                }
            }
        }
        return index;
    }

    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        if (this.complianceConfig.isEnabled() && this.complianceConfig.logDiffsForWrite()) {
            threadContext.remove();
        }
    }

    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        if (this.isEnabled(shardId)) {
            if (this.complianceConfig.logDiffsForWrite()) {
                Context context = threadContext.get();
                GetResult previousContent = context == null ? null : context.getGetResult();
                threadContext.remove();
                if (result.getFailure() != null || index.origin() != Engine.Operation.Origin.PRIMARY) {
                    return;
                }
                if (previousContent == null) {
                    if (!result.isCreated()) {
                        log.warn("No previous content and not created (its an update but do not find orig source) for {}", (Object)(index.startTime() + "/" + shardId + "/" + index.id()));
                    }
                    assert (result.isCreated()) : "No previous content and not created";
                } else {
                    if (result.isCreated()) {
                        log.warn("Previous content and created for {}", (Object)(index.startTime() + "/" + shardId + "/" + index.id()));
                    }
                    assert (!result.isCreated()) : "Previous content and created";
                }
                this.auditlog.logDocumentWritten(shardId, previousContent, index, result);
            } else {
                if (result.getFailure() != null || index.origin() != Engine.Operation.Origin.PRIMARY) {
                    return;
                }
                this.auditlog.logDocumentWritten(shardId, null, index, result);
            }
        }
    }

    private boolean isEnabled(ShardId shardId) {
        return this.complianceConfig.isEnabled() && this.complianceConfig.writeHistoryEnabledForIndex(shardId.getIndex().getName());
    }

    private IndexShard getIndexShard(ShardId shardId) {
        IndexService indexService = this.guiceDependencies.getIndicesService().indexServiceSafe(shardId.getIndex());
        return indexService.getShardOrNull(shardId.getId());
    }

    private static final class Context {
        private final GetResult getResult;

        public Context(GetResult getResult) {
            this.getResult = getResult;
        }

        public GetResult getGetResult() {
            return this.getResult;
        }
    }
}

