/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auditlog.helper.MockRestRequest;
import com.floragunn.searchguard.enterprise.auditlog.helper.RetrySink;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditLogImpl;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.integration.TestAuditlogImpl;
import com.floragunn.searchguard.legacy.test.AbstractSGUnitTest;
import com.floragunn.searchguard.user.UserInformation;
import com.floragunn.searchsupport.action.StandardRequests;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AuditlogTest {
    private static final List<String> DISABLED_FIELDS = Arrays.asList("audit_format_version", "audit_request_effective_user", "audit_category");
    public static final TimeValue MASTER_NODE_TIMEOUT = TimeValue.timeValueSeconds((long)40L);
    ClusterService cs = (ClusterService)Mockito.mock(ClusterService.class);
    DiscoveryNode dn = (DiscoveryNode)Mockito.mock(DiscoveryNode.class);
    ConfigurationRepository configurationRepository = (ConfigurationRepository)Mockito.mock(ConfigurationRepository.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.dn.getHostAddress()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.dn.getId()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.dn.getHostName()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.cs.localNode()).thenReturn((Object)this.dn);
        Mockito.when((Object)this.cs.getClusterName()).thenReturn((Object)new ClusterName("cname"));
    }

    @Test
    public void testClusterHealthRequest() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)new ClusterHealthRequest(MASTER_NODE_TIMEOUT), null);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        }
    }

    @Test
    public void testSearchRequest() throws IOException {
        SearchRequest sr = new SearchRequest();
        sr.indices(new String[]{"index1", "logstash*"});
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)sr, null);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        }
    }

    @Test
    public void testSslException() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.threadpool.size", 0).build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logSSLException(null, (Throwable)new Exception("test rest"));
            al.logSSLException(null, (Throwable)new Exception("test rest"), null, null);
            Assert.assertEquals((long)2L, (long)TestAuditlogImpl.messages.size());
        }
    }

    @Test
    public void testRetry() throws IOException {
        RetrySink.init();
        Settings settings = Settings.builder().put("searchguard.audit.type", RetrySink.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.retry_count", 10).put("searchguard.audit.config.retry_delay_ms", 500).put("searchguard.audit.threadpool.size", 0).build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            al.logSSLException(null, (Throwable)new Exception("test retry"));
            Assert.assertNotNull((Object)RetrySink.getMsg());
            Assert.assertTrue((boolean)RetrySink.getMsg().toJson().contains("test retry"));
        }
    }

    @Test
    public void testNoRetry() throws IOException {
        RetrySink.init();
        Settings settings = Settings.builder().put("searchguard.audit.type", RetrySink.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.retry_count", 0).put("searchguard.audit.config.retry_delay_ms", 500).put("searchguard.audit.threadpool.size", 0).build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            al.logSSLException(null, (Throwable)new Exception("test retry"));
            Assert.assertNull((Object)RetrySink.getMsg());
        }
    }

    @Test
    public void testDisablingAuditLogFields_sLogGrantedPrivileges() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).putList("searchguard.audit.config.disabled_fields", DISABLED_FIELDS).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)new ClusterHealthRequest(MASTER_NODE_TIMEOUT), null);
            this.assertAuditLogDoesNotContainDisabledFields();
        }
    }

    @Test
    public void testDisablingAuditLogFields_sLogFailedLogin() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).putList("searchguard.audit.config.disabled_fields", DISABLED_FIELDS).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logFailedLogin(UserInformation.forName((String)"testuser.transport.failedlogin"), false, UserInformation.forName((String)"testuser.transport.failedlogin"), (TransportRequest)new StandardRequests.EmptyRequest(), null);
            this.assertAuditLogDoesNotContainDisabledFields();
        }
    }

    @Test
    public void testDisablingAuditLogFields_sLogFailedLoginWithoutTask() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).putList("searchguard.audit.config.disabled_fields", DISABLED_FIELDS).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logFailedLogin(UserInformation.forName((String)"testuser.rest.failedlogin"), false, UserInformation.forName((String)"testuser.rest.failedlogin"), (RestRequest)new MockRestRequest());
            this.assertAuditLogDoesNotContainDisabledFields();
        }
    }

    @Test
    public void testDisablingAuditLogFields_sLogBlockedUser() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).putList("searchguard.audit.config.disabled_fields", DISABLED_FIELDS).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logBlockedUser(UserInformation.forName((String)"testuser.rest.failedlogin"), false, UserInformation.forName((String)"testuser.rest.failedlogin"), (RestRequest)new MockRestRequest());
            this.assertAuditLogDoesNotContainDisabledFields();
        }
    }

    @Test
    public void testDisablingAuditLogFields_sLogSucceededLogin() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).putList("searchguard.audit.config.disabled_fields", DISABLED_FIELDS).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logSucceededLogin(UserInformation.forName((String)"testuser.rest.failedlogin"), false, UserInformation.forName((String)"testuser.rest.failedlogin"), (TransportRequest)new StandardRequests.EmptyRequest(), null, null);
            this.assertAuditLogDoesNotContainDisabledFields();
        }
    }

    @Test
    public void testDisablingAuditLogFields_sLogSucceededLoginWithoutTask() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).putList("searchguard.audit.config.disabled_fields", DISABLED_FIELDS).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logSucceededLogin(UserInformation.forName((String)"testuser.rest.failedlogin"), false, UserInformation.forName((String)"testuser.rest.failedlogin"), (RestRequest)new MockRestRequest());
            this.assertAuditLogDoesNotContainDisabledFields();
        }
    }

    @Test
    public void testDisablingAuditLogFields_sLogMissingPrivileges() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).putList("searchguard.audit.config.disabled_fields", DISABLED_FIELDS).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logMissingPrivileges("indices:data/read/search", (TransportRequest)new ClusterHealthRequest(MASTER_NODE_TIMEOUT), null);
            this.assertAuditLogDoesNotContainDisabledFields();
        }
    }

    @Test
    public void testDisablingAuditLogFields_sLogBadHeadersTransportRequest() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).putList("searchguard.audit.config.disabled_fields", DISABLED_FIELDS).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logBadHeaders((TransportRequest)new StandardRequests.EmptyRequest(), "action", null);
            this.assertAuditLogDoesNotContainDisabledFields();
        }
    }

    @Test
    public void testDisablingAuditLogFields_sLogBadHeadersRestRequest() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).putList("searchguard.audit.config.disabled_fields", DISABLED_FIELDS).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logBadHeaders((RestRequest)new MockRestRequest());
            this.assertAuditLogDoesNotContainDisabledFields();
        }
    }

    @Test
    public void testCustomFields() throws IOException {
        String customField1 = "field1";
        String customValue1 = "val1";
        String customField2 = "field2";
        String customValue2 = "val2";
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.custom_attributes." + customField1, customValue1).put("searchguard.audit.config.custom_attributes." + customField2, customValue2).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logBadHeaders((RestRequest)new MockRestRequest());
            Map<String, Object> auditMessages = TestAuditlogImpl.messages.stream().map(AuditMessage::getAsMap).flatMap(stringObjectMap -> stringObjectMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Assert.assertEquals((Object)customValue1, (Object)auditMessages.get("audit_custom_" + customField1));
            Assert.assertEquals((Object)customValue2, (Object)auditMessages.get("audit_custom_" + customField2));
        }
    }

    @Test
    public void testCustomFieldsWithDisabledFields() throws IOException {
        String customField1 = "field1";
        String customValue1 = "val1";
        String customField2 = "field2";
        String customValue2 = "val2";
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.custom_attributes." + customField1, customValue1).put("searchguard.audit.config.custom_attributes." + customField2, customValue2).putList("searchguard.audit.config.disabled_fields", Arrays.asList("audit_custom_" + customField2)).put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logBadHeaders((RestRequest)new MockRestRequest());
            Map<String, Object> auditMessages = TestAuditlogImpl.messages.stream().map(AuditMessage::getAsMap).flatMap(stringObjectMap -> stringObjectMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Assert.assertEquals((Object)customValue1, (Object)auditMessages.get("audit_custom_" + customField1));
            Assert.assertFalse((boolean)auditMessages.containsKey("audit_custom_" + customField2));
        }
    }

    @Test
    public void testKibanaLogin() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).build();
        String userName = "test-user";
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logSucceededKibanaLogin(UserInformation.forName((String)userName));
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Map msgAsMap = TestAuditlogImpl.messages.get(0).getAsMap();
            Assert.assertEquals((Object)AuditLog.Origin.REST, msgAsMap.get("audit_request_layer"));
            Assert.assertEquals((Object)userName, msgAsMap.get("audit_request_effective_user"));
            Assert.assertNotNull(msgAsMap.get("@timestamp"));
            Assert.assertEquals((Object)AuditMessage.Category.KIBANA_LOGIN, msgAsMap.get("audit_category"));
            Assert.assertNotNull(msgAsMap.get("audit_format_version"));
        }
    }

    @Test
    public void testKibanaLogout() throws IOException {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).build();
        String userName = "test-user";
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logSucceededKibanaLogout(UserInformation.forName((String)userName));
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Map msgAsMap = TestAuditlogImpl.messages.get(0).getAsMap();
            Assert.assertEquals((Object)AuditLog.Origin.REST, msgAsMap.get("audit_request_layer"));
            Assert.assertEquals((Object)userName, msgAsMap.get("audit_request_effective_user"));
            Assert.assertNotNull(msgAsMap.get("@timestamp"));
            Assert.assertEquals((Object)AuditMessage.Category.KIBANA_LOGOUT, msgAsMap.get("audit_category"));
            Assert.assertNotNull(msgAsMap.get("audit_format_version"));
        }
    }

    @Test
    public void testCreateIndexRequest_requestBodyFieldIsFilledInCorrectly() throws Exception {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).build();
        String indexName = "test-index";
        DocNode indexSettings = DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_shards", (Object)"3"));
        DocNode indexMappings = DocNode.of((String)"_doc", (Object)DocNode.of((String)"properties", (Object)DocNode.of((String)"field1", (Object)DocNode.of((String)"type", (Object)"text"))));
        DocNode indexAliases = DocNode.of((String)"alias2", (Object)DocNode.of((String)"filter", (Object)DocNode.of((String)"term", (Object)DocNode.of((String)"doc", (Object)"1")), (String)"index_routing", (Object)"shard1"));
        String cause = "cause";
        String origin = "origin";
        CreateIndexRequest request = new CreateIndexRequest(indexName).settings((Map)indexSettings).mapping((Map)indexMappings).aliases((Map)indexAliases).cause(cause).origin(origin);
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logIndexCreated(indexName, TransportCreateIndexAction.TYPE.name(), (TransportRequest)request);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            DocNode message = DocNode.wrap((Object)TestAuditlogImpl.messages.get(0).getAsMap());
            DocNode requestBody = DocNode.parse((Format)Format.JSON).from(message.getAsString("audit_request_body"));
            Assert.assertEquals((String)("Request body contains expected no of fields, " + requestBody.toJsonString()), (long)6L, (long)requestBody.size());
            Assert.assertEquals((Object)indexName, (Object)requestBody.getAsString("index"));
            Assert.assertEquals((Object)indexSettings.toJsonString(), (Object)requestBody.getAsNode("settings").toJsonString());
            Assert.assertEquals((Object)indexMappings.toJsonString(), (Object)requestBody.getAsNode("mappings").toJsonString());
            Assert.assertEquals((Object)DocNode.array((Object[])new Object[]{indexAliases}).toJsonString(), (Object)requestBody.getAsNode("aliases").toJsonString());
            Assert.assertEquals((Object)cause, (Object)requestBody.getAsString("cause"));
            Assert.assertEquals((Object)origin, (Object)requestBody.getAsString("origin"));
        }
    }

    @Test
    public void testUpdateSettingsRequest_requestBodyFieldIsFilledInCorrectly() throws Exception {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).build();
        String indexName = "test-index";
        DocNode indexSettings = DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_shards", (Object)"3"));
        boolean preserveExisting = true;
        String origin = "origin";
        UpdateSettingsRequest request = new UpdateSettingsRequest(new String[]{indexName}).settings((Map)indexSettings).setPreserveExisting(preserveExisting).origin(origin);
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logIndexCreated(indexName, TransportCreateIndexAction.TYPE.name(), (TransportRequest)request);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            DocNode message = DocNode.wrap((Object)TestAuditlogImpl.messages.get(0).getAsMap());
            DocNode requestBody = DocNode.parse((Format)Format.JSON).from(message.getAsString("audit_request_body"));
            Assert.assertEquals((String)("Request body contains expected no of fields, " + requestBody.toJsonString()), (long)4L, (long)requestBody.size());
            Assert.assertEquals((Object)DocNode.array((Object[])new Object[]{indexName}).toJsonString(), (Object)requestBody.getAsNode("indices").toJsonString());
            Assert.assertEquals((Object)indexSettings.toJsonString(), (Object)requestBody.getAsNode("settings").toJsonString());
            Assert.assertEquals((Object)request.isPreserveExisting(), (Object)requestBody.getBoolean("preserve_existing"));
            Assert.assertEquals((Object)origin, (Object)requestBody.getAsString("origin"));
        }
    }

    @Test
    public void testPutMappingRequest_requestBodyFieldIsFilledInCorrectly() throws Exception {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).build();
        String indexName = "test-index";
        DocNode indexMappings = DocNode.of((String)"_doc", (Object)DocNode.of((String)"properties", (Object)DocNode.of((String)"field1", (Object)DocNode.of((String)"type", (Object)"text"))));
        boolean writeIndexOnly = true;
        String origin = "origin";
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source((Map)indexMappings).writeIndexOnly(writeIndexOnly).origin(origin);
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logIndexCreated(indexName, TransportCreateIndexAction.TYPE.name(), (TransportRequest)request);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            DocNode message = DocNode.wrap((Object)TestAuditlogImpl.messages.get(0).getAsMap());
            DocNode requestBody = DocNode.parse((Format)Format.JSON).from(message.getAsString("audit_request_body"));
            Assert.assertEquals((String)("Request body contains expected no of fields, " + requestBody.toJsonString()), (long)4L, (long)requestBody.size());
            Assert.assertEquals((Object)DocNode.array((Object[])new Object[]{indexName}).toJsonString(), (Object)requestBody.getAsNode("indices").toJsonString());
            Assert.assertEquals((Object)indexMappings.toJsonString(), (Object)requestBody.getAsNode("source").toJsonString());
            Assert.assertEquals((Object)request.writeIndexOnly(), (Object)requestBody.getBoolean("write_index_only"));
            Assert.assertEquals((Object)origin, (Object)requestBody.getAsString("origin"));
        }
    }

    private void assertAuditLogDoesNotContainDisabledFields() {
        Assert.assertFalse((boolean)TestAuditlogImpl.messages.stream().map(m -> m.getAsMap().keySet()).flatMap(Collection::stream).anyMatch(DISABLED_FIELDS::contains));
    }
}

