/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auditlog.helper.MockRestRequest;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditLogImpl;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.integration.TestAuditlogImpl;
import com.floragunn.searchguard.legacy.test.AbstractSGUnitTest;
import com.floragunn.searchguard.user.UserInformation;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.util.EsLogging;
import com.google.common.base.Joiner;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class DisabledCategoriesTest {
    @ClassRule
    public static EsLogging esLogging = new EsLogging();
    ClusterService cs = (ClusterService)Mockito.mock(ClusterService.class);
    DiscoveryNode dn = (DiscoveryNode)Mockito.mock(DiscoveryNode.class);
    ConfigurationRepository configurationRepository = (ConfigurationRepository)Mockito.mock(ConfigurationRepository.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.dn.getHostAddress()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.dn.getId()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.dn.getHostName()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.cs.localNode()).thenReturn((Object)this.dn);
        Mockito.when((Object)this.cs.getClusterName()).thenReturn((Object)new ClusterName("cname"));
        TestAuditlogImpl.clear();
    }

    @Test
    public void completetlyInvalidConfigurationTest() throws Exception {
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("searchguard.audit.type", TestAuditlogImpl.class.getName());
        settingsBuilder.put("searchguard.audit.config.disabled_transport_categories", "nonexistent");
        settingsBuilder.put("searchguard.audit.config.disabled_rest_categories", "nonexistent");
        AuditLogImpl auditLog = new AuditLogImpl(settingsBuilder.build(), null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);
        this.logAll((AuditLog)auditLog);
        auditLog.close();
        String result = TestAuditlogImpl.sb.toString();
        Assert.assertTrue((boolean)this.categoriesPresentInLog(result, DisabledCategoriesTest.filterComplianceCategories(AuditMessage.Category.values())));
    }

    @Test
    public void invalidConfigurationTest() {
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("searchguard.audit.type", "debug");
        settingsBuilder.put("searchguard.audit.config.disabled_categories", "nonexistant, bad_headers");
        AuditLogImpl auditLog = new AuditLogImpl(settingsBuilder.build(), null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);
        this.logAll((AuditLog)auditLog);
        String result = TestAuditlogImpl.sb.toString();
        Assert.assertFalse((boolean)this.categoriesPresentInLog(result, AuditMessage.Category.BAD_HEADERS));
    }

    @Test
    public void enableAllCategoryTest() throws Exception {
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("searchguard.audit.type", TestAuditlogImpl.class.getName());
        settingsBuilder.put("searchguard.audit.config.disabled_transport_categories", "NONE");
        settingsBuilder.put("searchguard.audit.config.disabled_rest_categories", "NONE");
        AuditLogImpl auditLog = new AuditLogImpl(settingsBuilder.build(), null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);
        this.logAll((AuditLog)auditLog);
        auditLog.close();
        String result = TestAuditlogImpl.sb.toString();
        Assert.assertTrue((String)(AuditMessage.Category.values() + "#" + result), (boolean)this.categoriesPresentInLog(result, DisabledCategoriesTest.filterComplianceCategories(AuditMessage.Category.values())));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"testuser.rest.succeededlogin"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"testuser.rest.failedlogin"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"privilege.missing"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"action.indexattempt"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"action.transport.ssl"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"action.success"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"Empty"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"putted-composable-template-name"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"putted-legacy-template-name"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"deleted-template-name"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"created-index-name"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"deleted-index-name"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"index-with-updated-settings"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"index-with-updated-mappings"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"testuser.kibana.succeededlogin"));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"testuser.kibana.succeededlogout"));
    }

    @Test
    public void disableSingleCategoryTest() throws Exception {
        for (AuditMessage.Category category : AuditMessage.Category.values()) {
            TestAuditlogImpl.clear();
            this.checkCategoriesDisabled(category);
        }
    }

    @Test
    public void disableAllCategoryTest() throws Exception {
        this.checkCategoriesDisabled(AuditMessage.Category.values());
    }

    @Test
    public void disableSomeCategoryTest() throws Exception {
        this.checkCategoriesDisabled(AuditMessage.Category.AUTHENTICATED, AuditMessage.Category.BAD_HEADERS, AuditMessage.Category.FAILED_LOGIN, AuditMessage.Category.INDEX_TEMPLATE_WRITE);
    }

    protected void checkCategoriesDisabled(AuditMessage.Category ... disabledCategories) throws Exception {
        LinkedList<String> categoryNames = new LinkedList<String>();
        for (AuditMessage.Category category : disabledCategories) {
            categoryNames.add(category.name().toLowerCase());
        }
        String disabledCategoriesString = Joiner.on((String)",").join(categoryNames);
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("searchguard.audit.type", TestAuditlogImpl.class.getName());
        settingsBuilder.put("searchguard.audit.config.disabled_transport_categories", disabledCategoriesString);
        settingsBuilder.put("searchguard.audit.config.disabled_rest_categories", disabledCategoriesString);
        AuditLogImpl auditLog = new AuditLogImpl(settingsBuilder.build(), null, null, AbstractSGUnitTest.MOCK_POOL, null, this.cs, this.configurationRepository);
        this.logAll((AuditLog)auditLog);
        auditLog.close();
        String result = TestAuditlogImpl.sb.toString();
        LinkedList<AuditMessage.Category> allButDisablesCategories = new LinkedList<AuditMessage.Category>(Arrays.asList(AuditMessage.Category.values()));
        allButDisablesCategories.removeAll(Arrays.asList(disabledCategories));
        Assert.assertFalse((boolean)this.categoriesPresentInLog(result, disabledCategories));
        Assert.assertTrue((boolean)this.categoriesPresentInLog(result, DisabledCategoriesTest.filterComplianceCategories(allButDisablesCategories.toArray(new AuditMessage.Category[0]))));
    }

    protected boolean categoriesPresentInLog(String result, AuditMessage.Category ... categories) {
        result = result.replaceAll(" ", "");
        for (AuditMessage.Category category : categories) {
            if (result.contains("\"audit_category\":\"" + category.name() + "\"")) continue;
            return false;
        }
        return true;
    }

    protected void logAll(AuditLog auditLog) {
        this.logRestFailedLogin(auditLog);
        this.logRestBadHeaders(auditLog);
        this.logRestSSLException(auditLog);
        this.logRestSucceededLogin(auditLog);
        this.logMissingPrivileges(auditLog);
        this.logSgIndexAttempt(auditLog);
        this.logAuthenticatedRequest(auditLog);
        this.logTransportSSLException(auditLog);
        this.logTransportBadHeaders(auditLog);
        this.logTransportFailedLogin(auditLog);
        this.logTransportSucceededLogin(auditLog);
        this.logBlockedIp(auditLog);
        this.logBlockedUser(auditLog);
        this.logComposableIndexTemplatePutted(auditLog);
        this.logLegacyIndexTemplatePutted(auditLog);
        this.logIndexTemplateDeleted(auditLog);
        this.logIndexCreated(auditLog);
        this.logIndicesDeleted(auditLog);
        this.logIndexSettingsUpdated(auditLog);
        this.logIndexMappingsUpdated(auditLog);
        this.logSucceededKibanaLogin(auditLog);
        this.logSucceededKibanaLogout(auditLog);
    }

    protected void logRestSucceededLogin(AuditLog auditLog) {
        auditLog.logSucceededLogin(UserInformation.forName((String)"testuser.rest.succeededlogin"), false, UserInformation.forName((String)"testuser.rest.succeededlogin"), (RestRequest)new MockRestRequest());
    }

    protected void logTransportSucceededLogin(AuditLog auditLog) {
        auditLog.logSucceededLogin(UserInformation.forName((String)"testuser.transport.succeededlogin"), false, UserInformation.forName((String)"testuser.transport.succeededlogin"), (TransportRequest)new StandardRequests.EmptyRequest(), "test/action", new Task(0L, "x", "ac", "", null, null));
    }

    protected void logRestFailedLogin(AuditLog auditLog) {
        auditLog.logFailedLogin(UserInformation.forName((String)"testuser.rest.failedlogin"), false, UserInformation.forName((String)"testuser.rest.failedlogin"), (RestRequest)new MockRestRequest());
    }

    protected void logTransportFailedLogin(AuditLog auditLog) {
        auditLog.logFailedLogin(UserInformation.forName((String)"testuser.transport.failedlogin"), false, UserInformation.forName((String)"testuser.transport.failedlogin"), (TransportRequest)new StandardRequests.EmptyRequest(), null);
    }

    protected void logMissingPrivileges(AuditLog auditLog) {
        auditLog.logMissingPrivileges("privilege.missing", (TransportRequest)new StandardRequests.EmptyRequest(), null);
    }

    protected void logTransportBadHeaders(AuditLog auditLog) {
        auditLog.logBadHeaders((TransportRequest)new StandardRequests.EmptyRequest(), "action", null);
    }

    protected void logRestBadHeaders(AuditLog auditLog) {
        auditLog.logBadHeaders((RestRequest)new MockRestRequest());
    }

    protected void logSgIndexAttempt(AuditLog auditLog) {
        auditLog.logSgIndexAttempt((TransportRequest)new StandardRequests.EmptyRequest(), "action.indexattempt", null);
    }

    protected void logRestSSLException(AuditLog auditLog) {
        auditLog.logSSLException((RestRequest)new MockRestRequest(), (Throwable)new Exception());
    }

    protected void logTransportSSLException(AuditLog auditLog) {
        auditLog.logSSLException((TransportRequest)new StandardRequests.EmptyRequest(), (Throwable)new Exception(), "action.transport.ssl", null);
    }

    protected void logAuthenticatedRequest(AuditLog auditLog) {
        auditLog.logGrantedPrivileges("action.success", (TransportRequest)new StandardRequests.EmptyRequest(), null);
    }

    protected void logBlockedIp(AuditLog auditLog) {
        auditLog.logBlockedIp((RestRequest)new MockRestRequest(), new InetSocketAddress(1234));
    }

    protected void logBlockedUser(AuditLog auditLog) {
        auditLog.logBlockedUser(UserInformation.forName((String)"horst"), false, UserInformation.forName((String)"horst"), (RestRequest)new MockRestRequest());
    }

    protected void logComposableIndexTemplatePutted(AuditLog auditLog) {
        ComposableIndexTemplate indexTemplate = new ComposableIndexTemplate.Builder().build();
        auditLog.logIndexTemplatePutted("putted-composable-template-name", null, indexTemplate, "action.index-template-putted", (TransportRequest)new StandardRequests.EmptyRequest());
    }

    protected void logLegacyIndexTemplatePutted(AuditLog auditLog) {
        IndexTemplateMetadata indexTemplate = IndexTemplateMetadata.builder((String)"putted-legacy-template-name").patterns(Collections.singletonList("index-pattern")).build();
        auditLog.logIndexTemplatePutted("putted-composable-template-name", null, indexTemplate, "action.index-template-putted", (TransportRequest)new StandardRequests.EmptyRequest());
    }

    protected void logIndexTemplateDeleted(AuditLog auditLog) {
        auditLog.logIndexTemplateDeleted(Collections.singletonList("deleted-template-name"), "action.index-template-deleted", (TransportRequest)new StandardRequests.EmptyRequest());
    }

    protected void logIndexCreated(AuditLog auditLog) {
        auditLog.logIndexCreated("created-index-name", "action.index-created", (TransportRequest)new StandardRequests.EmptyRequest());
    }

    protected void logIndicesDeleted(AuditLog auditLog) {
        auditLog.logIndicesDeleted(Collections.singletonList("deleted-index-name"), "action.index-deleted", (TransportRequest)new StandardRequests.EmptyRequest());
    }

    protected void logIndexSettingsUpdated(AuditLog auditLog) {
        Settings settings = Settings.EMPTY;
        auditLog.logIndexSettingsUpdated(Collections.singletonList("index-with-updated-settings"), "index-with-updated-settings", (TransportRequest)new StandardRequests.EmptyRequest());
    }

    protected void logIndexMappingsUpdated(AuditLog auditLog) {
        try {
            auditLog.logIndexMappingsUpdated(Collections.singletonList("index-with-updated-mappings"), "index-with-updated-mappings", (TransportRequest)new StandardRequests.EmptyRequest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void logSucceededKibanaLogin(AuditLog auditLog) {
        auditLog.logSucceededKibanaLogin(UserInformation.forName((String)"testuser.kibana.succeededlogin"));
    }

    protected void logSucceededKibanaLogout(AuditLog auditLog) {
        auditLog.logSucceededKibanaLogout(UserInformation.forName((String)"testuser.kibana.succeededlogout"));
    }

    private static final AuditMessage.Category[] filterComplianceCategories(AuditMessage.Category[] cats) {
        ArrayList<AuditMessage.Category> retval = new ArrayList<AuditMessage.Category>();
        for (AuditMessage.Category c : cats) {
            if (c.toString().startsWith("COMPLIANCE")) continue;
            retval.add(c);
        }
        return retval.toArray(new AuditMessage.Category[0]);
    }
}

