/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.integration;

import com.floragunn.searchguard.enterprise.auditlog.AbstractAuditlogiUnitTest;
import com.floragunn.searchguard.enterprise.auditlog.integration.TestAuditlogImpl;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import org.apache.http.Header;
import org.apache.http.NoHttpResponseException;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class BasicAuditlogTest
extends AbstractAuditlogiUnitTest {
    @Test
    public void testSimpleAuthenticated() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.disabled_transport_categories", "authenticated").put("searchguard.audit.config.disabled_rest_categories", "authenticated").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        this.setupStarfleetIndex();
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_search", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Thread.sleep(1500L);
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("GRANTED_PRIVILEGES"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("indices:data/read/search"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("REST"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().toLowerCase().contains("authorization"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testSSLPlainText() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        try {
            this.nonSslRestHelper().executeGetRequest("_search", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
            Assert.fail();
        }
        catch (NoHttpResponseException noHttpResponseException) {
            // empty catch block
        }
        Thread.sleep(1500L);
        Assert.assertFalse((boolean)TestAuditlogImpl.messages.isEmpty());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("SSL_EXCEPTION"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("exception_stacktrace"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("not an SSL/TLS record"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testDefaultsRest() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        this.setupStarfleetIndex();
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_search", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Thread.sleep(1500L);
        Assert.assertEquals((long)2L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("GRANTED_PRIVILEGES"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("AUTHENTICATED"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("indices:data/read/search"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("TRANSPORT"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("\"audit_request_effective_user\" : \"admin\""));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("REST"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().toLowerCase().contains("authorization"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testAuthenticated() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        this.setupStarfleetIndex();
        TestAuditlogImpl.clear();
        this.testMsearch();
        TestAuditlogImpl.clear();
        this.testBulkAuth();
        TestAuditlogImpl.clear();
        this.testBulkNonAuth();
        TestAuditlogImpl.clear();
        this.testUpdateSettings();
        TestAuditlogImpl.clear();
    }

    @Test
    public void testNonAuthenticated() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.threadpool.size", -1).build();
        this.setup(additionalSettings);
        this.setupStarfleetIndex();
        TestAuditlogImpl.clear();
        this.testJustAuthenticated();
        TestAuditlogImpl.clear();
        this.testBadHeader();
        TestAuditlogImpl.clear();
        this.testMissingPriv();
        TestAuditlogImpl.clear();
        this.testUnauthenticated();
        TestAuditlogImpl.clear();
        this.testUnknownAuthorization();
        TestAuditlogImpl.clear();
        this.testWrongUser();
        TestAuditlogImpl.clear();
    }

    public void testWrongUser() throws Exception {
        RestHelper.HttpResponse response = this.rh.executeGetRequest("", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"wronguser", (String)"admin")});
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Thread.sleep(500L);
        Assert.assertTrue((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("FAILED_LOGIN"));
        Assert.assertTrue((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("wronguser"));
        Assert.assertTrue((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("@timestamp"));
        Assert.assertFalse((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("AUTHENTICATED"));
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testUnknownAuthorization() throws Exception {
        RestHelper.HttpResponse response = this.rh.executeGetRequest("", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"unknown", (String)"unknown")});
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("FAILED_LOGIN"));
        Assert.assertFalse((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("Basic dW5rbm93bjp1bmtub3du"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("@timestamp"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("AUTHENTICATED"));
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testUnauthenticated() throws Exception {
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_search", new Header[0]);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Thread.sleep(1500L);
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("FAILED_LOGIN"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("/_search"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("@timestamp"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("AUTHENTICATED"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testJustAuthenticated() throws Exception {
        RestHelper.HttpResponse response = this.rh.executeGetRequest("", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((long)0L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testSgIndexAttempt() throws Exception {
        RestHelper.HttpResponse response = this.rh.executePutRequest("searchguard/_doc/0", "{}", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("MISSING_PRIVILEGES"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("SG_INDEX_ATTEMPT"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("admin"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("@timestamp"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("AUTHENTICATED"));
        Assert.assertEquals((long)2L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testBadHeader() throws Exception {
        RestHelper.HttpResponse response = this.rh.executeGetRequest("", new Header[]{new BasicHeader("_sg_bad", "bad"), BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        Assert.assertFalse((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("AUTHENTICATED"));
        Assert.assertTrue((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("BAD_HEADERS"));
        Assert.assertTrue((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("_sg_bad"));
        Assert.assertEquals((String)TestAuditlogImpl.sb.toString(), (long)1L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testMissingPriv() throws Exception {
        RestHelper.HttpResponse response = this.rh.executeGetRequest("sf/_search", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"worf", (String)"worf")});
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("MISSING_PRIVILEGES"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("indices:data/read/search"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("worf"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("\"sf\""));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("@timestamp"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("AUTHENTICATED"));
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testMsearch() throws Exception {
        String msearch = "{\"index\":\"sf\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":0,\"query\":{\"match_all\":{}}}" + System.lineSeparator() + "{\"index\":\"sf\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":0,\"query\":{\"match_all\":{}}}" + System.lineSeparator();
        RestHelper.HttpResponse response = this.rh.executePostRequest("_msearch?pretty", msearch, new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((String)response.getStatusReason(), (long)200L, (long)response.getStatusCode());
        Assert.assertTrue((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("indices:data/read/msearch"));
        Assert.assertTrue((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("indices:data/read/search"));
        Assert.assertTrue((String)TestAuditlogImpl.sb.toString(), (boolean)TestAuditlogImpl.sb.toString().contains("match_all"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("audit_trace_task_id"));
        Assert.assertEquals((String)TestAuditlogImpl.sb.toString(), (long)4L, (long)TestAuditlogImpl.messages.size());
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().toLowerCase().contains("authorization"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testBulkAuth() throws Exception {
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"worf\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"update\" : {\"_id\" : \"1\", \"_index\" : \"test\"} }" + System.lineSeparator() + "{ \"doc\" : {\"field\" : \"valuex\"} }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"create\" : { \"_index\" : \"test\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value3x\" }" + System.lineSeparator();
        RestHelper.HttpResponse response = this.rh.executePostRequest("_bulk", bulkBody, new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().contains("\"errors\":false"));
        Assert.assertTrue((boolean)response.getBody().contains("\"status\":201"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("indices:admin/auto_create"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("indices:data/write/bulk"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("IndexRequest"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("audit_trace_task_parent_id"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("audit_trace_task_id"));
        Assert.assertTrue((TestAuditlogImpl.messages.size() >= 17 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testBulkNonAuth() throws Exception {
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"worf\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"update\" : {\"_id\" : \"1\", \"_index\" : \"test\"} }" + System.lineSeparator() + "{ \"doc\" : {\"field\" : \"valuex\"} }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"create\" : { \"_index\" : \"test\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value3x\" }" + System.lineSeparator();
        RestHelper.HttpResponse response = this.rh.executePostRequest("_bulk", bulkBody, new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"worf", (String)"worf")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().contains("\"errors\":true"));
        Assert.assertTrue((boolean)response.getBody().contains("\"status\":200"));
        Assert.assertTrue((boolean)response.getBody().contains("\"status\":403"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("MISSING_PRIVILEGES"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("indices:data/write/bulk[s]"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("IndexRequest"));
        Assert.assertTrue((TestAuditlogImpl.messages.size() >= 7 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    public void testUpdateSettings() throws Exception {
        String json = "{\"persistent\" : {\"indices.recovery.max_bytes_per_sec\" : \"50mb\"},\"transient\" : {\"indices.recovery.max_bytes_per_sec\" : \"50mb\"}}";
        RestHelper.HttpResponse response = this.rh.executePutRequest("_cluster/settings", json, new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("AUTHENTICATED"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("cluster:admin/settings/update"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("indices.recovery.max_bytes_per_sec"));
        Assert.assertTrue((TestAuditlogImpl.messages.size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testIndexPattern() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", "internal_elasticsearch").put("searchguard.audit.log_request_body", false).put("searchguard.audit.resolve_indices", false).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 10).put("searchguard.audit.config.index", "'auditlog-'YYYY.MM.dd.ss").build();
        this.setup(additionalSettings);
        this.setupStarfleetIndex();
        boolean sendHTTPClientCertificate = this.rh.sendHTTPClientCertificate;
        String keystore = this.rh.keystore;
        this.rh.sendHTTPClientCertificate = true;
        this.rh.keystore = "auditlog/kirk-keystore.jks";
        RestHelper.HttpResponse res = this.rh.executeGetRequest("_cat/indices", new Header[0]);
        this.rh.sendHTTPClientCertificate = sendHTTPClientCertificate;
        this.rh.keystore = keystore;
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("auditlog-20"));
    }

    @Test
    public void testAliases() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        Client tc = this.getNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_academy").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_library").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("klingonempire").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("spock").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("kirk").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("role01_role02").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse response = this.rh.executeGetRequest("sf/_search?pretty&ignore_unavailable=true", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("starfleet_academy"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("starfleet_library"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("starfleet"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("sf"));
        Assert.assertEquals((long)2L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testScroll() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        Client tc = this.getNodeClient();
        for (int i = 0; i < 3; ++i) {
            tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse res = this.rh.executeGetRequest("vulcangov/_search?scroll=1m&pretty=true", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        int start = res.getBody().indexOf("_scroll_id") + 15;
        String scrollid = res.getBody().substring(start, res.getBody().indexOf("\"", start + 1));
        res = this.rh.executePostRequest("/_search/scroll?pretty=true", "{\"scroll_id\" : \"" + scrollid + "\"}", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertEquals((long)4L, (long)TestAuditlogImpl.messages.size());
        res = this.rh.executeGetRequest("vulcangov/_search?scroll=1m&pretty=true", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        start = res.getBody().indexOf("_scroll_id") + 15;
        scrollid = res.getBody().substring(start, res.getBody().indexOf("\"", start + 1));
        TestAuditlogImpl.clear();
        res = this.rh.executePostRequest("/_search/scroll?pretty=true", "{\"scroll_id\" : \"" + scrollid + "\"}", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin2", (String)"admin")});
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("InternalScrollSearchRequest"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("MISSING_PRIVILEGES"));
        Assert.assertTrue((TestAuditlogImpl.messages.size() > 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testAliasResolution() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", false).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        Client tc = this.getNodeClient();
        for (int i = 0; i < 3; ++i) {
            tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().alias("thealias").index("vulcangov"))).actionGet();
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse response = this.rh.executeGetRequest("thealias/_search?pretty&ignore_unavailable=true", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("thealias"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("audit_trace_resolved_indices"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("vulcangov"));
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
        TestAuditlogImpl.clear();
    }

    @Test
    public void testAliasBadHeaders() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_search?pretty", new Header[]{new BasicHeader("_sg_user", "xxx"), BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("YWRtaW46YWRtaW4"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("BAD_HEADERS"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("xxx"));
        Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
        TestAuditlogImpl.clear();
    }

    @Test
    public void testIndexCloseDelete() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        Client tc = this.getNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("index1")).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("index2")).actionGet();
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse response = this.rh.executeDeleteRequest("index1?pretty", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executePostRequest("index2/_close?pretty", "", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("indices:admin/close"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("indices:admin/delete"));
        Assert.assertTrue((String)TestAuditlogImpl.sb.toString(), (TestAuditlogImpl.messages.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testDeleteByQuery() throws Exception {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.config.disabled_transport_categories", "NONE").build();
        this.setup(settings);
        Client tc = this.getNodeClient();
        for (int i = 0; i < 3; ++i) {
            tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse res = this.rh.executePostRequest("/vulcango*/_delete_by_query?refresh=true&wait_for_completion=true&pretty=true", "{\"query\" : {\"match_all\" : {}}}", new Header[]{BasicAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*\"deleted\" : 3,*");
        String auditlogContents = TestAuditlogImpl.sb.toString();
        Assert.assertTrue((boolean)auditlogContents.contains("indices:data/write/delete/byquery"));
        Assert.assertTrue((boolean)auditlogContents.contains("indices:data/write/bulk"));
        Assert.assertTrue((boolean)auditlogContents.contains("indices:data/read/search"));
    }
}

