/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.routing;

import com.floragunn.searchguard.enterprise.auditlog.AbstractAuditlogiUnitTest;
import com.floragunn.searchguard.enterprise.auditlog.helper.LoggingSink;
import com.floragunn.searchguard.enterprise.auditlog.helper.MockAuditMessageFactory;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.routing.AuditMessageRouter;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.DebugSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.ExternalESSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.InternalESSink;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchsupport.util.EsLogging;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class RouterTest
extends AbstractAuditlogiUnitTest {
    @ClassRule
    public static EsLogging esLogging = new EsLogging();

    @Test
    public void testValidConfiguration() throws Exception {
        Settings settings = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/routing/configuration_valid.yml")).build();
        AuditMessageRouter router = this.createMessageRouterComplianceEnabled(settings);
        Assert.assertEquals((Object)"default", (Object)router.defaultSink.getName());
        Assert.assertEquals(ExternalESSink.class, router.defaultSink.getClass());
        List sinks = (List)router.categorySinks.get(AuditMessage.Category.MISSING_PRIVILEGES);
        Assert.assertNotNull((Object)sinks);
        Assert.assertEquals((long)3L, (long)sinks.size());
        Assert.assertEquals((Object)"endpoint1", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(InternalESSink.class, ((AuditLogSink)sinks.get(0)).getClass());
        Assert.assertEquals((Object)"endpoint2", (Object)((AuditLogSink)sinks.get(1)).getName());
        Assert.assertEquals(ExternalESSink.class, ((AuditLogSink)sinks.get(1)).getClass());
        Assert.assertEquals((Object)"default", (Object)((AuditLogSink)sinks.get(2)).getName());
        Assert.assertEquals(ExternalESSink.class, ((AuditLogSink)sinks.get(2)).getClass());
        sinks = (List)router.categorySinks.get(AuditMessage.Category.COMPLIANCE_DOC_READ);
        Assert.assertEquals((long)1L, (long)sinks.size());
        Assert.assertEquals((Object)"endpoint3", (Object)((AuditLogSink)sinks.get(0)).getName());
        Assert.assertEquals(DebugSink.class, ((AuditLogSink)sinks.get(0)).getClass());
    }

    @Test
    public void testMessageRouting() throws Exception {
        Settings.Builder settingsBuilder = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/routing/routing.yml"));
        Settings settings = settingsBuilder.put("path.home", ".").put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        AuditMessageRouter router = this.createMessageRouterComplianceEnabled(settings);
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.MISSING_PRIVILEGES);
        router.route(msg);
        this.testMessageDeliveredForCategory(router, msg, AuditMessage.Category.MISSING_PRIVILEGES, "endpoint1", "endpoint2", "default");
        router = this.createMessageRouterComplianceEnabled(settings);
        msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.COMPLIANCE_DOC_READ);
        router.route(msg);
        this.testMessageDeliveredForCategory(router, msg, AuditMessage.Category.COMPLIANCE_DOC_READ, "endpoint3");
        router = this.createMessageRouterComplianceEnabled(settings);
        msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.COMPLIANCE_DOC_WRITE);
        router.route(msg);
        this.testMessageDeliveredForCategory(router, msg, AuditMessage.Category.COMPLIANCE_DOC_WRITE, "default");
        router = this.createMessageRouterComplianceEnabled(settings);
        msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.FAILED_LOGIN);
        router.route(msg);
        this.testMessageDeliveredForCategory(router, msg, AuditMessage.Category.FAILED_LOGIN, "default");
        router = this.createMessageRouterComplianceEnabled(settings);
        msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.GRANTED_PRIVILEGES);
        router.route(msg);
        this.testMessageDeliveredForCategory(router, msg, AuditMessage.Category.GRANTED_PRIVILEGES, "default");
    }

    private void testMessageDeliveredForCategory(AuditMessageRouter router, AuditMessage msg, AuditMessage.Category categoryToCheck, String ... sinkNames) {
        Map sinksForCategory = router.categorySinks;
        for (AuditMessage.Category category : AuditMessage.Category.values()) {
            LoggingSink logSink;
            List sinks;
            if (category.equals((Object)categoryToCheck)) {
                sinks = (List)sinksForCategory.get(category);
                for (AuditLogSink sink : sinks) {
                    logSink = (LoggingSink)sink;
                    Assert.assertEquals((long)1L, (long)logSink.messages.size());
                    Assert.assertEquals((Object)msg, (Object)logSink.messages.get(0));
                    Assert.assertTrue((logSink.sb.length() > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)Arrays.stream(sinkNames).anyMatch(sink.getName()::equals));
                }
                continue;
            }
            sinks = (List)sinksForCategory.get(category);
            for (AuditLogSink sink : sinks) {
                if (sink.getName().equals("default")) continue;
                logSink = (LoggingSink)sink;
                Assert.assertEquals((long)0L, (long)logSink.messages.size());
                Assert.assertTrue((logSink.sb.length() == 0 ? 1 : 0) != 0);
            }
        }
    }
}

