/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.routing;

import com.floragunn.searchguard.enterprise.auditlog.AbstractAuditlogiUnitTest;
import com.floragunn.searchguard.enterprise.auditlog.helper.FailingSink;
import com.floragunn.searchguard.enterprise.auditlog.helper.LoggingSink;
import com.floragunn.searchguard.enterprise.auditlog.helper.MockAuditMessageFactory;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.routing.AuditMessageRouter;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchsupport.util.EsLogging;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class FallbackTest
extends AbstractAuditlogiUnitTest {
    @ClassRule
    public static EsLogging esLogging = new EsLogging();

    @Test
    public void testFallback() throws Exception {
        Settings.Builder settingsBuilder = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/routing/fallback.yml"));
        Settings settings = settingsBuilder.put("path.home", ".").put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        AuditMessageRouter router = this.createMessageRouterComplianceEnabled(settings);
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.MISSING_PRIVILEGES);
        router.route(msg);
        List sinks = (List)router.categorySinks.get(AuditMessage.Category.MISSING_PRIVILEGES);
        Assert.assertEquals((long)3L, (long)sinks.size());
        AuditLogSink sink = (AuditLogSink)sinks.get(0);
        Assert.assertEquals((Object)"endpoint1", (Object)sink.getName());
        Assert.assertEquals(FailingSink.class, sink.getClass());
        sink = sink.getFallbackSink();
        Assert.assertEquals((Object)"fallback", (Object)sink.getName());
        Assert.assertEquals(LoggingSink.class, sink.getClass());
        LoggingSink loggingSkin = (LoggingSink)sink;
        Assert.assertEquals((Object)msg, (Object)loggingSkin.messages.get(0));
        sink = (AuditLogSink)sinks.get(1);
        Assert.assertEquals((Object)"endpoint2", (Object)sink.getName());
        Assert.assertEquals(LoggingSink.class, sink.getClass());
        loggingSkin = (LoggingSink)sink;
        Assert.assertEquals((Object)msg, (Object)loggingSkin.messages.get(0));
        sink = (AuditLogSink)sinks.get(2);
        Assert.assertEquals((Object)"default", (Object)sink.getName());
        Assert.assertEquals(LoggingSink.class, sink.getClass());
        loggingSkin = (LoggingSink)sink;
        Assert.assertEquals((Object)msg, (Object)loggingSkin.messages.get(0));
        router = this.createMessageRouterComplianceEnabled(settings);
        msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.COMPLIANCE_DOC_READ);
        router.route(msg);
        sinks = (List)router.categorySinks.get(AuditMessage.Category.COMPLIANCE_DOC_READ);
        sink = (AuditLogSink)sinks.get(0);
        Assert.assertEquals((Object)"endpoint3", (Object)sink.getName());
        Assert.assertEquals(FailingSink.class, sink.getClass());
        sink = sink.getFallbackSink();
        Assert.assertEquals((Object)"fallback", (Object)sink.getName());
        Assert.assertEquals(LoggingSink.class, sink.getClass());
        loggingSkin = (LoggingSink)sink;
        Assert.assertEquals((Object)msg, (Object)loggingSkin.messages.get(0));
        router = this.createMessageRouterComplianceEnabled(settings);
        msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.COMPLIANCE_DOC_WRITE);
        router.route(msg);
        sinks = (List)router.categorySinks.get(AuditMessage.Category.COMPLIANCE_DOC_WRITE);
        sink = (AuditLogSink)sinks.get(0);
        Assert.assertEquals((Object)"default", (Object)sink.getName());
        Assert.assertEquals(LoggingSink.class, sink.getClass());
        loggingSkin = (LoggingSink)sink;
        Assert.assertEquals((long)1L, (long)loggingSkin.messages.size());
        Assert.assertEquals((Object)msg, (Object)loggingSkin.messages.get(0));
        sink = sink.getFallbackSink();
        Assert.assertEquals((Object)"fallback", (Object)sink.getName());
        Assert.assertEquals(LoggingSink.class, sink.getClass());
        loggingSkin = (LoggingSink)sink;
        Assert.assertEquals((long)0L, (long)loggingSkin.messages.size());
        router = this.createMessageRouterComplianceEnabled(settings);
        msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.FAILED_LOGIN);
        router.route(msg);
        sinks = (List)router.categorySinks.get(AuditMessage.Category.FAILED_LOGIN);
        sink = (AuditLogSink)sinks.get(0);
        Assert.assertEquals((Object)"default", (Object)sink.getName());
        Assert.assertEquals(LoggingSink.class, sink.getClass());
        loggingSkin = (LoggingSink)sink;
        Assert.assertEquals((long)1L, (long)loggingSkin.messages.size());
        Assert.assertEquals((Object)msg, (Object)loggingSkin.messages.get(0));
        this.assertLoggingSinksEmpty(router, AuditMessage.Category.FAILED_LOGIN);
    }

    private void assertLoggingSinksEmpty(AuditMessageRouter router, AuditMessage.Category exclude) {
        List allSinks = router.categorySinks.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        allSinks = allSinks.stream().filter(sink -> sink instanceof LoggingSink).collect(Collectors.toList());
        allSinks.removeAll(Collections.singleton(router.defaultSink));
        allSinks.removeAll((Collection)router.categorySinks.get(exclude));
        for (AuditLogSink sink2 : allSinks) {
            LoggingSink loggingSink = (LoggingSink)sink2;
            Assert.assertEquals((long)0L, (long)loggingSink.messages.size());
        }
    }
}

