/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.helper;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class MockRestRequest
extends RestRequest {
    public MockRestRequest() {
        super(XContentParserConfiguration.EMPTY, Collections.emptyMap(), "", Collections.emptyMap(), new HttpRequest(){

            public RestRequest.Method method() {
                return RestRequest.Method.GET;
            }

            public String uri() {
                return "";
            }

            public Map<String, List<String>> getHeaders() {
                return Collections.emptyMap();
            }

            public HttpBody body() {
                return HttpBody.empty();
            }

            public void setBody(HttpBody body) {
            }

            public List<String> strictCookies() {
                return Collections.emptyList();
            }

            public HttpRequest.HttpVersion protocolVersion() {
                return HttpRequest.HttpVersion.HTTP_1_0;
            }

            public HttpRequest removeHeader(String header) {
                return this;
            }

            public boolean hasContent() {
                return false;
            }

            public HttpResponse createResponse(RestStatus status, BytesReference content) {
                return null;
            }

            public HttpResponse createResponse(RestStatus status, ChunkedRestResponseBodyPart content) {
                return null;
            }

            public Exception getInboundException() {
                return null;
            }

            public void release() {
            }
        }, null);
    }

    public MockRestRequest(final String uri, final String jsonBody) {
        super(XContentParserConfiguration.EMPTY, Collections.emptyMap(), uri, Collections.emptyMap(), new HttpRequest(){
            final HttpBody body;
            {
                this.body = HttpBody.fromBytesReference((BytesReference)BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(jsonBody.getBytes())));
            }

            public RestRequest.Method method() {
                return RestRequest.Method.GET;
            }

            public String uri() {
                return uri;
            }

            public Map<String, List<String>> getHeaders() {
                return Map.of("Content-Type", List.of("application/json"));
            }

            public HttpBody body() {
                return this.body;
            }

            public void setBody(HttpBody body) {
            }

            public List<String> strictCookies() {
                return List.of();
            }

            public HttpRequest.HttpVersion protocolVersion() {
                return null;
            }

            public HttpRequest removeHeader(String header) {
                return null;
            }

            public boolean hasContent() {
                return !this.body.isEmpty();
            }

            public HttpResponse createResponse(RestStatus status, BytesReference content) {
                return null;
            }

            public HttpResponse createResponse(RestStatus status, ChunkedRestResponseBodyPart firstBodyPart) {
                return null;
            }

            public Exception getInboundException() {
                return null;
            }

            public void release() {
            }
        }, null);
    }
}

