/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.rest.RestRequest;

class AuditRestRequestBodyReader {
    private static final Logger log = LogManager.getLogger(AuditRestRequestBodyReader.class);

    AuditRestRequestBodyReader() {
    }

    static void readRequestBody(RestRequest request, Consumer<BytesReference> bodyConsumer) {
        if (request.isFullContent()) {
            bodyConsumer.accept((BytesReference)request.requiredContent());
        } else if (request.isStreamedContent()) {
            StreamBodyHandler streamBodyHandler = new StreamBodyHandler(bodyConsumer);
            request.contentStream().addTracingHandler((HttpBody.ChunkHandler)streamBodyHandler);
        } else {
            log.error("Unknown request content type");
            assert (false) : "Unknown request content type, it's neither full nor stream.";
        }
    }

    static class StreamBodyHandler
    implements HttpBody.ChunkHandler {
        private final Consumer<BytesReference> aggregatedBodyConsumer;
        private ArrayList<ReleasableBytesReference> chunks;

        private StreamBodyHandler(Consumer<BytesReference> aggregatedBodyConsumer) {
            this.aggregatedBodyConsumer = aggregatedBodyConsumer;
        }

        public void onNext(ReleasableBytesReference chunk, boolean isLast) {
            if (isLast) {
                if (this.chunks == null) {
                    this.aggregatedBodyConsumer.accept((BytesReference)chunk);
                } else {
                    this.chunks.add(chunk);
                    BytesReference compositeBytes = CompositeBytesReference.of((BytesReference[])((BytesReference[])this.chunks.toArray(new ReleasableBytesReference[0])));
                    this.aggregatedBodyConsumer.accept(compositeBytes);
                }
            } else {
                if (this.chunks == null) {
                    this.chunks = new ArrayList();
                }
                this.chunks.add(chunk);
            }
        }
    }
}

