/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.integration;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.integration.TestAuditlogImpl;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.BearerAuthorization;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.AsyncAssert;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class AuditlogIntegrationTest {
    static final TestSgConfig.User AUDIT_IGNORED_USER = new TestSgConfig.User("audit_ignored_user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User USER = new TestSgConfig.User("user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).aliasPermissions(new String[]{"*"}).on(new String[]{"*"}).clusterPermissions(new String[]{"*"})});
    static TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().users(new TestSgConfig.User[]{AUDIT_IGNORED_USER, USER}).authc(AUTHC).sslEnabled().enterpriseModulesEnabled().nodeSettings(new Object[]{"action.destructive_requires_name", false, "searchguard.audit.type", TestAuditlogImpl.class.getName(), "searchguard.audit.enable_transport", true, "searchguard.audit.enable_rest", true, "searchguard.audit.config.disabled_rest_categories", Collections.emptyList(), "searchguard.audit.threadpool.size", 0, "searchguard.audit.ignore_users", Collections.singletonList(AUDIT_IGNORED_USER.getName())}).embedded().build();

    @Test
    public void testAuditLog_failedLogin() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[]{cluster.getBasicAuthHeader(USER.getName(), USER.getPassword() + "1")});){
            TestAuditlogImpl.clear();
            String searchQuery = "{\n  \"query\": {\n    \"match\": {\n      \"message\": \"error\"\n    }\n  }\n}\n";
            GenericRestClient.HttpResponse response = client.postJson("/index/_search", searchQuery, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isUnauthorized());
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.FAILED_LOGIN).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.FAILED_LOGIN).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_body"), (Matcher)Matchers.nullValue());
        }
    }

    @Test
    public void testAuditLog_succeededLogin() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[]{cluster.getBasicAuthHeader(USER.getName(), USER.getPassword())});){
            TestAuditlogImpl.clear();
            String searchQuery = "{\n  \"query\": {\n    \"match\": {\n      \"message\": \"error\"\n    }\n  }\n}\n";
            GenericRestClient.HttpResponse response = client.postJson("/index/_search", searchQuery, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isNotFound());
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.AUTHENTICATED).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.AUTHENTICATED).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_body"), (Matcher)Matchers.equalTo((Object)searchQuery));
        }
    }

    @Test
    public void testAuditLog_succeededLogin_bigRequestBody() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            TestAuditlogImpl.clear();
            StringBuilder bodyBuilder = new StringBuilder();
            int numberOfDocs = 10000;
            for (int i = 0; i < numberOfDocs; ++i) {
                bodyBuilder.append("{ \"index\": { \"_id\": %d } }\n{ \"title\": \"Doc %d\", \"content\": \"Hello world\" }\n".formatted(i, i));
            }
            GenericRestClient.HttpResponse response = client.postJson("test_big_bulk/_bulk", bodyBuilder.toString(), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.AUTHENTICATED).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.AUTHENTICATED).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_body"), (Matcher)Matchers.equalTo((Object)bodyBuilder.toString()));
            response = client.post("test_big_bulk/_refresh");
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            response = client.get("test_big_bulk/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.hits.total.value", (Object)numberOfDocs));
        }
    }

    @Test
    public void testAuditLog_succeededLogin_invalidJsonBody() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            TestAuditlogImpl.clear();
            String searchQuery = "{{\n  \"query\": {\n    \"match\": {\n      \"message\": \"error\"\n    }\n  }\n}\n";
            GenericRestClient.HttpResponse response = client.postJson("/index/_search", searchQuery, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isBadRequest());
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.AUTHENTICATED).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.AUTHENTICATED).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_body"), (Matcher)Matchers.equalTo((Object)searchQuery));
        }
    }

    @Test
    public void testAuditLog_kibanaLogin() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(new Header[0]);){
            TestAuditlogImpl.clear();
            DocNode requestBody = DocNode.of((String)"user", (Object)USER.getName(), (String)"password", (Object)USER.getPassword());
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/auth/session", (Map)requestBody, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.KIBANA_LOGIN).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.KIBANA_LOGIN).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.KIBANA_LOGIN.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)requestBody.getAsString("user")));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_effective_user_auth_domain"), (Matcher)Matchers.equalTo((Object)"basic/internal_users_db"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            TestAuditlogImpl.clear();
            response = restClient.postJson("/_searchguard/auth/session/with_header", (Map)DocNode.EMPTY, new Header[]{cluster.getBasicAuthHeader(USER.getName(), USER.getPassword())});
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.KIBANA_LOGIN).size() == 1, (Duration)Duration.ofSeconds(2L));
            auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.KIBANA_LOGIN).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.KIBANA_LOGIN.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)requestBody.getAsString("user")));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_effective_user_auth_domain"), (Matcher)Matchers.equalTo((Object)"basic/internal_users_db"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_host_name"), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testAuditLog_kibanaLogout() throws Exception {
        String token;
        GenericRestClient.HttpResponse response;
        try (GenericRestClient restClient = cluster.getRestClient(new Header[0]);){
            response = restClient.postJson("/_searchguard/auth/session/with_header", (Map)DocNode.EMPTY, new Header[]{cluster.getBasicAuthHeader(USER.getName(), USER.getPassword())});
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            token = response.getBodyAsDocNode().getAsString("token");
            Assert.assertNotNull((String)response.getBody(), (Object)token);
        }
        restClient = cluster.getRestClient(new Header[]{new BearerAuthorization(token)});
        try {
            TestAuditlogImpl.clear();
            response = restClient.delete("/_searchguard/auth/session", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.KIBANA_LOGOUT).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.KIBANA_LOGOUT).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.KIBANA_LOGOUT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_request_effective_user_auth_domain"), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_node_host_name"), (Matcher)Matchers.notNullValue());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void testAuditLog_composableIndexTemplateWriteHistory() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            TestAuditlogImpl.clear();
            String templateName = "test-composable-template";
            DocNode template = DocNode.of((String)"index_patterns", Collections.singletonList("test-composable"));
            GenericRestClient.HttpResponse response = restClient.putJson("/_index_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_TEMPLATE_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.CREATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_index_templates"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_index_templates").get(0)), (Matcher)Matchers.equalTo((Object)templateName));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            TestAuditlogImpl.clear();
            template = template.with("index_patterns", Collections.singletonList("composable-new-pattern"));
            response = restClient.putJson("/_index_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_TEMPLATE_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.UPDATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_index_templates"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_index_templates").get(0)), (Matcher)Matchers.equalTo((Object)templateName));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            TestAuditlogImpl.clear();
            response = restClient.delete("/_index_template/" + templateName, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_TEMPLATE_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.DELETE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_index_templates"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_index_templates").get(0)), (Matcher)Matchers.equalTo((Object)templateName));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testAuditLog_legacyIndexTemplateWriteHistory() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            TestAuditlogImpl.clear();
            String templateName = "test-legacy-template";
            DocNode template = DocNode.of((String)"index_patterns", Collections.singletonList("test-legacy"));
            GenericRestClient.HttpResponse response = restClient.putJson("/_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_TEMPLATE_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.CREATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_index_templates"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_index_templates").get(0)), (Matcher)Matchers.equalTo((Object)templateName));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            TestAuditlogImpl.clear();
            template = template.with("index_patterns", Collections.singletonList("legacy-new-pattern"));
            response = restClient.putJson("/_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_TEMPLATE_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.UPDATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_index_templates"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_index_templates").get(0)), (Matcher)Matchers.equalTo((Object)templateName));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            TestAuditlogImpl.clear();
            response = restClient.delete("/_template/" + templateName, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_TEMPLATE_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.DELETE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_index_templates"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_index_templates").get(0)), (Matcher)Matchers.equalTo((Object)templateName));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testAuditLog_composableIndexTemplateWriteHistory_noLogWhenActionFails() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            TestAuditlogImpl.clear();
            String templateName = "test-composable-template";
            DocNode template = DocNode.of((String)"index_patterns", Collections.singletonList("test-composable"), (String)"template", (Object)DocNode.of((String)"settings", (Object)DocNode.of((String)"number_of_shards", (Object)0)));
            GenericRestClient.HttpResponse response = restClient.putJson("/_index_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            response = restClient.delete("/_index_template/1" + templateName, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testAuditLog_legacyIndexTemplateWriteHistory_noLogWhenActionFails() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            TestAuditlogImpl.clear();
            String templateName = "test-legacy-template";
            DocNode template = DocNode.of((String)"index_patterns", Collections.singletonList("test-legacy"), (String)"settings", (Object)DocNode.of((String)"number_of_shards", (Object)0));
            GenericRestClient.HttpResponse response = restClient.putJson("/_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            response = restClient.delete("/_template/1" + templateName, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testAuditLog_composableIndexTemplateWriteHistory_noLogWhenUserIsIgnored() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)AUDIT_IGNORED_USER, new Header[0]).trackResources();){
            TestAuditlogImpl.clear();
            String templateName = "test-composable-template";
            DocNode template = DocNode.of((String)"index_patterns", Collections.singletonList("test-composable"));
            GenericRestClient.HttpResponse response = restClient.putJson("/_index_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = restClient.putJson("/_index_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = restClient.delete("/_index_template/" + templateName, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testAuditLog_legacyIndexTemplateWriteHistory_noLogWhenUserIsIgnored() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)AUDIT_IGNORED_USER, new Header[0]).trackResources();){
            TestAuditlogImpl.clear();
            String templateName = "test-legacy-template";
            DocNode template = DocNode.of((String)"index_patterns", Collections.singletonList("test-legacy"));
            GenericRestClient.HttpResponse response = restClient.putJson("/_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = restClient.putJson("/_template/" + templateName, (Document)template);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = restClient.delete("/_template/" + templateName, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_TEMPLATE_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testAuditLog_indexWriteHistory_createOperation_simpleIndexName() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            TestAuditlogImpl.clear();
            String indexPrefix = "test-index-simple-name";
            String indexName = indexPrefix + "-1";
            DocNode settings = DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_shards", (Object)3, (String)"number_of_replicas", (Object)2));
            DocNode aliases = DocNode.of((String)"alias1", (Object)DocNode.EMPTY, (String)"alias2", (Object)DocNode.of((String)"filter", (Object)DocNode.of((String)"term", (Object)DocNode.of((String)"doc", (Object)"1")), (String)"index_routing", (Object)"shard1"));
            DocNode mappings = DocNode.of((String)"properties", (Object)DocNode.of((String)"field1", (Object)DocNode.of((String)"type", (Object)"text")));
            DocNode reqBody = DocNode.of((String)"settings", (Object)settings, (String)"aliases", (Object)aliases, (String)"mappings", (Object)mappings);
            GenericRestClient.HttpResponse response = restClient.putJson("/" + indexName, (Document)reqBody);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.CREATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_indices"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_indices").get(0)), (Matcher)Matchers.equalTo((Object)indexName));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_trace_resolved_indices"), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            DocNode msgReqBodyField = DocNode.parse((Format)Format.JSON).from(auditMessage.getAsString("audit_request_body"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"index"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"settings"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"mappings"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"aliases"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"cause"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"origin"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testAuditLog_indexWriteHistory_createOperation_indexNameWithDateMath() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            TestAuditlogImpl.clear();
            String indexPrefix = "test-index-date-math-name";
            DocNode settings = DocNode.of((String)"settings", (Object)DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_shards", (Object)3, (String)"number_of_replicas", (Object)2)));
            String indexNameWithDateMath = "<" + indexPrefix + "{now{yyyy|UTC}}>";
            GenericRestClient.HttpResponse response = restClient.putJson("/" + URLEncoder.encode(indexNameWithDateMath, StandardCharsets.UTF_8.toString()), (Document)settings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsString("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.CREATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_indices"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_indices").get(0)), (Matcher)Matchers.equalTo((Object)indexNameWithDateMath));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_trace_resolved_indices"), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            DocNode msgReqBodyField = DocNode.parse((Format)Format.JSON).from(auditMessage.getAsString("audit_request_body"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"index"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"settings"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"mappings"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"aliases"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"cause"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"origin"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testAuditLog_indexWriteHistory_createOperation_noLogWhenUserIsIgnored() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)AUDIT_IGNORED_USER, new Header[0]).trackResources();){
            TestAuditlogImpl.clear();
            String indexName = "test-created-by-ignored-user";
            GenericRestClient.HttpResponse response = restClient.put("/" + indexName);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testAuditLog_indexWriteHistory_deleteOperation() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            String indexPrefix = "test-index-delete";
            String indexName = indexPrefix + "-1";
            String indexNameWithDateMath = "<" + indexPrefix + "{now{yyyy|UTC}}>";
            for (String index : Arrays.asList(indexName, indexNameWithDateMath)) {
                GenericRestClient.HttpResponse response = restClient.put("/" + URLEncoder.encode(index, StandardCharsets.UTF_8.toString()));
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            }
            TestAuditlogImpl.clear();
            String indexToRemove = indexPrefix + "*";
            GenericRestClient.HttpResponse response = restClient.delete("/" + indexToRemove, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.DELETE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_indices"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_indices").get(0)), (Matcher)Matchers.equalTo((Object)indexToRemove));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_trace_resolved_indices"), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testAuditLog_indexWriteHistory_deleteOperation_noLogWhenUserIsIgnored() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)AUDIT_IGNORED_USER, new Header[0]).trackResources();){
            String indexName = "test-deleted-by-ignored-user";
            GenericRestClient.HttpResponse response = restClient.put("/" + indexName);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            TestAuditlogImpl.clear();
            response = restClient.delete("/" + indexName, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testAuditLog_indexSettingsWriteHistory() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            String indexNamePrefix = "test-index-settings-update";
            String firstIndexName = indexNamePrefix + "-1";
            String secondIndexName = indexNamePrefix + "-2";
            String anotherIndex = "another-test-index-settings-update";
            int initialNumberOfReplicas = 2;
            DocNode settings = DocNode.of((String)"settings", (Object)DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_shards", (Object)2, (String)"number_of_replicas", (Object)initialNumberOfReplicas)));
            for (String name : Arrays.asList(firstIndexName, secondIndexName, anotherIndex)) {
                GenericRestClient.HttpResponse response = restClient.putJson("/" + name, (Document)settings);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            }
            TestAuditlogImpl.clear();
            settings = DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_replicas", (Object)(initialNumberOfReplicas + 1)));
            String indexNamePrefixWithWildcard = indexNamePrefix + "*";
            GenericRestClient.HttpResponse response = restClient.putJson("/" + indexNamePrefixWithWildcard + "/_settings", (Document)settings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.UPDATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_indices"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_indices").get(0)), (Matcher)Matchers.equalTo((Object)indexNamePrefixWithWildcard));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_trace_resolved_indices"), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            DocNode msgReqBodyField = DocNode.parse((Format)Format.JSON).from(auditMessage.getAsString("audit_request_body"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"indices"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"settings"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"preserve_existing"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"origin"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
            TestAuditlogImpl.clear();
            settings = DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_replicas", (Object)initialNumberOfReplicas));
            response = restClient.putJson("/" + anotherIndex + "/_settings", (Document)settings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.UPDATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_indices"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_indices").get(0)), (Matcher)Matchers.equalTo((Object)anotherIndex));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_trace_resolved_indices"), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            msgReqBodyField = DocNode.parse((Format)Format.JSON).from(auditMessage.getAsString("audit_request_body"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"indices"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"settings"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"preserve_existing"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"origin"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testAuditLog_indexSettingsWriteHistory_noLogWhenUserIsIgnored() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)AUDIT_IGNORED_USER, new Header[0]).trackResources();){
            String indexName = "test-settings-update-by-ignored-user";
            int initialNumberOfReplicas = 2;
            DocNode settings = DocNode.of((String)"settings", (Object)DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_shards", (Object)2, (String)"number_of_replicas", (Object)initialNumberOfReplicas)));
            GenericRestClient.HttpResponse response = restClient.putJson("/" + indexName, (Document)settings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            TestAuditlogImpl.clear();
            settings = DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_replicas", (Object)(initialNumberOfReplicas + 1)));
            response = restClient.putJson("/" + indexName + "/_settings", (Document)settings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testAuditLog_indexSettingsWriteHistory_noLogWhenActionFails() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            String indexName = "test-invalid-settings-update";
            int initialNumberOfReplicas = 2;
            DocNode settings = DocNode.of((String)"settings", (Object)DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_shards", (Object)2, (String)"number_of_replicas", (Object)initialNumberOfReplicas)));
            GenericRestClient.HttpResponse response = restClient.putJson("/" + indexName, (Document)settings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            TestAuditlogImpl.clear();
            settings = DocNode.of((String)"index", (Object)DocNode.of((String)"number_of_shards", (Object)3));
            response = restClient.putJson("/" + indexName + "/_settings", (Document)settings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testAuditLog_indexMappingsWriteHistory() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            String indexNamePrefix = "test-index-mappings-update";
            String firstIndexName = indexNamePrefix + "-1";
            String secondIndexName = indexNamePrefix + "-2";
            String anotherIndex = "another-test-index-mappings-update";
            DocNode mappings = DocNode.of((String)"mappings", (Object)DocNode.of((String)"properties", (Object)DocNode.of((String)"email", (Object)DocNode.of((String)"type", (Object)"keyword"))));
            for (String name : Arrays.asList(firstIndexName, secondIndexName, anotherIndex)) {
                GenericRestClient.HttpResponse response = restClient.putJson("/" + name, (Document)mappings);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            }
            TestAuditlogImpl.clear();
            mappings = DocNode.of((String)"properties", (Object)DocNode.of((String)"name", (Object)DocNode.of((String)"type", (Object)"text")));
            String indexNamePrefixWithWildcard = indexNamePrefix + "*";
            GenericRestClient.HttpResponse response = restClient.putJson("/" + indexNamePrefixWithWildcard + "/_mappings", (Document)mappings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            DocNode auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.UPDATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_indices"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_indices").get(0)), (Matcher)Matchers.equalTo((Object)indexNamePrefixWithWildcard));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_trace_resolved_indices"), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            DocNode msgReqBodyField = DocNode.parse((Format)Format.JSON).from(auditMessage.getAsString("audit_request_body"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"indices"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"source"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"write_index_only"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)msgReqBodyField, (Matcher)Matchers.hasKey((Object)"origin"));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
            TestAuditlogImpl.clear();
            mappings = DocNode.of((String)"properties", (Object)DocNode.of((String)"email", (Object)DocNode.of((String)"type", (Object)"keyword")));
            response = restClient.putJson("/" + anotherIndex + "/_mappings", (Document)mappings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            AsyncAssert.awaitAssert((String)"Messages arrived", () -> this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).size() == 1, (Duration)Duration.ofSeconds(2L));
            auditMessage = DocNode.parse((Format)Format.JSON).from(this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE).get(0).toJson());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_category"), (Matcher)Matchers.equalTo((Object)AuditMessage.Category.INDEX_WRITE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_compliance_operation"), (Matcher)Matchers.equalTo((Object)AuditLog.Operation.UPDATE.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.getAsListOfStrings("audit_trace_indices"), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)((String)auditMessage.getAsListOfStrings("audit_trace_indices").get(0)), (Matcher)Matchers.equalTo((Object)anotherIndex));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_trace_resolved_indices"), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_body"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_cluster_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_origin"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.REST.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_layer"), (Matcher)Matchers.equalTo((Object)AuditLog.Origin.TRANSPORT.name()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_id"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("@timestamp"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_format_version"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_remote_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_address"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user"), (Matcher)Matchers.equalTo((Object)USER.getName()));
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_request_effective_user_auth_domain"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_host_name"), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)auditMessage.toJsonString(), (Object)auditMessage.get("audit_node_elasticsearch_version"), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testAuditLog_indexMappingsWriteHistory_noLogWhenUserIsIgnored() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)AUDIT_IGNORED_USER, new Header[0]).trackResources();){
            String indexName = "test-mappings-update-by-ignored-user";
            DocNode mappings = DocNode.of((String)"mappings", (Object)DocNode.of((String)"properties", (Object)DocNode.of((String)"email", (Object)DocNode.of((String)"type", (Object)"keyword"))));
            GenericRestClient.HttpResponse response = restClient.putJson("/" + indexName, (Document)mappings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            TestAuditlogImpl.clear();
            mappings = DocNode.of((String)"properties", (Object)DocNode.of((String)"name", (Object)DocNode.of((String)"type", (Object)"text")));
            response = restClient.putJson("/" + indexName + "/_mappings", (Document)mappings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testAuditLog_indexMappingsWriteHistory_noLogWhenActionFails() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]).trackResources();){
            String indexName = "test-invalid-mappings-update";
            DocNode mappings = DocNode.of((String)"mappings", (Object)DocNode.of((String)"properties", (Object)DocNode.of((String)"email", (Object)DocNode.of((String)"type", (Object)"keyword"))));
            GenericRestClient.HttpResponse response = restClient.putJson("/" + indexName, (Document)mappings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            TestAuditlogImpl.clear();
            mappings = DocNode.of((String)"properties", (Object)DocNode.of((String)"name", (Object)DocNode.of((String)"type", (Object)"fake")));
            response = restClient.putJson("/" + indexName + "/_mappings", (Document)mappings);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((String)TestAuditlogImpl.sb.toString(), this.getMessagesByCategory(AuditMessage.Category.INDEX_WRITE), (Matcher)Matchers.hasSize((int)0));
        }
    }

    private List<AuditMessage> getMessagesByCategory(AuditMessage.Category category) {
        return TestAuditlogImpl.messages.stream().filter(msg -> msg.getCategory() == category).collect(Collectors.toList());
    }
}

