/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.compliance;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.enterprise.auditlog.AbstractAuditlogiUnitTest;
import com.floragunn.searchguard.enterprise.auditlog.integration.TestAuditlogImpl;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.junit.AsyncAssert;
import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ComplianceAuditlogTest
extends AbstractAuditlogiUnitTest {
    @Test
    public void testSourceFilter() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.read.watched_fields", "emp").put("searchguard.audit.config.disabled_transport_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.config.disabled_rest_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        boolean sendHTTPClientCertificate = this.rh.sendHTTPClientCertificate;
        String keystore = this.rh.keystore;
        this.rh.sendHTTPClientCertificate = true;
        this.rh.keystore = "auditlog/kirk-keystore.jks";
        this.rh.executePutRequest("emp/_doc/0?refresh", "{\"Designation\" : \"CEO\", \"Gender\" : \"female\", \"Salary\" : 100}", new Header[0]);
        this.rh.executePutRequest("emp/_doc/1?refresh", "{\"Designation\" : \"IT\", \"Gender\" : \"male\", \"Salary\" : 200}", new Header[0]);
        this.rh.executePutRequest("emp/_doc/2?refresh", "{\"Designation\" : \"IT\", \"Gender\" : \"female\", \"Salary\" : 300}", new Header[0]);
        this.rh.sendHTTPClientCertificate = sendHTTPClientCertificate;
        this.rh.keystore = keystore;
        String search = "{   \"_source\":[      \"Gender\"   ],   \"from\":0,   \"size\":3,   \"query\":{      \"term\":{         \"Salary\": 300      }   }}";
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse response = this.rh.executePostRequest("_search?pretty", search, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)"Messages arrived", () -> TestAuditlogImpl.messages.size() >= 1, (Duration)Duration.ofSeconds(2L));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_DOC_READ"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("Designation"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("Salary"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("Gender"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testSourceFilterMsearch() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.read.watched_fields", "emp").put("searchguard.audit.config.disabled_transport_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.config.disabled_rest_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        boolean sendHTTPClientCertificate = this.rh.sendHTTPClientCertificate;
        String keystore = this.rh.keystore;
        this.rh.sendHTTPClientCertificate = true;
        this.rh.keystore = "auditlog/kirk-keystore.jks";
        this.rh.executePutRequest("emp/_doc/0?refresh", "{\"Designation\" : \"CEO\", \"Gender\" : \"female\", \"Salary\" : 100}", new Header[0]);
        this.rh.executePutRequest("emp/_doc/1?refresh", "{\"Designation\" : \"IT\", \"Gender\" : \"male\", \"Salary\" : 200}", new Header[0]);
        this.rh.executePutRequest("emp/_doc/2?refresh", "{\"Designation\" : \"IT\", \"Gender\" : \"female\", \"Salary\" : 300}", new Header[0]);
        this.rh.sendHTTPClientCertificate = sendHTTPClientCertificate;
        this.rh.keystore = keystore;
        String search = "{}" + System.lineSeparator() + "{   \"_source\":[      \"Gender\"   ],   \"from\":0,   \"size\":3,   \"query\":{      \"term\":{         \"Salary\": 300      }   }}" + System.lineSeparator() + "{}" + System.lineSeparator() + "{   \"_source\":[      \"Designation\"   ],   \"from\":0,   \"size\":3,   \"query\":{      \"term\":{         \"Salary\": 200      }   }}" + System.lineSeparator();
        TestAuditlogImpl.clear();
        RestHelper.HttpResponse response = this.rh.executePostRequest("_msearch?pretty", search, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        this.assertNotContains(response, "*exception*");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)"Messages arrived", () -> TestAuditlogImpl.messages.size() == 2, (Duration)Duration.ofSeconds(3L));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_DOC_READ"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("Salary"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("Gender"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("Designation"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testExternalConfig() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", false).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", false).put("searchguard.compliance.history.external_config_enabled", true).put("searchguard.compliance.history.external_config.env_vars.enabled", false).put("searchguard.compliance.history.internal_config_enabled", false).put("searchguard.audit.config.disabled_transport_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.config.disabled_rest_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.threadpool.size", 0).build();
        TestAuditlogImpl.clear();
        this.setup(additionalSettings);
        Client tc = this.getPrivilegedInternalNodeClient();
        for (IndexRequest ir : new DynamicSgConfig().setSgRoles("sg_roles_2.yml").getDynamicConfig(this.getResourceFolder())) {
            tc.index(ir).actionGet();
        }
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_search?pretty", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)"Messages arrived", () -> TestAuditlogImpl.messages.size() == 3, (Duration)Duration.ofSeconds(2L));
        Assert.assertEquals((long)3L, (long)TestAuditlogImpl.messages.size());
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("external_configuration"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_EXTERNAL_CONFIG"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("elasticsearch_yml"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testUpdate() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", false).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.internal_config_enabled", false).put("searchguard.compliance.history.write.watched_indices", "finance").put("searchguard.compliance.history.read.watched_fields", "humanresources,Designation,FirstName,LastName").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.prepareIndex("humanresources").setId("100").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).setSource(new Object[]{"Age", 456}).execute().actionGet();
        TestAuditlogImpl.clear();
        String body = "{\"doc\": {\"Age\":123}}";
        RestHelper.HttpResponse response = this.rh.executePostRequest("humanresources/_update/100?pretty", body, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)TestAuditlogImpl.messages.isEmpty());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    @Ignore(value="Purpose of this test not clear")
    public void testUpdatePerf() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", false).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.internal_config_enabled", false).put("searchguard.compliance.history.write.watched_indices", "humanresources").put("searchguard.compliance.history.read.watched_fields", "humanresources,*").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        for (int i = 0; i < 50; ++i) {
            RestHelper.HttpResponse response = this.rh.executePostRequest("humanresources/_doc/" + i, "{\"customer\": {\"Age\":" + i + "}}", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            response = this.rh.executePostRequest("humanresources/_doc/" + i, "{\"customer\": {\"Age\":" + (i + 2) + "}}", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = this.rh.executePostRequest("humanresources/_update/" + i + "?pretty", "{\"doc\": {\"doesel\":" + (i + 3) + "}}", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
        }
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)TestAuditlogImpl.messages.isEmpty());
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testWriteHistory() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", false).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.compliance.history.write.log_diffs", true).put("searchguard.compliance.history.write.watched_indices", "humanresources").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.prepareIndex("humanresources").setId("100").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).setSource(new Object[]{"Age", 456}).execute().actionGet();
        TestAuditlogImpl.clear();
        String body = "{\"doc\": {\"Age\":123}}";
        RestHelper.HttpResponse response = this.rh.executePostRequest("humanresources/_update/100?pretty", body, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)"Messages arrived", () -> TestAuditlogImpl.sb.toString().split(".*audit_compliance_diff_content.*replace.*").length == 2, (Duration)Duration.ofSeconds(2L));
        body = "{\"Age\":555}";
        TestAuditlogImpl.clear();
        response = this.rh.executePostRequest("humanresources/_doc/100?pretty", body, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)"Messages arrived", () -> TestAuditlogImpl.sb.toString().split(".*audit_compliance_diff_content.*replace.*").length == 2, (Duration)Duration.ofSeconds(2L));
    }

    @Test
    public void testReadWriteSource() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", false).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.compliance.history.write.watched_indices", "humanresources").put("searchguard.compliance.history.read.watched_fields", "/(?!\\.).+/").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.prepareIndex("humanresources").setId("100").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).setSource(new Object[]{"Age", 456}).execute().actionGet();
        TestAuditlogImpl.clear();
        String body = "{\"doc\": {\"Age\":123}}";
        RestHelper.HttpResponse response = this.rh.executePostRequest("humanresources/_update/100?pretty", body, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)("Messages arrived: " + TestAuditlogImpl.sb.toString()), () -> TestAuditlogImpl.sb.toString().split("\\\\\"Age\\\\\":123").length == 2, (Duration)Duration.ofSeconds(2L));
        body = "{\"Age\":555}";
        TestAuditlogImpl.clear();
        response = this.rh.executePostRequest("humanresources/_doc/100?pretty", body, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)("Messages arrived: " + TestAuditlogImpl.sb.toString()), () -> TestAuditlogImpl.sb.toString().split("\\\\\"Age\\\\\":555").length == 2, (Duration)Duration.ofSeconds(2L));
        TestAuditlogImpl.clear();
        response = this.rh.executeGetRequest("humanresources/_doc/100?pretty", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)("Messages arrived: " + TestAuditlogImpl.sb.toString()), () -> TestAuditlogImpl.sb.toString().split("\\\\\"Age\\\\\":\\\\\"555\\\\\"").length == 2, (Duration)Duration.ofSeconds(2L));
    }

    @Test
    public void testReadWriteDfm() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", false).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.compliance.history.read.metadata_only", true).put("searchguard.compliance.history.read.watched_fields", "/(?!\\.).+/").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.prepareIndex("humanresources").setId("100").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).setSource(new Object[]{"Designation", "CEO", "Plz", "10977", "FirstName", "Alex", "LastName", "Doe", "Address", "Suitland-Silver Hill, MD", "Status", "active"}).execute().actionGet();
        RestHelper.HttpResponse response = this.rh.executeGetRequest("humanresources/_search?pretty", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"fls_audit", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)("Messages arrived: " + TestAuditlogImpl.sb.toString()), () -> !TestAuditlogImpl.sb.toString().contains("FirstName"), (Duration)Duration.ofSeconds(2L));
        TestAuditlogImpl.clear();
        response = this.rh.executeGetRequest("humanresources/_doc/100?pretty", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"fls_audit", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)("Messages arrived: " + TestAuditlogImpl.sb.toString()), () -> !TestAuditlogImpl.sb.toString().contains("FirstName"), (Duration)Duration.ofSeconds(2L));
    }

    @Test
    public void testReadWriteSourceSgIndex() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", false).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.compliance.history.internal_config_enabled", true).put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        this.initializeSgIndex(this.getNodeClient(), new DynamicSgConfig());
        AsyncAssert.awaitAssert((String)("Messages arrived: " + TestAuditlogImpl.sb.toString()), () -> !TestAuditlogImpl.sb.toString().contains("eyJfc") && TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_READ") && TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_WRITE") && TestAuditlogImpl.sb.toString().contains("sg_all_access") && TestAuditlogImpl.sb.toString().contains("internalusers"), (Duration)Duration.ofSeconds(2L));
    }

    @Test
    public void testReadWriteSourceSgIndexSgctl() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", false).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.compliance.history.internal_config_enabled", true).put("searchguard.allow_default_init_sgindex", false).put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        URL resourceUrl = ((Object)((Object)this)).getClass().getResource("/" + this.getResourceFolder() + "/kirk.key.pem");
        File resourceRoot = new File(resourceUrl.toURI()).getParentFile();
        LinkedHashMap<String, OrderedImmutableMap> configTypeToConfigMap = new LinkedHashMap<String, OrderedImmutableMap>();
        ImmutableMap configsToUpdate = ImmutableMap.of((Object)"sg_internal_users.yml", (Object)"internalusers", (Object)"sg_roles.yml", (Object)"roles");
        for (File file : resourceRoot.listFiles((arg_0, arg_1) -> ComplianceAuditlogTest.lambda$testReadWriteSourceSgIndexSgctl$11((Map)configsToUpdate, arg_0, arg_1))) {
            Format format = Format.getByFileName((String)file.getName(), (Format)Format.YAML);
            DocNode content = DocNode.wrap((Object)DocReader.format((Format)format).fallbackForEmptyDocuments((Object)ImmutableMap.empty()).readObject(file));
            configTypeToConfigMap.put((String)configsToUpdate.get(file.getName()), OrderedImmutableMap.of((Object)"content", (Object)content));
        }
        this.rh.sendHTTPClientCertificate = true;
        this.rh.keystore = this.getResourceFolder() + "/kirk-keystore.jks";
        RestHelper.HttpResponse response = this.rh.executePutRequest("/_searchguard/config", DocWriter.json().writeAsString(configTypeToConfigMap), new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)("Messages arrived: " + TestAuditlogImpl.sb.toString()), () -> !TestAuditlogImpl.sb.toString().contains("eyJfc") && TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_WRITE") && !TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_READ") && TestAuditlogImpl.sb.toString().contains("sg_all_access") && TestAuditlogImpl.sb.toString().contains("\"audit_trace_doc_id\" : \"internalusers\"") && TestAuditlogImpl.sb.toString().contains("UPDATE") && TestAuditlogImpl.sb.toString().contains("internalusers"), (Duration)Duration.ofSeconds(2L));
        Assert.assertEquals((long)2L, (long)TestAuditlogImpl.messages.size());
        TestAuditlogImpl.clear();
        response = this.rh.executeGetRequest("/_searchguard/config", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)("Messages arrived: " + TestAuditlogImpl.sb.toString()), () -> !TestAuditlogImpl.sb.toString().contains("eyJfc") && !TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_WRITE") && TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_READ") && TestAuditlogImpl.sb.toString().contains("sg_all_access") && TestAuditlogImpl.sb.toString().contains("actiongroups") && TestAuditlogImpl.sb.toString().contains("hash") && TestAuditlogImpl.sb.toString().contains("tenants") && TestAuditlogImpl.sb.toString().contains("internalusers"), (Duration)Duration.ofSeconds(5L));
        Assert.assertEquals((long)8L, (long)TestAuditlogImpl.messages.size());
        TestAuditlogImpl.clear();
        response = this.rh.executeGetRequest("/_searchguard/config", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AsyncAssert.awaitAssert((String)("Messages arrived: " + TestAuditlogImpl.sb.toString()), () -> !TestAuditlogImpl.sb.toString().contains("eyJfc") && TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_READ") && TestAuditlogImpl.sb.toString().contains("sg_all_access") && TestAuditlogImpl.sb.toString().contains("internalusers"), (Duration)Duration.ofSeconds(5L));
    }

    private void initializeSgIndex(Client tc, DynamicSgConfig sgconfig) {
        try (ThreadContext.StoredContext ctx = tc.threadPool().getThreadContext().stashContext();){
            tc.threadPool().getThreadContext().putTransient("_sg_user", (Object)new User("dummyuser"));
            tc.threadPool().getThreadContext().putTransient("_sg_origin", (Object)AuditLog.Origin.TRANSPORT.name());
            tc.threadPool().getThreadContext().putHeader("_sg_conf_request", "true");
            for (IndexRequest ir : sgconfig.getDynamicConfig(this.getResourceFolder())) {
                tc.index(ir).actionGet();
                tc.get(new GetRequest(ir.index(), ir.id())).actionGet();
            }
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0]))).actionGet();
            Assert.assertFalse((String)cur.failures().toString(), (boolean)cur.hasFailures());
        }
    }

    @Test
    public void testImmutableIndex() throws Exception {
        Settings settings = Settings.builder().put("searchguard.compliance.immutable_indices", "myindex1").put("searchguard.audit.type", "debug").put("searchguard.ssl.http.enabled", false).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true, ClusterConfiguration.DEFAULT);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("myindex1").mapping(FileHelper.loadFile((String)"mapping1.json"))).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("myindex2").mapping(FileHelper.loadFile((String)"mapping1.json"))).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        String data1 = FileHelper.loadFile((String)"auditlog/data1.json");
        String data2 = FileHelper.loadFile((String)"auditlog/data1mod.json");
        RestHelper.HttpResponse res = rh.executePutRequest("myindex1/_doc/1?refresh", data1, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executePutRequest("myindex1/_doc/1?refresh", data2, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("myindex1/_doc/1?refresh", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("myindex1/_doc/1", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertFalse((boolean)res.getBody().contains("city"));
        Assert.assertTrue((boolean)res.getBody().contains("\"found\":true,"));
        res = rh.executePutRequest("myindex2/_doc/1?refresh", data1, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executePutRequest("myindex2/_doc/1?refresh", data2, new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("myindex2/_doc/1", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertTrue((boolean)res.getBody().contains("city"));
        res = rh.executeDeleteRequest("myindex2/_doc/1?refresh", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("myindex2/_doc/1", new Header[]{ComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
    }

    @Test
    @Ignore(value="Does not makes sense for ES 8 because no getInternalTransportClient()")
    public void testInternalConfigRead() throws Exception {
        Settings settings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", true).put("searchguard.audit.resolve_bulk_requests", false).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.internal_config_enabled", true).put("searchguard.audit.config.disabled_transport_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.config.disabled_rest_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true, ClusterConfiguration.DEFAULT);
        TestAuditlogImpl.clear();
    }

    private static /* synthetic */ boolean lambda$testReadWriteSourceSgIndexSgctl$11(Map configsToUpdate, File dir, String name) {
        return configsToUpdate.containsKey(name);
    }
}

