/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.searchguard.enterprise.auditlog.helper.MyOwnAuditLog;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditLogImpl;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.DebugSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.ExternalESSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.InternalESSink;
import org.elasticsearch.common.settings.Settings;
import org.junit.Test;

public class DelegateTest {
    @Test
    public void auditLogTypeTest() throws Exception {
        this.testAuditType("DeBUg", DebugSink.class);
        this.testAuditType("intERnal_Elasticsearch", InternalESSink.class);
        this.testAuditType("EXTERnal_Elasticsearch", ExternalESSink.class);
        this.testAuditType("com.floragunn.searchguard.auditlog.sink.MyOwnAuditLog", MyOwnAuditLog.class);
        this.testAuditType("Com.Floragunn.searchguard.auditlog.sink.MyOwnAuditLog", null);
        this.testAuditType("idonotexist", null);
    }

    private void testAuditType(String type, Class<? extends AuditLogSink> expectedClass) throws Exception {
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("searchguard.audit.type", type);
        settingsBuilder.put("path.home", ".");
        AuditLogImpl auditLog = new AuditLogImpl(settingsBuilder.build(), null, null, null, null, null, null);
        auditLog.close();
    }
}

