/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.sink;

import com.floragunn.searchguard.enterprise.auditlog.helper.LoggingSink;
import com.floragunn.searchguard.enterprise.auditlog.helper.MockAuditMessageFactory;
import com.floragunn.searchguard.enterprise.auditlog.helper.TestHttpHandler;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.MockWebhookAuditLog;
import com.floragunn.searchguard.enterprise.auditlog.sink.WebhookSink;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.network.PortAllocator;
import com.floragunn.searchsupport.util.EsLogging;
import java.io.FileInputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.protocol.HttpRequestHandler;
import org.elasticsearch.common.settings.Settings;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class WebhookAuditLogTest {
    @ClassRule
    public static EsLogging esLogging = new EsLogging();
    protected HttpServer server = null;

    @Before
    @After
    public void tearDown() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void invalidConfFallbackTest() throws Exception {
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        Settings settings = Settings.builder().put("path.home", ".").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).build();
        LoggingSink fallback = new LoggingSink("test", Settings.EMPTY, null, null);
        MockWebhookAuditLog auditlog = new MockWebhookAuditLog(settings, "searchguard.audit.config", fallback);
        auditlog.store(msg);
        Assert.assertEquals(null, (Object)auditlog.webhookFormat);
        Assert.assertEquals((long)1L, (long)fallback.messages.size());
        Assert.assertEquals((Object)msg, (Object)fallback.messages.get(0));
    }

    @Test
    public void formatsTest() throws Exception {
        String url = "http://localhost";
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        Settings settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("path.home", ".").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).build();
        MockWebhookAuditLog auditlog = new MockWebhookAuditLog(settings, "searchguard.audit.config", null);
        auditlog.store(msg);
        Assert.assertEquals((Object)WebhookSink.WebhookFormat.TEXT, (Object)auditlog.webhookFormat);
        Assert.assertEquals((Object)ContentType.TEXT_PLAIN, (Object)auditlog.webhookFormat.getContentType());
        Assert.assertTrue((String)auditlog.payload, (!auditlog.payload.startsWith("{\"text\":") ? 1 : 0) != 0);
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "idonotexist").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("path.home", ".").build();
        auditlog = new MockWebhookAuditLog(settings, "searchguard.audit.config", null);
        auditlog.store(msg);
        Assert.assertEquals((Object)WebhookSink.WebhookFormat.TEXT, (Object)auditlog.webhookFormat);
        Assert.assertEquals((Object)ContentType.TEXT_PLAIN, (Object)auditlog.webhookFormat.getContentType());
        Assert.assertTrue((String)auditlog.payload, (!auditlog.payload.startsWith("{\"text\":") ? 1 : 0) != 0);
        auditlog.close();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "text").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("path.home", ".").build();
        auditlog = new MockWebhookAuditLog(settings, "searchguard.audit.config", null);
        auditlog.store(msg);
        Assert.assertEquals((Object)WebhookSink.WebhookFormat.TEXT, (Object)auditlog.webhookFormat);
        Assert.assertEquals((Object)ContentType.TEXT_PLAIN, (Object)auditlog.webhookFormat.getContentType());
        Assert.assertTrue((String)auditlog.payload, (!auditlog.payload.startsWith("{\"text\":") ? 1 : 0) != 0);
        Assert.assertTrue((String)auditlog.payload, (boolean)auditlog.payload.contains("@timestamp"));
        Assert.assertTrue((String)auditlog.payload, (boolean)auditlog.payload.contains("audit_request_remote_address"));
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "json").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("path.home", ".").build();
        auditlog = new MockWebhookAuditLog(settings, "searchguard.audit.config", null);
        auditlog.store(msg);
        Assert.assertEquals((Object)WebhookSink.WebhookFormat.JSON, (Object)auditlog.webhookFormat);
        Assert.assertEquals((Object)ContentType.APPLICATION_JSON, (Object)auditlog.webhookFormat.getContentType());
        Assert.assertTrue((String)auditlog.payload, (!auditlog.payload.startsWith("{\"text\":") ? 1 : 0) != 0);
        Assert.assertTrue((String)auditlog.payload, (boolean)auditlog.payload.contains("@timestamp"));
        Assert.assertTrue((String)auditlog.payload, (boolean)auditlog.payload.contains("audit_request_remote_address"));
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "slack").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("path.home", ".").build();
        auditlog = new MockWebhookAuditLog(settings, "searchguard.audit.config", null);
        auditlog.store(msg);
        Assert.assertEquals((Object)WebhookSink.WebhookFormat.SLACK, (Object)auditlog.webhookFormat);
        Assert.assertEquals((Object)ContentType.APPLICATION_JSON, (Object)auditlog.webhookFormat.getContentType());
        Assert.assertTrue((String)auditlog.payload, (boolean)auditlog.payload.startsWith("{\"text\":"));
        Assert.assertTrue((String)auditlog.payload, (boolean)auditlog.payload.contains("@timestamp"));
        Assert.assertTrue((String)auditlog.payload, (boolean)auditlog.payload.contains("audit_request_remote_address"));
    }

    @Test
    public void invalidUrlTest() throws Exception {
        String url = "faultyurl";
        Settings settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "slack").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("path.home", ".").build();
        LoggingSink fallback = new LoggingSink("test", Settings.EMPTY, null, null);
        MockWebhookAuditLog auditlog = new MockWebhookAuditLog(settings, "searchguard.audit.config", fallback);
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        auditlog.store(msg);
        Assert.assertEquals(null, (Object)auditlog.url);
        Assert.assertEquals(null, (Object)auditlog.payload);
        Assert.assertEquals(null, (Object)auditlog.webhookUrl);
        Assert.assertEquals((long)1L, (long)fallback.messages.size());
        Assert.assertEquals((Object)msg, (Object)fallback.messages.get(0));
    }

    @Test
    public void noServerRunningHttpTest() throws Exception {
        String url = "http://localhost:8080/endpoint";
        Settings settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "slack").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("path.home", ".").build();
        LoggingSink fallback = new LoggingSink("test", Settings.EMPTY, null, null);
        WebhookSink auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        auditlog.store(msg);
        Assert.assertEquals((Object)"http://localhost:8080/endpoint", (Object)auditlog.webhookUrl);
        Assert.assertEquals((long)1L, (long)fallback.messages.size());
        Assert.assertEquals((Object)msg, (Object)fallback.messages.get(0));
    }

    @Test
    public void postGetHttpTest() throws Exception {
        TestHttpHandler handler = new TestHttpHandler();
        int port = PortAllocator.TCP.allocateSingle(WebhookAuditLogTest.class.getName(), 8090);
        this.server = ServerBootstrap.bootstrap().setListenerPort(port).setServerInfo("Test/1.1").registerHandler("*", (HttpRequestHandler)handler).create();
        this.server.start();
        String url = "http://localhost:" + port + "/endpoint";
        Settings settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "slack").put("path.home", ".").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).build();
        LoggingSink fallback = new LoggingSink("test", Settings.EMPTY, null, null);
        WebhookSink auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.startsWith("{\"text\":"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        Assert.assertEquals((long)0L, (long)fallback.messages.size());
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "texT").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "JSon").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "URL_PARAMETER_POST").put("path.home", ".").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((boolean)handler.body.equals(""));
        Assert.assertTrue((!handler.body.contains("{") ? 1 : 0) != 0);
        this.assertStringContainsAllKeysAndValues(URLDecoder.decode(handler.uri, StandardCharsets.UTF_8.displayName()));
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "URL_PARAMETER_GET").put("path.home", ".").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("GET"));
        Assert.assertEquals(null, (Object)handler.body);
        this.assertStringContainsAllKeysAndValues(URLDecoder.decode(handler.uri, StandardCharsets.UTF_8.displayName()));
        this.server.shutdown(3L, TimeUnit.SECONDS);
    }

    @Test
    public void httpsTestWithoutTLSServer() throws Exception {
        TestHttpHandler handler = new TestHttpHandler();
        int port = PortAllocator.TCP.allocateSingle(WebhookAuditLogTest.class.getName(), 8080);
        this.server = ServerBootstrap.bootstrap().setListenerPort(port).setServerInfo("Test/1.1").registerHandler("*", (HttpRequestHandler)handler).create();
        this.server.start();
        String url = "https://localhost:" + port + "/endpoint";
        Settings settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "slack").put("path.home", ".").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).build();
        LoggingSink fallback = new LoggingSink("test", Settings.EMPTY, null, null);
        WebhookSink auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        auditlog.store(msg);
        Assert.assertTrue((handler.method == null ? 1 : 0) != 0);
        Assert.assertTrue((handler.body == null ? 1 : 0) != 0);
        Assert.assertTrue((handler.uri == null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)fallback.messages.size());
        Assert.assertEquals((Object)msg, (Object)fallback.messages.get(0));
        this.server.shutdown(3L, TimeUnit.SECONDS);
    }

    @Test
    public void httpsTest() throws Exception {
        TestHttpHandler handler = new TestHttpHandler();
        int port = PortAllocator.TCP.allocateSingle(WebhookAuditLogTest.class.getName(), 8090);
        this.server = ServerBootstrap.bootstrap().setListenerPort(port).setServerInfo("Test/1.1").setSslContext(this.createSSLContext()).registerHandler("*", (HttpRequestHandler)handler).create();
        this.server.start();
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        String url = "https://localhost:" + port + "/endpoint";
        Settings settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "slack").put("path.home", ".").put("searchguard.audit.config.webhook.ssl.verify", true).build();
        LoggingSink fallback = new LoggingSink("test", Settings.EMPTY, null, null);
        WebhookSink auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertNull((Object)handler.method);
        Assert.assertNull((Object)handler.body);
        Assert.assertNull((Object)handler.body);
        Assert.assertEquals((long)1L, (long)fallback.messages.size());
        Assert.assertEquals((Object)msg, (Object)fallback.messages.get(0));
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "jSoN").put("searchguard.audit.config.webhook.ssl.verify", false).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "jSoN").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("searchguard.audit.config.webhook.ssl.verify", true).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "jSoN").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore_fail.jks")).put("searchguard.audit.config.webhook.ssl.verify", true).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertNull((Object)handler.method);
        Assert.assertNull((Object)handler.body);
        Assert.assertNull((Object)handler.body);
        this.server.shutdown(3L, TimeUnit.SECONDS);
    }

    @Test
    public void httpsTestPemDefault() throws Exception {
        TestHttpHandler handler = new TestHttpHandler();
        int port = PortAllocator.TCP.allocateSingle(WebhookAuditLogTest.class.getName(), 8090);
        this.server = ServerBootstrap.bootstrap().setListenerPort(port).setServerInfo("Test/1.1").setSslContext(this.createSSLContext()).registerHandler("*", (HttpRequestHandler)handler).create();
        this.server.start();
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        LoggingSink fallback = new LoggingSink("test", Settings.EMPTY, null, null);
        String url = "https://localhost:" + port + "/endpoint";
        handler.reset();
        Settings settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "jSoN").put("searchguard.audit.config.webhook.ssl.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/root-ca.pem")).put("searchguard.audit.config.webhook.ssl.verify", true).put("path.home", ".").build();
        WebhookSink auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "jSoN").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("searchguard.audit.config.webhook.ssl.verify", true).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "jSoN").put("searchguard.audit.config.webhook.ssl.pemtrustedcas_filepath", "wrong").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore_fail.jks")).put("searchguard.audit.config.webhook.ssl.verify", true).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertNull((Object)handler.method);
        Assert.assertNull((Object)handler.body);
        Assert.assertNull((Object)handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.ssl.pemtrustedcas_filepath", "wrong").put("searchguard.audit.config.webhook.format", "jSoN").put("searchguard.audit.config.webhook.ssl.verify", true).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertNull((Object)handler.method);
        Assert.assertNull((Object)handler.body);
        Assert.assertNull((Object)handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "jSoN").put("searchguard.audit.config.webhook.ssl.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/spock.crt.pem")).put("searchguard.audit.config.webhook.ssl.verify", true).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertNull((Object)handler.method);
        Assert.assertNull((Object)handler.body);
        Assert.assertNull((Object)handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.config.webhook.url", url).put("searchguard.audit.config.webhook.format", "jSoN").put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("searchguard.audit.config.webhook.ssl.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/spock.crt.pem")).put("searchguard.audit.config.webhook.ssl.verify", true).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertNull((Object)handler.method);
        Assert.assertNull((Object)handler.body);
        Assert.assertNull((Object)handler.body);
        this.server.shutdown(3L, TimeUnit.SECONDS);
    }

    @Test
    public void httpsTestPemEndpoint() throws Exception {
        TestHttpHandler handler = new TestHttpHandler();
        int port = PortAllocator.TCP.allocateSingle(WebhookAuditLogTest.class.getName(), 8090);
        this.server = ServerBootstrap.bootstrap().setListenerPort(port).setServerInfo("Test/1.1").setSslContext(this.createSSLContext()).registerHandler("*", (HttpRequestHandler)handler).create();
        this.server.start();
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        LoggingSink fallback = new LoggingSink("test", Settings.EMPTY, null, null);
        String url = "https://localhost:" + port + "/endpoint";
        handler.reset();
        Settings settings = Settings.builder().put("searchguard.audit.endpoints.endpoint1.config.webhook.url", url).put("searchguard.audit.endpoints.endpoint1.config.webhook.format", "jSoN").put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/root-ca.pem")).put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.verify", true).put("path.home", ".").build();
        WebhookSink auditlog = new WebhookSink("name", settings, "searchguard.audit.endpoints.endpoint1.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.endpoints.endpoint1.config.webhook.url", url).put("searchguard.audit.endpoints.endpoint1.config.webhook.format", "jSoN").put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.verify", true).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.endpoints.endpoint1.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.endpoints.endpoint1.config.webhook.url", url).put("searchguard.audit.endpoints.endpoint1.config.webhook.format", "jSoN").put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.verify", true).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore_fail.jks")).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.endpoints.endpoint1.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertNull((Object)handler.method);
        Assert.assertNull((Object)handler.body);
        Assert.assertNull((Object)handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.endpoints.endpoint1.config.webhook.url", url).put("searchguard.audit.endpoints.endpoint1.config.webhook.format", "jSoN").put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.verify", true).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.endpoints.endpoint1.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertNull((Object)handler.method);
        Assert.assertNull((Object)handler.body);
        Assert.assertNull((Object)handler.body);
        handler.reset();
        settings = Settings.builder().put("searchguard.audit.endpoints.endpoint1.config.webhook.url", url).put("searchguard.audit.endpoints.endpoint1.config.webhook.format", "jSoN").put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.verify", true).put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/spock.crt.pem")).put("path.home", ".").build();
        auditlog = new WebhookSink("name", settings, "searchguard.audit.endpoints.endpoint1.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertNull((Object)handler.method);
        Assert.assertNull((Object)handler.body);
        Assert.assertNull((Object)handler.body);
        this.server.shutdown(3L, TimeUnit.SECONDS);
    }

    @Test
    public void httpsTestPemContentEndpoint() throws Exception {
        TestHttpHandler handler = new TestHttpHandler();
        int port = PortAllocator.TCP.allocateSingle(WebhookAuditLogTest.class.getName(), 8090);
        this.server = ServerBootstrap.bootstrap().setListenerPort(port).setServerInfo("Test/1.1").setSslContext(this.createSSLContext()).registerHandler("*", (HttpRequestHandler)handler).create();
        this.server.start();
        AuditMessage msg = MockAuditMessageFactory.validAuditMessage();
        LoggingSink fallback = new LoggingSink("test", Settings.EMPTY, null, null);
        String url = "https://localhost:" + port + "/endpoint";
        handler.reset();
        Settings settings = Settings.builder().put("searchguard.audit.endpoints.endpoint1.config.webhook.url", url).put("searchguard.audit.endpoints.endpoint1.config.webhook.format", "jSoN").put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.pemtrustedcas_content", FileHelper.loadFile((String)"auditlog/root-ca.pem")).put("searchguard.audit.endpoints.endpoint1.config.webhook.ssl.verify", true).put("path.home", ".").build();
        WebhookSink auditlog = new WebhookSink("name", settings, "searchguard.audit.endpoints.endpoint1.config", null, (AuditLogSink)fallback);
        auditlog.store(msg);
        Assert.assertTrue((boolean)handler.method.equals("POST"));
        Assert.assertTrue((handler.body != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.body.contains("{"));
        this.assertStringContainsAllKeysAndValues(handler.body);
        this.server.shutdown(3L, TimeUnit.SECONDS);
    }

    private SSLContext createSSLContext() throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = KeyStore.getInstance("JKS");
        FileInputStream trustStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks").toFile());
        trustStore.load(trustStream, "changeit".toCharArray());
        tmf.init(trustStore);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream keyStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/node-0-keystore.jks").toFile());
        keyStore.load(keyStream, "changeit".toCharArray());
        kmf.init(keyStore, "changeit".toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }

    private void assertStringContainsAllKeysAndValues(String in) {
        Assert.assertTrue((String)in, (boolean)in.contains("audit_format_version"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_category"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_format_version"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_request_remote_address"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_request_origin"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_request_layer"));
        Assert.assertTrue((String)in, (boolean)in.contains("audit_transport_request_type"));
        Assert.assertTrue((String)in, (boolean)in.contains("@timestamp"));
        Assert.assertTrue((String)in, (boolean)in.contains(AuditMessage.Category.FAILED_LOGIN.name()));
        Assert.assertTrue((String)in, (boolean)in.contains("FAILED_LOGIN"));
        Assert.assertTrue((String)in, (boolean)in.contains("John Doe"));
        Assert.assertTrue((String)in, (boolean)in.contains("8.8.8.8"));
    }
}

