/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.impl.Utils;
import com.floragunn.searchguard.user.UserInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public final class RequestResolver {
    private static final Logger log = LogManager.getLogger(RequestResolver.class);

    public static List<AuditMessage> resolve(AuditMessage.Category category, AuditLog.Origin origin, String action, String privilege, UserInformation effectiveUser, Boolean sgAdmin, UserInformation initiatingUser, TransportAddress remoteAddress, TransportRequest request, Map<String, String> headers, Task task, IndexNameExpressionResolver resolver, ClusterState clusterState, Settings settings, boolean logRequestBody, boolean resolveIndices, boolean resolveBulk, Pattern searchguardIndex, boolean excludeSensitiveHeaders, Throwable exception) {
        if (resolveBulk && request instanceof BulkShardRequest) {
            BulkItemRequest[] innerRequests = ((BulkShardRequest)request).items();
            ArrayList<AuditMessage> messages = new ArrayList<AuditMessage>(innerRequests.length);
            for (BulkItemRequest ar : innerRequests) {
                DocWriteRequest innerRequest = ar.request();
                AuditMessage msg = RequestResolver.resolveInner(category, effectiveUser, sgAdmin, initiatingUser, remoteAddress, action, privilege, origin, innerRequest, headers, task, resolver, clusterState, settings, logRequestBody, resolveIndices, searchguardIndex, excludeSensitiveHeaders, exception);
                msg.addShardId(((BulkShardRequest)request).shardId());
                messages.add(msg);
            }
            return messages;
        }
        if (request instanceof BulkShardRequest && category != AuditMessage.Category.FAILED_LOGIN && category != AuditMessage.Category.MISSING_PRIVILEGES && category != AuditMessage.Category.SG_INDEX_ATTEMPT) {
            return Collections.emptyList();
        }
        return Collections.singletonList(RequestResolver.resolveInner(category, effectiveUser, sgAdmin, initiatingUser, remoteAddress, action, privilege, origin, request, headers, task, resolver, clusterState, settings, logRequestBody, resolveIndices, searchguardIndex, excludeSensitiveHeaders, exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuditMessage resolveInner(AuditMessage.Category category, UserInformation effectiveUser, Boolean sgAdmin, UserInformation initiatingUser, TransportAddress remoteAddress, String action, String priv, AuditLog.Origin origin, Object request, Map<String, String> headers, Task task, IndexNameExpressionResolver resolver, ClusterState clusterState, Settings settings, boolean addSource, boolean resolveIndices, Pattern searchguardIndex, boolean excludeSensitiveHeaders, Throwable exception) {
        ClusterState localClusterState = clusterState;
        AuditMessage msg = new AuditMessage(category, localClusterState, origin, AuditLog.Origin.TRANSPORT);
        msg.addInitiatingUser(initiatingUser);
        msg.addEffectiveUser(effectiveUser);
        msg.addRemoteAddress(remoteAddress);
        msg.addAction(action);
        if (request != null) {
            msg.addRequestType(request.getClass().getSimpleName());
        }
        if (sgAdmin != null) {
            msg.addIsAdminDn(sgAdmin);
        }
        msg.addException(exception);
        msg.addPrivilege(priv);
        msg.addTransportHeaders(headers, excludeSensitiveHeaders);
        if (task != null) {
            msg.addTaskId(task.getId());
            if (task.getParentTaskId() != null && task.getParentTaskId().isSet()) {
                msg.addTaskParentId(task.getParentTaskId().toString());
            }
        }
        if (request instanceof MultiGetRequest.Item) {
            MultiGetRequest.Item item = (MultiGetRequest.Item)request;
            String[] indices = RequestResolver.arrayOrEmpty(item.indices());
            String id = item.id();
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, null, null, settings, resolveIndices, addSource, false, searchguardIndex);
        } else if (request instanceof CreateIndexRequest) {
            CreateIndexRequest cir = (CreateIndexRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(cir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, null, null, settings, resolveIndices, addSource, false, searchguardIndex);
        } else if (request instanceof DeleteIndexRequest) {
            DeleteIndexRequest dir = (DeleteIndexRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(dir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, null, null, settings, resolveIndices, addSource, false, searchguardIndex);
        } else if (request instanceof IndexRequest) {
            IndexRequest ir = (IndexRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            String id = ir.id();
            msg.addShardId(ir.shardId());
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, ir.getContentType(), ir.source(), settings, resolveIndices, addSource, true, searchguardIndex);
        } else if (request instanceof DeleteRequest) {
            DeleteRequest dr = (DeleteRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(dr.indices());
            String id = dr.id();
            msg.addShardId(dr.shardId());
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, null, null, settings, resolveIndices, addSource, false, searchguardIndex);
        } else if (request instanceof UpdateRequest) {
            UpdateRequest ur = (UpdateRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ur.indices());
            String id = ur.id();
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, null, null, settings, resolveIndices, addSource, false, searchguardIndex);
            if (addSource) {
                if (ur.doc() != null) {
                    msg.addTupleToRequestBody(ur.doc() == null ? null : RequestResolver.convertSource(ur.doc().getContentType(), ur.doc().source()));
                }
                if (ur.script() != null) {
                    msg.addMapToRequestBody(ur.script() == null ? null : Utils.convertJsonToxToStructuredMap((ToXContent)ur.script()));
                }
            }
        } else if (request instanceof GetRequest) {
            GetRequest gr = (GetRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(gr.indices());
            String id = gr.id();
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, null, null, settings, resolveIndices, addSource, false, searchguardIndex);
        } else if (request instanceof SearchRequest) {
            SearchRequest sr = (SearchRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(sr.indices());
            Map<String, Object> sourceAsMap = sr.source() == null ? null : Utils.convertJsonToxToStructuredMap((ToXContent)sr.source());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, XContentType.JSON, sourceAsMap, settings, resolveIndices, addSource, false, searchguardIndex);
        } else if (request instanceof ClusterUpdateSettingsRequest) {
            if (addSource) {
                ClusterUpdateSettingsRequest cusr = (ClusterUpdateSettingsRequest)request;
                Settings persistentSettings = cusr.persistentSettings();
                Settings transientSettings = cusr.transientSettings();
                try (XContentBuilder builder = null;){
                    builder = XContentFactory.jsonBuilder();
                    builder.startObject();
                    if (persistentSettings != null) {
                        builder.field("persistent_settings", Utils.convertJsonToxToStructuredMap((ToXContent)persistentSettings));
                    }
                    if (transientSettings != null) {
                        builder.field("transient_settings", Utils.convertJsonToxToStructuredMap((ToXContent)persistentSettings));
                    }
                    builder.endObject();
                    msg.addUnescapedJsonToRequestBody(builder == null ? null : Strings.toString((XContentBuilder)builder));
                }
            }
        } else if (request instanceof ReindexRequest) {
            IndexRequest ir = ((ReindexRequest)request).getDestination();
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            String id = ir.id();
            msg.addShardId(ir.shardId());
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, ir.getContentType(), ir.source(), settings, resolveIndices, addSource, true, searchguardIndex);
        } else if (request instanceof DeleteByQueryRequest) {
            DeleteByQueryRequest ir = (DeleteByQueryRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, null, null, settings, resolveIndices, addSource, false, searchguardIndex);
        } else if (request instanceof UpdateByQueryRequest) {
            UpdateByQueryRequest ir = (UpdateByQueryRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, null, null, settings, resolveIndices, addSource, false, searchguardIndex);
        } else if (request instanceof PutMappingRequest) {
            PutMappingRequest pr = (PutMappingRequest)request;
            Index ci = pr.getConcreteIndex();
            String[] indices = new String[]{};
            msg.addIndices(indices);
            if (ci != null) {
                indices = new String[]{ci.getName()};
            }
            if (addSource) {
                msg.addUnescapedJsonToRequestBody(pr.source());
            }
            if (resolveIndices) {
                msg.addResolvedIndices(indices);
            }
        } else if (request instanceof IndicesRequest) {
            IndicesRequest ir = (IndicesRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, localClusterState, null, null, settings, resolveIndices, addSource, false, searchguardIndex);
        }
        return msg;
    }

    private static void addIndicesSourceSafe(AuditMessage msg, String[] indices, IndexNameExpressionResolver resolver, ClusterState clusterState, XContentType xContentType, Object source, Settings settings, boolean resolveIndices, boolean addSource, boolean sourceIsSensitive, Pattern searchguardIndex) {
        HashSet<String> allIndices;
        if (addSource) {
            resolveIndices = true;
        }
        String[] _indices = indices == null ? new String[]{} : indices;
        msg.addIndices(_indices);
        if (resolveIndices && clusterState != null) {
            String[] resolvedIndices = resolver == null ? new String[]{} : resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), indices);
            msg.addResolvedIndices(resolvedIndices);
            allIndices = new HashSet<String>(Arrays.asList(resolvedIndices));
        } else {
            allIndices = new HashSet<String>(_indices.length);
            allIndices.addAll(Arrays.asList(_indices));
            if (allIndices.contains("_all")) {
                allIndices.add("*");
            }
        }
        if (addSource) {
            if (sourceIsSensitive && source != null) {
                if (!searchguardIndex.matches(allIndices)) {
                    if (source instanceof BytesReference) {
                        msg.addTupleToRequestBody(RequestResolver.convertSource(xContentType, (BytesReference)source));
                    } else {
                        msg.addMapToRequestBody((Map)source);
                    }
                }
            } else if (source != null) {
                if (source instanceof BytesReference) {
                    msg.addTupleToRequestBody(RequestResolver.convertSource(xContentType, (BytesReference)source));
                } else {
                    msg.addMapToRequestBody((Map)source);
                }
            }
        }
    }

    private static Tuple<XContentType, BytesReference> convertSource(XContentType type, BytesReference bytes) {
        if (type == null) {
            type = XContentType.JSON;
        }
        return new Tuple((Object)type, (Object)bytes);
    }

    private static String[] arrayOrEmpty(String[] array) {
        if (array == null) {
            return new String[0];
        }
        if (array.length == 1 && array[0] == null) {
            return new String[0];
        }
        return array;
    }
}

