/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.routing;

import com.floragunn.searchguard.enterprise.auditlog.AuditLogConfig;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.impl.Utils;
import com.floragunn.searchguard.enterprise.auditlog.routing.AsyncStoragePool;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.SinkProvider;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;

public class AuditMessageRouter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    final AuditLogSink defaultSink;
    final Map<AuditMessage.Category, List<AuditLogSink>> categorySinks = new EnumMap<AuditMessage.Category, List<AuditLogSink>>(AuditMessage.Category.class);
    final SinkProvider sinkProvider;
    final AsyncStoragePool storagePool;
    final boolean enabled;
    boolean hasMultipleEndpoints;
    private AuditLogConfig complianceConfig;

    public AuditMessageRouter(Settings settings, Client clientProvider, ThreadPool threadPool, Path configPath) {
        this.sinkProvider = new SinkProvider(settings, clientProvider, threadPool, configPath);
        this.storagePool = new AsyncStoragePool(settings);
        this.defaultSink = this.sinkProvider.getDefaultSink();
        if (this.defaultSink == null) {
            this.log.warn("No default storage available, audit log may not work properly. Please check configuration.");
            this.enabled = false;
        } else {
            this.setupRoutes(settings);
            this.enabled = true;
        }
    }

    public void setComplianceConfig(AuditLogConfig complianceConfig) {
        this.complianceConfig = complianceConfig;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public final void route(AuditMessage msg) {
        if (!this.enabled) {
            this.log.error("#route(AuditMessage) called but message router is disabled");
            return;
        }
        if (!this.hasMultipleEndpoints || this.complianceConfig == null || !this.complianceConfig.isEnabled()) {
            this.store(this.defaultSink, msg);
        } else {
            for (AuditLogSink sink : this.categorySinks.get((Object)msg.getCategory())) {
                this.store(sink, msg);
            }
        }
    }

    public final void close() {
        this.storagePool.close();
        this.sinkProvider.close();
    }

    protected final void close(List<AuditLogSink> sinks) {
        for (AuditLogSink sink : sinks) {
            try {
                this.log.info("Closing {}", (Object)sink.getClass().getSimpleName());
                sink.close();
            }
            catch (Exception ex) {
                this.log.info("Could not close delegate '{}' due to '{}'", (Object)sink.getClass().getSimpleName(), (Object)ex.getMessage());
            }
        }
    }

    private final void setupRoutes(Settings settings) {
        Map<String, Object> routesConfiguration = Utils.convertJsonToxToStructuredMap((ToXContent)settings.getAsSettings("searchguard.audit.routes"));
        if (!routesConfiguration.isEmpty()) {
            this.hasMultipleEndpoints = true;
            for (Map.Entry<String, Object> routesEntry : routesConfiguration.entrySet()) {
                this.log.trace("Setting up routes for endpoint {}, configuraton is {}", (Object)routesEntry.getKey(), routesEntry.getValue());
                String categoryName = routesEntry.getKey();
                try {
                    AuditMessage.Category category = AuditMessage.Category.valueOf(categoryName.toUpperCase());
                    if (this.categorySinks.get((Object)category) != null) {
                        this.log.warn("Duplicate routing configuration detected for category {}, skipping.", (Object)category);
                        continue;
                    }
                    List<AuditLogSink> sinksForCategory = this.createSinksForCategory(category, settings.getAsSettings("searchguard.audit.routes." + categoryName));
                    if (!sinksForCategory.isEmpty()) {
                        this.categorySinks.put(category, sinksForCategory);
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.debug("Created {} endpoints for category {}", (Object)sinksForCategory.size(), (Object)category);
                        continue;
                    }
                    this.log.debug("No valid endpoints found for category {} adding only default.", (Object)category);
                }
                catch (Exception e) {
                    this.log.error("Invalid category '{}' found in routing configuration. Must be one of: {}", (Object)categoryName, (Object)AuditMessage.Category.values());
                }
            }
            for (AuditMessage.Category category : AuditMessage.Category.values()) {
                if (this.categorySinks.containsKey((Object)category)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No endpoint configured for category {}, adding default endpoint", (Object)category);
                }
                this.categorySinks.put(category, Collections.singletonList(this.defaultSink));
            }
        }
    }

    private final List<AuditLogSink> createSinksForCategory(AuditMessage.Category category, Settings configuration) {
        LinkedList<AuditLogSink> sinksForCategory = new LinkedList<AuditLogSink>();
        List sinks = configuration.getAsList("endpoints");
        if (sinks == null || sinks.isEmpty()) {
            this.log.error("No endpoints configured for category {}", (Object)category);
            return sinksForCategory;
        }
        for (String sinkName : sinks) {
            AuditLogSink sink = this.sinkProvider.getSink(sinkName);
            if (sink != null && !sinksForCategory.contains(sink)) {
                sinksForCategory.add(sink);
                continue;
            }
            this.log.error("Configured endpoint '{}' not available", (Object)sinkName);
        }
        return sinksForCategory;
    }

    private final void store(AuditLogSink sink, AuditMessage msg) {
        if (sink.isHandlingBackpressure()) {
            sink.store(msg);
            if (this.log.isTraceEnabled()) {
                this.log.trace("stored on sink {} synchronously", (Object)sink.getClass().getSimpleName());
            }
        } else {
            this.storagePool.submit(msg, sink);
            if (this.log.isTraceEnabled()) {
                this.log.trace("will store on sink {} asynchronously", (Object)sink.getClass().getSimpleName());
            }
        }
    }
}

