/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchsupport.junit.AsyncAssert;
import java.time.Duration;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class TracingTests
extends SingleClusterTest {
    protected String getResourceFolder() {
        return "auditlog";
    }

    @Test
    public void testHTTPTrace() throws Exception {
        Settings settings = Settings.builder().put("searchguard.audit.type", "debug").put("searchguard.compliance.history.read.watched_fields", "*").put("searchguard.compliance.history.write.watched_indices", "*").put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.log4j.logger_name", "sg_action_trace").put("searchguard.audit.config.log4j.level", "TRACE").put("searchguard.ssl.http.enabled", false).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true, ClusterConfiguration.DEFAULT);
        Client tc = this.getPrivilegedInternalNodeClient();
        for (int i = 0; i < 50; ++i) {
            tc.index(((IndexRequest)new IndexRequest("a").id("" + i).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("c").id("" + i).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        String reindex = "{  \"source\": {    \"index\": \"a\"  },  \"dest\": {    \"index\": \"new_a\"  }}";
        String msearchBody = "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"public\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        String mgetBody = "{\"docs\" : [{\"_index\" : \"a\",\"_type\" : \"b\",\"_id\" : \"1\" }, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"12\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"13\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"14\"}]}";
        String dbqBody = "{  \"query\": {     \"match\": {      \"content\": 12    }  }}";
    }

    @Test
    public void testHTTPSingle() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        });
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).put("searchguard.ssl.http.enabled", false).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_academy").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_library").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("klingonempire").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("spock").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("kirk").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("role01_role02").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        AsyncAssert.awaitAssert((String)"_search is OK", () -> rh.executeGetRequest("_search", new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")}).getStatusCode() == 200, (Duration)Duration.ofSeconds(10L));
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"myindex\", \"_type\" : \"myindex\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"myindex\", \"_type\" : \"myindex\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator();
    }

    @Test
    public void testSearchScroll() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        });
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).put("searchguard.ssl.http.enabled", false).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        for (int i = 0; i < 3; ++i) {
            tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executeGetRequest("vulcangov/_search?scroll=1m&pretty=true", new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        int start = res.getBody().indexOf("_scroll_id") + 15;
        String scrollid = res.getBody().substring(start, res.getBody().indexOf("\"", start + 1));
        res = rh.executePostRequest("/_search/scroll?pretty=true", "{\"scroll_id\" : \"" + scrollid + "\"}", new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testAdvancedMapping() throws Exception {
        Settings settings = Settings.builder().put("searchguard.compliance.history.read.watched_fields", "*").put("searchguard.compliance.history.write.watched_indices", "*").put("searchguard.ssl.http.enabled", false).put("searchguard.audit.type", "debug").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true, ClusterConfiguration.DEFAULT);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("myindex1").mapping(FileHelper.loadFile((String)"mapping1.json"))).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("myindex2").mapping(FileHelper.loadFile((String)"mapping2.json"))).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("myindex3").mapping(FileHelper.loadFile((String)"mapping3.json"))).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("myindex4").mapping(FileHelper.loadFile((String)"mapping4.json"))).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        String data1 = FileHelper.loadFile((String)"auditlog/data1.json");
        String data2 = FileHelper.loadFile((String)"auditlog/data1mod.json");
        String parent = FileHelper.loadFile((String)"auditlog/data2.json");
        String child = FileHelper.loadFile((String)"auditlog/data3.json");
    }

    @Test
    public void testImmutableIndex() throws Exception {
        Settings settings = Settings.builder().put("searchguard.compliance.immutable_indices", "myindex1").put("searchguard.audit.type", "debug").put("searchguard.ssl.http.enabled", false).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true, ClusterConfiguration.DEFAULT);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("myindex1").mapping(FileHelper.loadFile((String)"mapping1.json"))).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("myindex2").mapping(FileHelper.loadFile((String)"mapping1.json"))).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        String data1 = FileHelper.loadFile((String)"auditlog/data1.json");
        String data2 = FileHelper.loadFile((String)"auditlog/data1mod.json");
        RestHelper.HttpResponse res = rh.executePutRequest("myindex1/_doc/1?refresh", data1, new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executePutRequest("myindex1/_doc/1?refresh", data2, new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("myindex1/_doc/1?refresh", new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("myindex1/_doc/1", new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertFalse((boolean)res.getBody().contains("city"));
        Assert.assertTrue((boolean)res.getBody().contains("\"found\":true,"));
        res = rh.executePutRequest("myindex2/_doc/1?refresh", data1, new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executePutRequest("myindex2/_doc/1?refresh", data2, new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("myindex2/_doc/1", new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertTrue((boolean)res.getBody().contains("city"));
        res = rh.executeDeleteRequest("myindex2/_doc/1?refresh", new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("myindex2/_doc/1", new Header[]{TracingTests.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
    }
}

