/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.sink;

import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.DebugSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.ExternalESSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.InternalESSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.Log4JSink;
import com.floragunn.searchguard.enterprise.auditlog.sink.SinkProvider;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import org.apache.logging.log4j.Level;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Test;

public class SinkProviderTest {
    @Test
    public void testConfiguration() throws Exception {
        Settings settings = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/sink/configuration_all_variants.yml")).build();
        SinkProvider provider = new SinkProvider(settings, null, null, null);
        Assert.assertEquals(DebugSink.class, provider.fallbackSink.getClass());
        AuditLogSink sink = provider.getSink("DefaULT");
        Assert.assertEquals(sink.getClass(), DebugSink.class);
        sink = provider.getSink("endpoint1");
        Assert.assertEquals(InternalESSink.class, sink.getClass());
        sink = provider.getSink("endpoint2");
        Assert.assertEquals(ExternalESSink.class, sink.getClass());
        sink = provider.getSink("endpoinT3");
        Assert.assertEquals(DebugSink.class, sink.getClass());
        sink = provider.getSink("endpoint4");
        Assert.assertEquals(null, (Object)sink);
        sink = provider.getSink("endpoint2");
        Assert.assertEquals(ExternalESSink.class, sink.getClass());
        sink = provider.getSink("endpoint6");
        Assert.assertEquals(null, (Object)sink);
        sink = provider.getSink("endpoint7");
        Assert.assertEquals(null, (Object)sink);
        sink = provider.getSink("endpoint8");
        Assert.assertEquals(DebugSink.class, sink.getClass());
        sink = provider.getSink("endpoint9");
        Assert.assertEquals(ExternalESSink.class, sink.getClass());
        sink = provider.getSink("endpoint10");
        Assert.assertEquals(Log4JSink.class, sink.getClass());
        Log4JSink lsink = (Log4JSink)sink;
        Assert.assertEquals((Object)"loggername", (Object)lsink.loggerName);
        Assert.assertEquals((Object)Level.WARN, (Object)lsink.logLevel);
        sink = provider.getSink("endpoint11");
        Assert.assertEquals(Log4JSink.class, sink.getClass());
        lsink = (Log4JSink)sink;
        Assert.assertEquals((Object)"loggername", (Object)lsink.loggerName);
        Assert.assertEquals((Object)Level.INFO, (Object)lsink.logLevel);
        sink = provider.getSink("endpoint12");
        Assert.assertEquals(Log4JSink.class, sink.getClass());
        lsink = (Log4JSink)sink;
        Assert.assertEquals((Object)"loggername", (Object)lsink.loggerName);
        Assert.assertEquals((Object)Level.DEBUG, (Object)lsink.logLevel);
    }

    @Test
    public void testNoMultipleEndpointsConfiguration() throws Exception {
        Settings settings = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/sink/configuration_no_multiple_endpoints.yml")).build();
        SinkProvider provider = new SinkProvider(settings, null, null, null);
        InternalESSink sink = (InternalESSink)provider.defaultSink;
        Assert.assertEquals((Object)"myownindex", (Object)sink.index);
    }
}

