/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.sink;

import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import com.floragunn.searchguard.httpclient.HttpClient;
import com.floragunn.searchguard.support.PemKeyReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.settings.Settings;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class ExternalESSink
extends AuditLogSink {
    private static final List<String> DEFAULT_TLS_PROTOCOLS = Arrays.asList("TLSv1.2", "TLSv1.1");
    private final String index;
    private final HttpClient client;
    private List<String> servers;
    private DateTimeFormatter indexPattern;
    static final String PKCS12 = "PKCS12";

    public ExternalESSink(String name, Settings settings, String settingPrefix, Path configPath, AuditLogSink fallbackSink) throws Exception {
        super(name, settings, settingPrefix, fallbackSink);
        Settings sinkSettings = settings.getAsSettings(settingPrefix);
        this.servers = sinkSettings.getAsList("http_endpoints");
        if (this.servers == null || this.servers.size() == 0) {
            this.log.error("No http endpoints configured for external Elasticsearch endpoint '{}', falling back to localhost.", (Object)name);
            this.servers = Collections.singletonList("localhost:9200");
        }
        this.index = sinkSettings.get("index", "'sg7-auditlog-'YYYY.MM.dd");
        try {
            this.indexPattern = DateTimeFormat.forPattern((String)this.index);
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Unable to parse index pattern due to {}. If you have no date pattern configured you can safely ignore this message", (Object)e.getMessage());
        }
        boolean verifyHostnames = sinkSettings.getAsBoolean("verify_hostnames", Boolean.valueOf(true));
        boolean enableSsl = sinkSettings.getAsBoolean("enable_ssl", Boolean.valueOf(false));
        boolean enableSslClientAuth = sinkSettings.getAsBoolean("enable_ssl_client_auth", Boolean.valueOf(false));
        String user = sinkSettings.get("username");
        String password = sinkSettings.get("password");
        HttpClient.HttpClientBuilder builder = HttpClient.builder(this.servers.toArray(new String[0]));
        if (enableSsl) {
            KeyStore effectiveKeystore;
            KeyStore effectiveTruststore;
            String effectiveKeyAlias;
            char[] effectiveKeyPassword;
            boolean pem;
            boolean bl = pem = sinkSettings.get("pemtrustedcas_filepath", null) != null || sinkSettings.get("pemtrustedcas_content", null) != null;
            if (pem) {
                PrivateKey authenticationKey;
                X509Certificate[] authenticationCertificate;
                X509Certificate[] trustCertificates = PemKeyReader.loadCertificatesFromStream((InputStream)PemKeyReader.resolveStream((String)"pemtrustedcas_content", (Settings)sinkSettings));
                if (trustCertificates == null) {
                    String path = sinkSettings.get("pemtrustedcas_filepath");
                    trustCertificates = PemKeyReader.loadCertificatesFromFile((String)PemKeyReader.resolve((String)path, (String)"pemtrustedcas_filepath", (Settings)settings, (Path)configPath, (boolean)true));
                }
                if ((authenticationCertificate = PemKeyReader.loadCertificatesFromStream((InputStream)PemKeyReader.resolveStream((String)"pemcert_content", (Settings)sinkSettings))) == null) {
                    String path = sinkSettings.get("pemcert_filepath");
                    authenticationCertificate = PemKeyReader.loadCertificatesFromFile((String)PemKeyReader.resolve((String)path, (String)"pemcert_filepath", (Settings)settings, (Path)configPath, (boolean)enableSslClientAuth));
                }
                if ((authenticationKey = PemKeyReader.loadKeyFromStream((String)sinkSettings.get("pemkey_password"), (InputStream)PemKeyReader.resolveStream((String)"pemkey_content", (Settings)sinkSettings))) == null) {
                    String path = sinkSettings.get("pemkey_filepath");
                    authenticationKey = PemKeyReader.loadKeyFromFile((String)sinkSettings.get("pemkey_password"), (String)PemKeyReader.resolve((String)path, (String)"pemkey_filepath", (Settings)settings, (Path)configPath, (boolean)enableSslClientAuth));
                }
                effectiveKeyPassword = PemKeyReader.randomChars((int)12);
                effectiveKeyAlias = "al";
                effectiveTruststore = PemKeyReader.toTruststore((String)effectiveKeyAlias, (X509Certificate[])trustCertificates);
                effectiveKeystore = PemKeyReader.toKeystore((String)effectiveKeyAlias, (char[])effectiveKeyPassword, (X509Certificate[])authenticationCertificate, (PrivateKey)authenticationKey);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Use PEM to secure communication with auditlog server (client auth is {})", (Object)(authenticationKey != null ? 1 : 0));
                }
            } else {
                KeyStore trustStore = PemKeyReader.loadKeyStore((String)PemKeyReader.resolve((String)"searchguard.ssl.transport.truststore_filepath", (Settings)settings, (Path)configPath, (boolean)true), (String)settings.get("searchguard.ssl.transport.truststore_password", "changeit"), (String)settings.get("searchguard.ssl.transport.truststore_type"));
                KeyStore keyStore = PemKeyReader.loadKeyStore((String)PemKeyReader.resolve((String)"searchguard.ssl.transport.keystore_filepath", (Settings)settings, (Path)configPath, (boolean)enableSslClientAuth), (String)settings.get("searchguard.ssl.transport.keystore_password", "changeit"), (String)settings.get("searchguard.ssl.transport.keystore_type"));
                String keyStorePassword = settings.get("searchguard.ssl.transport.keystore_password", "changeit");
                effectiveKeyPassword = keyStorePassword == null || keyStorePassword.isEmpty() ? null : keyStorePassword.toCharArray();
                effectiveKeyAlias = sinkSettings.get("cert_alias", null);
                if (enableSslClientAuth && effectiveKeyAlias == null) {
                    throw new IllegalArgumentException("cert_alias not given");
                }
                effectiveTruststore = trustStore;
                effectiveKeystore = keyStore;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Use Trust-/Keystore to secure communication with LDAP server (client auth is {})", (Object)(keyStore != null ? 1 : 0));
                    this.log.debug("keyStoreAlias: {}", (Object)effectiveKeyAlias);
                }
            }
            List enabledCipherSuites = sinkSettings.getAsList("enabled_ssl_ciphers", null);
            List enabledProtocols = sinkSettings.getAsList("enabled_ssl_protocols", DEFAULT_TLS_PROTOCOLS);
            builder.setSupportedCipherSuites(enabledCipherSuites == null ? null : enabledCipherSuites.toArray(new String[0]));
            builder.setSupportedProtocols(enabledProtocols.toArray(new String[0]));
            builder.enableSsl(effectiveTruststore, verifyHostnames);
            if (enableSslClientAuth) {
                builder.setPkiCredentials(effectiveKeystore, effectiveKeyPassword, effectiveKeyAlias);
            }
        }
        if (user != null && password != null) {
            builder.setBasicCredentials(user, password);
        }
        this.client = builder.build();
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public boolean doStore(AuditMessage msg) {
        try {
            boolean successful = this.client.index(msg.toString(), this.getExpandedIndexName(this.indexPattern, this.index), true);
            if (!successful) {
                this.log.error("Unable to send audit log {} to one of these servers: {}", (Object)msg, this.servers);
            }
            return successful;
        }
        catch (Exception e) {
            this.log.error("Unable to send audit log {} due to", (Object)msg, (Object)e);
            return false;
        }
    }
}

