/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.httpclient;

import com.floragunn.searchguard.httpclient.HttpClient;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Test;

public class HttpClientTest
extends SingleClusterTest {
    protected String getResourceFolder() {
        return "auditlog";
    }

    @Test
    public void testPlainConnection() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.enabled", false).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        Thread.sleep(1000L);
        try (HttpClient httpClient = HttpClient.builder((String[])new String[]{this.clusterInfo.httpHost + ":" + this.clusterInfo.httpPort}).setBasicCredentials("admin", "admin").build();){
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", false));
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", true));
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", true));
        }
        httpClient = HttpClient.builder((String[])new String[]{"unknownhost:6654"}).setBasicCredentials("admin", "admin").build();
        try {
            Assert.assertFalse((boolean)httpClient.index("{\"a\":5}", "index", false));
            Assert.assertFalse((boolean)httpClient.index("{\"a\":5}", "index", true));
            Assert.assertFalse((boolean)httpClient.index("{\"a\":5}", "index", true));
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        httpClient = HttpClient.builder((String[])new String[]{"unknownhost:6654", this.clusterInfo.httpHost + ":" + this.clusterInfo.httpPort}).enableSsl(FileHelper.getKeystoreFromClassPath((String)"auditlog/truststore.jks", (String)"changeit"), false).setBasicCredentials("admin", "admin").build();
        try {
            Assert.assertFalse((boolean)httpClient.index("{\"a\":5}", "index", false));
            Assert.assertFalse((boolean)httpClient.index("{\"a\":5}", "index", true));
            Assert.assertFalse((boolean)httpClient.index("{\"a\":5}", "index", true));
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        httpClient = HttpClient.builder((String[])new String[]{"unknownhost:6654", this.clusterInfo.httpHost + ":" + this.clusterInfo.httpPort}).setBasicCredentials("admin", "admin").build();
        try {
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", false));
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", true));
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", true));
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
    }

    @Test
    public void testSslConnection() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        Thread.sleep(1000L);
        try (HttpClient httpClient = HttpClient.builder((String[])new String[]{this.clusterInfo.httpHost + ":" + this.clusterInfo.httpPort}).enableSsl(FileHelper.getKeystoreFromClassPath((String)"auditlog/truststore.jks", (String)"changeit"), false).setBasicCredentials("admin", "admin").build();){
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", false));
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", true));
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", true));
        }
        httpClient = HttpClient.builder((String[])new String[]{this.clusterInfo.httpHost + ":" + this.clusterInfo.httpPort}).setBasicCredentials("admin", "admin").build();
        try {
            Assert.assertFalse((boolean)httpClient.index("{\"a\":5}", "index", false));
            Assert.assertFalse((boolean)httpClient.index("{\"a\":5}", "index", true));
            Assert.assertFalse((boolean)httpClient.index("{\"a\":5}", "index", true));
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
    }

    @Test
    public void testSslConnectionPKIAuth() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/truststore.jks")).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        Thread.sleep(1000L);
        try (HttpClient httpClient = HttpClient.builder((String[])new String[]{this.clusterInfo.httpHost + ":" + this.clusterInfo.httpPort}).enableSsl(FileHelper.getKeystoreFromClassPath((String)"auditlog/truststore.jks", (String)"changeit"), false).setPkiCredentials(FileHelper.getKeystoreFromClassPath((String)"auditlog/spock-keystore.jks", (String)"changeit"), "changeit".toCharArray(), null).build();){
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", false));
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", true));
            Assert.assertTrue((boolean)httpClient.index("{\"a\":5}", "index", true));
        }
    }
}

