/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.sink;

import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.sink.AuditLogSink;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public final class Log4JSink
extends AuditLogSink {
    final Logger auditLogger;
    final String loggerName;
    final Level logLevel;
    final boolean enabled;

    public Log4JSink(String name, Settings settings, String settingsPrefix, AuditLogSink fallbackSink) {
        super(name, settings, settingsPrefix, fallbackSink);
        this.loggerName = settings.get(settingsPrefix + ".log4j.logger_name", "sgaudit");
        this.auditLogger = LogManager.getLogger((String)this.loggerName);
        this.logLevel = Level.toLevel((String)settings.get(settingsPrefix + ".log4j.level", "INFO").toUpperCase());
        this.enabled = this.auditLogger.isEnabled(this.logLevel);
    }

    @Override
    public boolean isHandlingBackpressure() {
        return !this.enabled;
    }

    @Override
    public boolean doStore(AuditMessage msg) {
        if (this.enabled) {
            this.auditLogger.log(this.logLevel, msg.toJson());
        }
        return true;
    }
}

