/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.compliance;

import com.floragunn.searchguard.enterprise.auditlog.AbstractAuditlogiUnitTest;
import com.floragunn.searchguard.enterprise.auditlog.integration.TestAuditlogImpl;
import com.floragunn.searchguard.legacy.test.RestHelper;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RestApiComplianceAuditlogTest
extends AbstractAuditlogiUnitTest {
    @Test
    public void testRestApiRolesEnabled() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.restapi.roles_enabled", "sg_all_access").put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", true).put("searchguard.audit.resolve_bulk_requests", false).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.internal_config_enabled", true).put("searchguard.audit.config.disabled_transport_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.config.disabled_rest_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        System.out.println("===== Test start ======");
        String body = "{ \"password\":\"test\",\"backend_roles\":[\"role1\",\"role2\"] }";
        RestHelper.HttpResponse response = this.rh.executePutRequest("_searchguard/api/internalusers/compuser?pretty", body, new Header[]{RestApiComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Thread.sleep(1500L);
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        Assert.assertTrue((String)(TestAuditlogImpl.messages.size() + ": " + String.valueOf(TestAuditlogImpl.messages)), (TestAuditlogImpl.messages.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("audit_request_effective_user"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_READ"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_WRITE"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("UPDATE"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testRestApiRolesDisabled() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", true).put("searchguard.audit.resolve_bulk_requests", false).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.internal_config_enabled", true).put("searchguard.audit.config.disabled_transport_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.config.disabled_rest_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        String body = "{ \"password\":\"test\",\"backend_roles\":[\"role1\",\"role2\"] }";
        this.rh.enableHTTPClientSSL = true;
        this.rh.trustHTTPServerCertificate = true;
        this.rh.sendHTTPClientCertificate = true;
        this.rh.keystore = "kirk-keystore.jks";
        RestHelper.HttpResponse response = this.rh.executePutRequest("_searchguard/api/internalusers/compuser?pretty", body, new Header[0]);
        Thread.sleep(1500L);
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        Assert.assertTrue((String)(TestAuditlogImpl.messages.size() + ": " + String.valueOf(TestAuditlogImpl.messages)), (TestAuditlogImpl.messages.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("audit_request_effective_user"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_READ"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_WRITE"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("UPDATE"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    @Ignore(value="TODO why is this ignored?")
    public void testRestApiRolesDisabledGet() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", true).put("searchguard.audit.resolve_bulk_requests", false).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.internal_config_enabled", true).put("searchguard.audit.config.disabled_transport_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.config.disabled_rest_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        this.rh.enableHTTPClientSSL = true;
        this.rh.trustHTTPServerCertificate = true;
        this.rh.sendHTTPClientCertificate = true;
        this.rh.keystore = "kirk-keystore.jks";
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_searchguard/api/rolesmapping/sg_all_access?pretty", new Header[0]);
        Thread.sleep(1500L);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((TestAuditlogImpl.messages.size() > 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("audit_request_effective_user"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_READ"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_WRITE"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("UPDATE"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }

    @Test
    public void testRestApiNewUser() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.restapi.roles_enabled", "sg_all_access").put("searchguard.audit.enable_transport", false).put("searchguard.audit.enable_rest", false).put("searchguard.audit.resolve_bulk_requests", false).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.internal_config_enabled", true).put("searchguard.compliance.history.write.ignore_users", "admin").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        String body = "{ \"password\":\"test\",\"backend_roles\":[\"role1\",\"role2\"] }";
        RestHelper.HttpResponse response = this.rh.executePutRequest("_searchguard/api/internalusers/compuser?pretty", body, new Header[]{RestApiComplianceAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Thread.sleep(1500L);
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        Assert.assertTrue((String)(TestAuditlogImpl.messages.size() + ": " + String.valueOf(TestAuditlogImpl.messages)), (boolean)TestAuditlogImpl.messages.isEmpty());
    }

    @Test
    public void testRestInternalConfigRead() throws Exception {
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.enable_transport", true).put("searchguard.audit.enable_rest", true).put("searchguard.audit.resolve_bulk_requests", false).put("searchguard.compliance.history.external_config_enabled", false).put("searchguard.compliance.history.internal_config_enabled", true).put("searchguard.audit.config.disabled_transport_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.config.disabled_rest_categories", "authenticated,GRANTED_PRIVILEGES").put("searchguard.audit.threadpool.size", 0).build();
        this.setup(additionalSettings);
        TestAuditlogImpl.clear();
        this.rh.enableHTTPClientSSL = true;
        this.rh.trustHTTPServerCertificate = true;
        this.rh.sendHTTPClientCertificate = true;
        this.rh.keystore = "kirk-keystore.jks";
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_searchguard/api/internalusers/admin?pretty", new Header[0]);
        Thread.sleep(1500L);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((String)("" + TestAuditlogImpl.messages.size()), (TestAuditlogImpl.messages.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("audit_request_effective_user"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_READ"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("COMPLIANCE_INTERNAL_CONFIG_WRITE"));
        Assert.assertFalse((boolean)TestAuditlogImpl.sb.toString().contains("UPDATE"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("audit_request_body"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("backend_roles"));
        Assert.assertTrue((boolean)TestAuditlogImpl.sb.toString().contains("hash"));
        Assert.assertTrue((boolean)this.validateMsgs(TestAuditlogImpl.messages));
    }
}

