/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auditlog.helper.MockRestRequest;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditLogImpl;
import com.floragunn.searchguard.enterprise.auditlog.integration.TestAuditlogImpl;
import com.floragunn.searchguard.user.UserInformation;
import com.floragunn.searchsupport.util.EsLogging;
import java.util.List;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.threadpool.DefaultBuiltInExecutorBuilders;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.internal.BuiltInExecutorBuilders;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class IgnoreRequestBodiesTest {
    @ClassRule
    public static EsLogging esLogging = new EsLogging();
    ClusterService cs = (ClusterService)Mockito.mock(ClusterService.class);
    DiscoveryNode dn = (DiscoveryNode)Mockito.mock(DiscoveryNode.class);
    ConfigurationRepository configurationRepository = (ConfigurationRepository)Mockito.mock(ConfigurationRepository.class);
    Settings.Builder settingsBuilder = Settings.builder().put("searchguard.audit.type", TestAuditlogImpl.class.getName()).put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.config.disabled_rest_categories", "NONE").put("searchguard.audit.log_request_body", true).put("searchguard.audit.threadpool.size", 0);

    @Before
    public void setup() {
        Mockito.when((Object)this.dn.getHostAddress()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.dn.getId()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.dn.getHostName()).thenReturn((Object)"hostaddress");
        Mockito.when((Object)this.cs.localNode()).thenReturn((Object)this.dn);
        Mockito.when((Object)this.cs.getClusterName()).thenReturn((Object)new ClusterName("cname"));
        Mockito.when((Object)this.configurationRepository.getConfiguredSearchguardIndices()).thenReturn((Object)Pattern.blank());
    }

    @Test
    public void testIgnoreBulkRequestBodiesDefault() throws Exception {
        BulkShardRequest bulkShardRequest = new BulkShardRequest(ShardId.fromString((String)"[my_index][0]"), WriteRequest.RefreshPolicy.IMMEDIATE, new BulkItemRequest[]{new BulkItemRequest(0, (DocWriteRequest)new IndexRequest("my_index").id("1").source("{\"key\": \"value\"}", XContentType.JSON))});
        try (AuditLogImpl al = new AuditLogImpl(this.settingsBuilder.put("searchguard.audit.resolve_bulk_requests", true).build(), null, null, IgnoreRequestBodiesTest.newThreadPool(), null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logGrantedPrivileges("indices:data/write/bulk", (TransportRequest)bulkShardRequest, null);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Assert.assertTrue((String)TestAuditlogImpl.messages.get(0).toString(), (boolean)TestAuditlogImpl.messages.get(0).getAsMap().containsKey("audit_request_body"));
        }
        Settings settings = this.settingsBuilder.putList("searchguard.audit.ignore_request_bodies", List.of("BulkRequest", "indices:data/write/bulk", "*/_bulk*")).build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, IgnoreRequestBodiesTest.newThreadPool(), null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logGrantedPrivileges("indices:data/write/bulk", (TransportRequest)bulkShardRequest, null);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Assert.assertFalse((boolean)TestAuditlogImpl.messages.get(0).getAsMap().containsKey("audit_request_body"));
            TestAuditlogImpl.clear();
            UserInformation userInformation = UserInformation.forName((String)"testuser.rest.login");
            MockRestRequest request = new MockRestRequest("/_bulk", "{\"key\":\"value\"}");
            al.logSucceededLogin(userInformation, false, userInformation, (RestRequest)request);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Assert.assertFalse((boolean)TestAuditlogImpl.messages.get(0).getAsMap().containsKey("audit_request_body"));
            TestAuditlogImpl.clear();
            request = new MockRestRequest("/my_index/_bulk", "{\"key\":\"value\"}");
            al.logSucceededLogin(userInformation, false, userInformation, (RestRequest)request);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Assert.assertFalse((boolean)TestAuditlogImpl.messages.get(0).getAsMap().containsKey("audit_request_body"));
        }
    }

    @Test
    public void testIgnoreRequestBodiesClassName() throws Exception {
        SearchRequest searchRequest = new SearchRequest().source(SearchSourceBuilder.searchSource().size(1));
        try (AuditLogImpl al = new AuditLogImpl(this.settingsBuilder.build(), null, null, IgnoreRequestBodiesTest.newThreadPool(), null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)searchRequest, null);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Assert.assertTrue((boolean)TestAuditlogImpl.messages.get(0).getAsMap().containsKey("audit_request_body"));
        }
        Settings settings = this.settingsBuilder.putList("searchguard.audit.ignore_request_bodies", List.of(SearchRequest.class.getSimpleName())).build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, IgnoreRequestBodiesTest.newThreadPool(), null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logGrantedPrivileges("indices:data/read/search", (TransportRequest)searchRequest, null);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Assert.assertFalse((boolean)TestAuditlogImpl.messages.get(0).getAsMap().containsKey("audit_request_body"));
        }
    }

    @Test
    public void testIgnoreRequestBodiesPathPattern() throws Exception {
        UserInformation userInformation = UserInformation.forName((String)"testuser.rest.failedlogin");
        MockRestRequest request = new MockRestRequest("my/path/test", "{\"key\":\"value\"}");
        try (AuditLogImpl al = new AuditLogImpl(this.settingsBuilder.build(), null, null, IgnoreRequestBodiesTest.newThreadPool(), null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logSucceededLogin(userInformation, false, userInformation, (RestRequest)request);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Assert.assertTrue((boolean)TestAuditlogImpl.messages.get(0).getAsMap().containsKey("audit_request_body"));
        }
        Settings settings = this.settingsBuilder.putList("searchguard.audit.ignore_request_bodies", List.of("my/path/*")).build();
        try (AuditLogImpl al = new AuditLogImpl(settings, null, null, IgnoreRequestBodiesTest.newThreadPool(), null, this.cs, this.configurationRepository);){
            TestAuditlogImpl.clear();
            al.logSucceededLogin(userInformation, false, userInformation, (RestRequest)request);
            Assert.assertEquals((long)1L, (long)TestAuditlogImpl.messages.size());
            Assert.assertFalse((boolean)TestAuditlogImpl.messages.get(0).getAsMap().containsKey("audit_request_body"));
        }
    }

    private static ThreadPool newThreadPool() {
        return new ThreadPool(Settings.builder().put("node.name", "mock").build(), MeterRegistry.NOOP, (BuiltInExecutorBuilders)new DefaultBuiltInExecutorBuilders(), new ExecutorBuilder[0]);
    }
}

