/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.integration;

import com.floragunn.searchguard.enterprise.auditlog.AbstractAuditlogiUnitTest;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.ClusterHelper;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import org.apache.http.Header;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SSLAuditlogTest
extends AbstractAuditlogiUnitTest {
    private ClusterInfo monitoringClusterInfo;
    private RestHelper rhMon;
    private final ClusterHelper monitoringCluster = new ClusterHelper("mon_n", 0);

    @After
    public void tearDown() throws Exception {
        this.monitoringCluster.stopCluster();
    }

    private void setupMonitoring() throws Exception {
        this.monitoringClusterInfo = this.monitoringCluster.startCluster(this.minimumSearchGuardSettings(this.defaultNodeSettings(Settings.EMPTY)), ClusterConfiguration.DEFAULT);
        this.initialize((Client)PrivilegedConfigClient.adapt((Client)this.monitoringCluster.nodeClient()), new DynamicSgConfig());
        this.rhMon = new RestHelper(this.monitoringClusterInfo, this.getResourceFolder());
    }

    @Test
    public void testExternalPemUserPass() throws Exception {
        this.setupMonitoring();
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", "external_elasticsearch").put("searchguard.audit.config.http_endpoints", this.monitoringClusterInfo.httpHost + ":" + this.monitoringClusterInfo.httpPort).put("searchguard.audit.threadpool.size", 0).putList("searchguard.audit.ignore_users", new String[]{"*spock*", "admin", "CN=kirk,OU=client,O=client,L=Test,C=DE"}).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.enable_ssl", true).put("searchguard.audit.config.enable_ssl_client_auth", false).put("searchguard.audit.config.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/chain-ca.pem")).put("searchguard.audit.config.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/spock.crtfull.pem")).put("searchguard.audit.config.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/spock.key.pem")).put("searchguard.audit.config.username", "admin").put("searchguard.audit.config.password", "admin").build();
        this.setup(additionalSettings);
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_search", new Header[0]);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Thread.sleep(5000L);
        response = this.rhMon.executeGetRequest("sg7-auditlog*/_refresh", new Header[]{SSLAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rhMon.executeGetRequest("sg7-auditlog*/_search", new Header[]{SSLAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.assertNotContains(response, "*\"hits\":{\"total\":0,*");
        this.assertContains(response, "*\"failed\":0},\"hits\":*");
    }

    @Test
    public void testExternalPemClientAuth() throws Exception {
        this.setupMonitoring();
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", "external_elasticsearch").put("searchguard.audit.config.http_endpoints", this.monitoringClusterInfo.httpHost + ":" + this.monitoringClusterInfo.httpPort).put("searchguard.audit.threadpool.size", 0).putList("searchguard.audit.ignore_users", new String[]{"*spock*", "admin", "CN=kirk,OU=client,O=client,L=Test,C=DE"}).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.enable_ssl", true).put("searchguard.audit.config.enable_ssl_client_auth", true).put("searchguard.audit.config.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/chain-ca.pem")).put("searchguard.audit.config.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/kirk.crtfull.pem")).put("searchguard.audit.config.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/kirk.key.pem")).build();
        this.setup(additionalSettings);
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_search", new Header[0]);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Thread.sleep(5000L);
        response = this.rhMon.executeGetRequest("sg7-auditlog*/_refresh", new Header[]{SSLAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rhMon.executeGetRequest("sg7-auditlog*/_search", new Header[]{SSLAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.assertNotContains(response, "*\"hits\":{\"total\":0,*");
        this.assertContains(response, "*\"failed\":0},\"hits\":*");
    }

    @Test
    public void testExternalPemUserPassTp() throws Exception {
        this.setupMonitoring();
        Settings additionalSettings = Settings.builder().put("searchguard.audit.type", "external_elasticsearch").put("searchguard.audit.config.http_endpoints", this.monitoringClusterInfo.httpHost + ":" + this.monitoringClusterInfo.httpPort).put("searchguard.audit.threadpool.size", 0).putList("searchguard.audit.ignore_users", new String[]{"*spock*", "admin", "CN=kirk,OU=client,O=client,L=Test,C=DE"}).put("searchguard.audit.enable_transport", true).put("searchguard.audit.resolve_bulk_requests", true).put("searchguard.audit.config.enable_ssl", true).put("searchguard.audit.config.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/chain-ca.pem")).put("searchguard.audit.config.username", "admin").put("searchguard.audit.config.password", "admin").build();
        this.setup(additionalSettings);
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_search", new Header[0]);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Thread.sleep(5000L);
        response = this.rhMon.executeGetRequest("sg7-auditlog*/_refresh", new Header[]{SSLAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rhMon.executeGetRequest("sg7-auditlog-*/_search", new Header[]{SSLAuditlogTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.assertNotContains(response, "*\"hits\":{\"total\":0,*");
        this.assertContains(response, "*\"failed\":0},\"hits\":*");
    }
}

