/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.routing;

import com.floragunn.searchguard.enterprise.auditlog.AbstractAuditlogiUnitTest;
import com.floragunn.searchguard.enterprise.auditlog.helper.LoggingSink;
import com.floragunn.searchguard.enterprise.auditlog.helper.MockAuditMessageFactory;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.routing.AuditMessageRouter;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchsupport.util.EsLogging;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

public class PerfTest
extends AbstractAuditlogiUnitTest {
    @ClassRule
    public static EsLogging esLogging = new EsLogging();

    @Test
    @Ignore(value="jvm crash on cci")
    public void testPerf() throws Exception {
        Settings.Builder settingsBuilder = Settings.builder().loadFromPath(FileHelper.getAbsoluteFilePathFromClassPath((String)"auditlog/endpoints/routing/perftest.yml"));
        Settings settings = settingsBuilder.put("path.home", ".").put("searchguard.audit.config.disabled_transport_categories", "NONE").put("searchguard.audit.threadpool.size", 0).build();
        AuditMessageRouter router = this.createMessageRouterComplianceEnabled(settings);
        for (int limit = 150000; limit > 0; --limit) {
            AuditMessage msg = MockAuditMessageFactory.validAuditMessage(AuditMessage.Category.MISSING_PRIVILEGES);
            router.route(msg);
        }
        LoggingSink loggingSink = (LoggingSink)router.defaultSink.getFallbackSink();
        int currentSize = loggingSink.messages.size();
        Assert.assertTrue((currentSize > 0 ? 1 : 0) != 0);
    }
}

