/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auditlog.AuditLogConfig;
import com.floragunn.searchguard.enterprise.auditlog.impl.AbstractAuditLog;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.routing.AuditMessageRouter;
import com.floragunn.searchguard.user.UserInformation;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public final class AuditLogImpl
extends AbstractAuditLog {
    private final AuditMessageRouter messageRouter;
    private final boolean enabled;

    public AuditLogImpl(Settings settings, Path configPath, Client clientProvider, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService, ConfigurationRepository configurationRepository) {
        super(settings, threadPool, resolver, clusterService, configurationRepository);
        this.messageRouter = new AuditMessageRouter(settings, clientProvider, threadPool, configPath);
        this.enabled = this.messageRouter.isEnabled();
        this.log.info("Message routing enabled: {}", (Object)this.enabled);
    }

    @Override
    public void setComplianceConfig(AuditLogConfig complianceConfig) {
        super.setComplianceConfig(complianceConfig);
        this.messageRouter.setComplianceConfig(complianceConfig);
    }

    public void close() throws IOException {
        this.messageRouter.close();
    }

    @Override
    protected void save(AuditMessage msg) {
        if (this.enabled) {
            this.messageRouter.route(msg);
        }
    }

    @Override
    public void logFailedLogin(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, RestRequest request) {
        if (this.enabled) {
            super.logFailedLogin(effectiveUser, sgadmin, initiatingUser, request);
        }
    }

    @Override
    public void logBlockedUser(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, RestRequest request) {
        if (this.enabled) {
            super.logBlockedUser(effectiveUser, sgadmin, initiatingUser, request);
        }
    }

    @Override
    public void logSucceededLogin(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logSucceededLogin(effectiveUser, sgadmin, initiatingUser, request, action, task);
        }
    }

    @Override
    public void logSucceededLogin(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, RestRequest request) {
        if (this.enabled) {
            super.logSucceededLogin(effectiveUser, sgadmin, initiatingUser, request);
        }
    }

    @Override
    public void logMissingPrivileges(String privilege, UserInformation effectiveUser, RestRequest request) {
        if (this.enabled) {
            super.logMissingPrivileges(privilege, effectiveUser, request);
        }
    }

    @Override
    public void logMissingPrivileges(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logMissingPrivileges(privilege, request, task);
        }
    }

    @Override
    public void logGrantedPrivileges(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logGrantedPrivileges(privilege, request, task);
        }
    }

    @Override
    public void logBadHeaders(TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logBadHeaders(request, action, task);
        }
    }

    @Override
    public void logBadHeaders(RestRequest request) {
        if (this.enabled) {
            super.logBadHeaders(request);
        }
    }

    @Override
    public void logBlockedIp(TransportRequest request, String action, TransportAddress remoteAddress, Task task) {
        if (this.enabled) {
            super.logBlockedIp(request, action, remoteAddress, task);
        }
    }

    @Override
    public void logBlockedIp(RestRequest request, InetSocketAddress remoteAddress) {
        if (this.enabled) {
            super.logBlockedIp(request, remoteAddress);
        }
    }

    @Override
    public void logSgIndexAttempt(TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logSgIndexAttempt(request, action, task);
        }
    }

    @Override
    public void logImmutableIndexAttempt(TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logImmutableIndexAttempt(request, action, task);
        }
    }

    @Override
    public void logSSLException(TransportRequest request, Throwable t, String action, Task task) {
        if (this.enabled) {
            super.logSSLException(request, t, action, task);
        }
    }

    @Override
    public void logSSLException(RestRequest request, Throwable t) {
        if (this.enabled) {
            super.logSSLException(request, t);
        }
    }

    @Override
    public void logDocumentRead(String index, String id, ShardId shardId, Map<String, String> fieldNameValues) {
        if (this.enabled) {
            super.logDocumentRead(index, id, shardId, fieldNameValues);
        }
    }

    @Override
    public void logDocumentWritten(ShardId shardId, GetResult originalResult, Engine.Index currentIndex, Engine.IndexResult result) {
        if (this.enabled) {
            super.logDocumentWritten(shardId, originalResult, currentIndex, result);
        }
    }

    @Override
    public void logDocumentDeleted(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        if (this.enabled) {
            super.logDocumentDeleted(shardId, delete, result);
        }
    }
}

